/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.dialogs;

import com.kms.katalon.application.utils.EntityTrackingHelper;
import com.kms.katalon.composer.components.impl.dialogs.CommonNewEntityDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewTestCaseDialog
extends CommonNewEntityDialog<TestCaseEntity> {
    private String tag;

    public NewTestCaseDialog(Shell parentShell, FolderEntity parentFolder, String suggestedName) {
        super(parentShell, parentFolder, suggestedName);
        this.setDialogTitle(GlobalMessageConstants.TEST_CASE);
        this.setDialogMsg(ComposerTestcaseMessageConstants.DIA_MSG_CREATE_NEW_TEST_CASE);
    }

    protected Control createPropertiesControl(Composite parent, int column, int span) {
        super.createPropertiesControl(parent, column, span);
        Label lblTag = new Label(parent, 0);
        lblTag.setText(GlobalMessageConstants.TAG);
        Text txtTag = new Text(parent, 2048);
        txtTag.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtTag.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTestCaseDialog.this.tag = ((Text)e.getSource()).getText();
            }
        });
        if (span > 0) {
            NewTestCaseDialog.createEmptySpace((Composite)parent, (int)span);
        }
        return this.container;
    }

    protected void createEntity() {
        try {
            this.entity = TestCaseController.getInstance().newTestCaseWithoutSave(this.parentFolder, this.getName());
            EntityTrackingHelper.trackTestCaseCreated();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void setEntityProperties() {
        super.setEntityProperties();
        ((TestCaseEntity)this.entity).setTag(StringUtils.trimToEmpty((String)this.tag));
    }

    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    protected void handleShellCloseEvent() {
        if (!DialogUtil.getCanClose((Shell)this.getShell())) {
            return;
        }
        super.handleShellCloseEvent();
    }
}

