/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.AnnonatedNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ImportNode;

public class ImportNodeWrapper
extends AnnonatedNodeWrapper {
    private ClassNodeWrapper type;
    private String alias;
    private String fieldName;
    private String packageName;
    private boolean isStar;
    private boolean isStatic;

    public ImportNodeWrapper(Class<?> type, String fieldName, ASTNodeWrapper parentNodeWrapper, boolean isStatic) {
        this(type, parentNodeWrapper);
        this.fieldName = fieldName;
        this.isStatic = isStatic;
    }

    public ImportNodeWrapper(Class<?> type, ASTNodeWrapper parentNodeWrapper) {
        this(type, parentNodeWrapper, null);
    }

    public ImportNodeWrapper(Class<?> type, ASTNodeWrapper parentNodeWrapper, String alias) {
        super(parentNodeWrapper);
        this.type = new ClassNodeWrapper(type, (ASTNodeWrapper)this);
        this.alias = alias;
        this.isStar = false;
        this.isStatic = false;
        this.packageName = null;
        this.fieldName = null;
    }

    public ImportNodeWrapper(ImportNodeWrapper importNodeWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(importNodeWrapper, parentNodeWrapper);
        this.type = new ClassNodeWrapper(importNodeWrapper.getType(), (ASTNodeWrapper)this);
        this.alias = importNodeWrapper.getAlias();
        this.fieldName = importNodeWrapper.getFieldName();
        this.packageName = importNodeWrapper.getPackageName();
        this.isStar = importNodeWrapper.isStar();
        this.isStatic = importNodeWrapper.isStatic();
    }

    public ImportNodeWrapper(ImportNode importNode, ASTNodeWrapper parentNodeWrapper) {
        super((AnnotatedNode)importNode, parentNodeWrapper);
        if (importNode.getType() != null) {
            this.type = ClassNodeWrapper.getClassWrapper(importNode.getType(), this);
        }
        this.alias = importNode.getAlias();
        this.fieldName = importNode.getFieldName();
        this.packageName = importNode.getPackageName();
        this.isStar = importNode.isStar();
        this.isStatic = importNode.isStatic();
    }

    public ImportNodeWrapper(String className, String classNameWithoutPackage, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.type = new ClassNodeWrapper(className, classNameWithoutPackage, this);
        this.isStar = false;
        this.isStatic = false;
        this.packageName = null;
        this.fieldName = null;
        this.alias = classNameWithoutPackage;
    }

    public ClassNodeWrapper getType() {
        return this.type;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getKnownAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.fieldName != null) {
            return this.fieldName;
        }
        return this.getType().getNameWithoutPackage();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isStar() {
        return this.isStar;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getClassName() {
        return this.type == null ? null : this.type.getName();
    }

    @Override
    public String getText() {
        String typeName;
        String string = typeName = this.type == null ? null : this.type.getName();
        if (this.isStar && !this.isStatic) {
            return "import " + this.packageName + "*";
        }
        if (this.isStar) {
            return "import static " + typeName + ".*";
        }
        if (this.isStatic) {
            if (this.alias != null && this.alias.length() != 0 && !this.alias.equals(this.fieldName)) {
                return "import static " + typeName + "." + this.fieldName + " as " + this.alias;
            }
            return "import static " + typeName + "." + this.fieldName;
        }
        if (this.alias == null || this.alias.length() == 0) {
            return "import " + typeName;
        }
        return "import " + typeName + " as " + this.alias;
    }

    @Override
    public boolean hasAstChildren() {
        return false;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        return Collections.emptyList();
    }

    @Override
    public ImportNodeWrapper clone() {
        return new ImportNodeWrapper(this, this.getParent());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.isStar ? 1231 : 1237);
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImportNodeWrapper other = (ImportNodeWrapper)obj;
        return this.getText().equals(other.getText());
    }
}

