/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;

public class ConstantExpressionWrapper
extends ExpressionWrapper {
    private Object value;

    public ConstantExpressionWrapper() {
        this((ASTNodeWrapper)null);
    }

    public ConstantExpressionWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
    }

    public ConstantExpressionWrapper(Object value) {
        this(value, null);
    }

    public ConstantExpressionWrapper(Object value, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.setValue(value);
    }

    public ConstantExpressionWrapper(ConstantExpression constantExpression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)constantExpression, parentNodeWrapper);
        Object value = constantExpression.getValue();
        if (value instanceof String) {
            value = GroovyWrapperParser.unescapeJavaString((String)value);
        }
        this.setValue(value);
    }

    public ConstantExpressionWrapper(ConstantExpressionWrapper constantExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(constantExpressionWrapper, parentNodeWrapper);
        this.setValue(constantExpressionWrapper.getValue());
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return String.valueOf(this.value);
    }

    public void setValue(Object value) {
        this.value = value;
        this.setValueType();
    }

    private void setValueType() {
        if (this.value == null) {
            return;
        }
        this.setType(ClassNodeWrapper.getClassWrapper(ClassHelper.make(this.value.getClass()), this));
    }

    @Override
    public String getText() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof String) {
            return "\"" + this.value.toString() + "\"";
        }
        if (this.value instanceof Character) {
            return "'" + this.value.toString() + "'";
        }
        return this.value.toString();
    }

    @Override
    public ConstantExpressionWrapper clone() {
        return new ConstantExpressionWrapper(this, this.getParent());
    }

    public boolean isNullExpression() {
        return this.value == null;
    }

    public boolean isNumberExpression() {
        return this.value instanceof Number;
    }

    public boolean isBooleanExpression() {
        return this.isTrueExpression() || this.isFalseExpression();
    }

    public boolean isTrueExpression() {
        return Boolean.TRUE.equals(this.value);
    }

    public boolean isFalseExpression() {
        return Boolean.FALSE.equals(this.value);
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof ConstantExpressionWrapper) || this.isEqualsTo(input)) {
            return false;
        }
        this.setValue(((ConstantExpressionWrapper)input).getValue());
        return true;
    }
}

