/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapEntryExpressionWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;

public class MapExpressionWrapper
extends ExpressionWrapper {
    private List<MapEntryExpressionWrapper> mapEntryExpressions = new ArrayList<MapEntryExpressionWrapper>();

    public MapExpressionWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.type = ClassNodeWrapper.getClassWrapper(ClassHelper.MAP_TYPE, this);
    }

    public MapExpressionWrapper(List<MapEntryExpressionWrapper> mapEntryExpressions, ASTNodeWrapper parentNodeWrapper) {
        this(parentNodeWrapper);
        if (mapEntryExpressions == null) {
            return;
        }
        for (MapEntryExpressionWrapper mapEntryExpression : mapEntryExpressions) {
            if (mapEntryExpression == null) continue;
            mapEntryExpression.setParent(this);
        }
        this.mapEntryExpressions = mapEntryExpressions;
        this.type = ClassNodeWrapper.getClassWrapper(ClassHelper.MAP_TYPE, this);
    }

    public MapExpressionWrapper(MapExpression expression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)expression, parentNodeWrapper);
        for (MapEntryExpression mapEntryExpression : expression.getMapEntryExpressions()) {
            this.mapEntryExpressions.add(new MapEntryExpressionWrapper(mapEntryExpression, (ASTNodeWrapper)this));
        }
    }

    public MapExpressionWrapper(MapExpressionWrapper mapExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(mapExpressionWrapper, parentNodeWrapper);
        this.copyMapProperties(mapExpressionWrapper);
    }

    private void copyMapProperties(MapExpressionWrapper mapExpressionWrapper) {
        for (MapEntryExpressionWrapper mapEntryExpressionWrapper : mapExpressionWrapper.getMapEntryExpressions()) {
            this.mapEntryExpressions.add(new MapEntryExpressionWrapper(mapEntryExpressionWrapper, (ASTNodeWrapper)this));
        }
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[");
        int size = this.mapEntryExpressions.size();
        if (size > 0) {
            sb.append(this.mapEntryExpressions.get(0).getText());
            int i = 1;
            while (i < size) {
                sb.append(", " + this.mapEntryExpressions.get(i).getText());
                if (sb.length() > 120 && i < size - 1) {
                    sb.append(", ... ");
                    break;
                }
                ++i;
            }
        } else {
            sb.append(":");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    public List<ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.addAll(this.mapEntryExpressions);
        return astNodeWrappers;
    }

    public List<MapEntryExpressionWrapper> getMapEntryExpressions() {
        return Collections.unmodifiableList(this.mapEntryExpressions);
    }

    public void addExpression(MapEntryExpressionWrapper expression) {
        if (expression == null) {
            return;
        }
        expression.setParent(this);
        this.mapEntryExpressions.add(expression);
    }

    public boolean addExpression(MapEntryExpressionWrapper expression, int index) {
        if (expression == null || index < 0 || index > this.mapEntryExpressions.size()) {
            return false;
        }
        expression.setParent(this);
        this.mapEntryExpressions.add(index, expression);
        return true;
    }

    public void addExpressions(List<MapEntryExpressionWrapper> listOfExpressions) {
        if (listOfExpressions == null) {
            return;
        }
        for (MapEntryExpressionWrapper expression : listOfExpressions) {
            if (expression == null) continue;
            expression.setParent(this);
            this.mapEntryExpressions.add(expression);
        }
    }

    public boolean removeExpression(MapEntryExpressionWrapper expression) {
        return this.mapEntryExpressions.remove(expression);
    }

    public boolean removeExpression(int index) {
        if (index < 0 || index >= this.mapEntryExpressions.size()) {
            return false;
        }
        this.mapEntryExpressions.remove(index);
        return true;
    }

    public void clearExpressions() {
        this.mapEntryExpressions.clear();
    }

    public boolean setExpression(MapEntryExpressionWrapper expression, int index) {
        if (expression == null || index < 0 || index > this.mapEntryExpressions.size()) {
            return false;
        }
        expression.setParent(this);
        this.mapEntryExpressions.set(index, expression);
        return true;
    }

    @Override
    public MapExpressionWrapper clone() {
        return new MapExpressionWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof MapExpressionWrapper) || this.isEqualsTo(input)) {
            return false;
        }
        this.copyMapProperties((MapExpressionWrapper)input);
        return true;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (!(newChild instanceof ExpressionWrapper) || !(oldChild instanceof ExpressionWrapper)) {
            return false;
        }
        ExpressionWrapper originalExpression = (ExpressionWrapper)oldChild;
        ExpressionWrapper newExpression = (ExpressionWrapper)newChild;
        for (MapEntryExpressionWrapper mapEntry : this.getMapEntryExpressions()) {
            if (mapEntry.getKeyExpression() == originalExpression) {
                mapEntry.setKeyExpression(newExpression);
                return true;
            }
            if (mapEntry.getValueExpression() != originalExpression) continue;
            mapEntry.setValueExpression(newExpression);
            return true;
        }
        return false;
    }
}

