/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;

public class MethodPointerExpressionWrapper
extends ExpressionWrapper {
    private ExpressionWrapper expression;
    private ExpressionWrapper methodName;

    public MethodPointerExpressionWrapper(ExpressionWrapper expression, ExpressionWrapper methodName, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.expression = expression;
        this.methodName = methodName;
    }

    public MethodPointerExpressionWrapper(MethodPointerExpression methodPointerExpression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)methodPointerExpression, parentNodeWrapper);
        this.expression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(methodPointerExpression.getExpression(), this);
        this.methodName = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(methodPointerExpression.getMethodName(), this);
    }

    public MethodPointerExpressionWrapper(MethodPointerExpressionWrapper methodPointerExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(methodPointerExpressionWrapper, parentNodeWrapper);
        this.expression = methodPointerExpressionWrapper.getExpression().copy(this);
        this.methodName = methodPointerExpressionWrapper.getMethodName().copy(this);
    }

    public ExpressionWrapper getExpression() {
        return this.expression;
    }

    public ExpressionWrapper getMethodName() {
        return this.methodName;
    }

    @Override
    public String getText() {
        if (this.expression == null) {
            return "&" + this.methodName.getText();
        }
        return String.valueOf(this.expression.getText()) + ".&" + this.methodName.getText();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    public List<ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.expression);
        astNodeWrappers.add(this.methodName);
        return astNodeWrappers;
    }

    @Override
    public MethodPointerExpressionWrapper clone() {
        return new MethodPointerExpressionWrapper(this, this.getParent());
    }
}

