/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.handlers;

import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.preferences.TestCaseSettingStore;
import com.kms.katalon.controller.EntityTagController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CollectTestCaseTagHandler {
    @Inject
    private IEventBroker eventBroker;
    private EntityTagController tagController;

    @PostConstruct
    public void initialize() {
        this.tagController = EntityTagController.getInstance();
        this.registerEventListeners();
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("TESTCASE/UPDATED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                try {
                    ProjectEntity project = CollectTestCaseTagHandler.this.getCurrentProject();
                    TestCaseSettingStore store = CollectTestCaseTagHandler.this.getStore(project);
                    TestCaseEntity updatedTestCase = (TestCaseEntity)this.getObjects(event)[1];
                    Set<String> allTagsInProject = store.getTestCaseTags();
                    Set updatedTestCaseTags = CollectTestCaseTagHandler.this.tagController.collectTestCaseTags(updatedTestCase);
                    allTagsInProject.addAll(updatedTestCaseTags);
                    store.saveTestCaseTags(allTagsInProject);
                }
                catch (IOException | GeneralSecurityException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
    }

    private TestCaseSettingStore getStore(ProjectEntity project) {
        TestCaseSettingStore store = new TestCaseSettingStore(project.getFolderLocation());
        return store;
    }

    private ProjectEntity getCurrentProject() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        return project;
    }
}

