/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.listeners;

import com.kms.katalon.composer.components.impl.dialogs.TestDataSelectionDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ToolItemConstants;
import com.kms.katalon.composer.testcase.parts.TestCasePartDataBindingView;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class TestDataToolItemListener
extends SelectionAdapter {
    private TableViewer tableViewer;
    private TestCasePartDataBindingView view;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    public TestDataToolItemListener(TableViewer treeViewer, TestCasePartDataBindingView view) {
        this.tableViewer = treeViewer;
        this.view = view;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == null) {
            return;
        }
        if (e.getSource() instanceof ToolItem) {
            this.toolItemSelected(e);
        } else if (e.getSource() instanceof MenuItem) {
            this.menuItemSelected(e);
        }
    }

    private void toolItemSelected(SelectionEvent e) {
        ToolItem toolItem = (ToolItem)e.getSource();
        String text = toolItem.getText();
        if (text == null) {
            return;
        }
        if (ToolItemConstants.ADD.equals(text)) {
            if (e.detail == 4) {
                this.createDropdownMenuAddItem(toolItem);
            } else {
                this.performAddTestDataLink(ToolItemConstants.ADD_AFTER);
            }
            return;
        }
        if (ToolItemConstants.DELETE.equals(text)) {
            this.removeTestDataLink();
            return;
        }
        if (ToolItemConstants.UP.equals(text)) {
            this.upTestDataLink();
            return;
        }
        if (ToolItemConstants.DOWN.equals(text)) {
            this.downTestDataLink();
            return;
        }
        if (ToolItemConstants.MAPALL.equals(text)) {
            this.mapAllTestDataLink();
        }
    }

    private void menuItemSelected(SelectionEvent e) {
        MenuItem menuItem = (MenuItem)e.getSource();
        String text = menuItem.getText();
        if (text == null) {
            return;
        }
        if (ToolItemConstants.ADD_AFTER.equals(text)) {
            this.performAddTestDataLink(ToolItemConstants.ADD_AFTER);
            return;
        }
        if (ToolItemConstants.ADD_BEFORE.equals(text)) {
            this.performAddTestDataLink(ToolItemConstants.ADD_BEFORE);
        }
    }

    private void createDropdownMenuAddItem(ToolItem toolItemAdd) {
        Rectangle rect = toolItemAdd.getBounds();
        Point pt = toolItemAdd.getParent().toDisplay(new Point(rect.x, rect.y));
        Menu menu = new Menu((Control)toolItemAdd.getParent().getShell());
        MenuItem mnAddBefore = new MenuItem(menu, 0);
        mnAddBefore.setText(ToolItemConstants.ADD_BEFORE);
        mnAddBefore.addSelectionListener((SelectionListener)this);
        MenuItem mnAddAfter = new MenuItem(menu, 0);
        mnAddAfter.setText(ToolItemConstants.ADD_AFTER);
        mnAddAfter.addSelectionListener((SelectionListener)this);
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }

    private void performAddTestDataLink(String offset) {
        try {
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            if (currentProject == null) {
                return;
            }
            boolean isEnableMultipleDataSource = this.featureService.canUse(KSEFeature.MULTIPLE_DATA_SOURCE_COMBINATION);
            if (!isEnableMultipleDataSource) {
                KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.TEST_CASE_DATA_BINDING);
                return;
            }
            EntityProvider entityProvider = new EntityProvider();
            TestDataSelectionDialog dialog = new TestDataSelectionDialog(this.tableViewer.getTable().getShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter(entityProvider));
            FolderEntity rootFolder = FolderController.getInstance().getTestDataRoot(currentProject);
            dialog.setInput((Object)TreeEntityUtil.getChildren(null, (FolderEntity)rootFolder));
            if (dialog.open() == 0 && dialog.getResult() != null) {
                ArrayList<DataFileEntity> dataFileEntities = new ArrayList<DataFileEntity>();
                Object[] objectArray = dialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object childResult = objectArray[n2];
                    if (childResult instanceof TestDataTreeEntity) {
                        DataFileEntity testData = ((TestDataTreeEntity)childResult).getObject();
                        if (testData != null) {
                            dataFileEntities.add(testData);
                        }
                    } else if (childResult instanceof FolderTreeEntity) {
                        dataFileEntities.addAll(this.getTestDatasFromFolderTree((FolderTreeEntity)childResult));
                    }
                    ++n2;
                }
                List<TestCaseTestDataLink> addedTestDataLinkTreeNodes = this.addTestDataToTreeView(dataFileEntities, offset);
                if (addedTestDataLinkTreeNodes.size() > 0) {
                    this.tableViewer.refresh();
                    this.tableViewer.setSelection((ISelection)new StructuredSelection(addedTestDataLinkTreeNodes));
                    this.view.refreshTestDataTable();
                    this.view.setDirty(true);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.LIS_ERROR_MSG_UNABLE_TO_ADD_TEST_DATA);
        }
    }

    private List<TestCaseTestDataLink> getTableItems() {
        return this.view.getTestCaseTestDataLinks();
    }

    private List<TestCaseTestDataLink> addTestDataToTreeView(List<DataFileEntity> testDataEntities, String offset) throws Exception {
        ArrayList<TestCaseTestDataLink> addedTestDataLinkTreeNodes = new ArrayList<TestCaseTestDataLink>();
        int selectedIndex = this.tableViewer.getTable().getSelectionIndex();
        int i = 0;
        while (i < testDataEntities.size()) {
            DataFileEntity testData = testDataEntities.get(i);
            TestCaseTestDataLink newTestDataLink = this.createTestDataLink(testData);
            if (ToolItemConstants.ADD_AFTER.equals(offset)) {
                if (selectedIndex < 0) {
                    int itemCount = this.tableViewer.getTable().getItemCount();
                    this.getTableItems().add(itemCount, newTestDataLink);
                    selectedIndex = itemCount;
                } else {
                    this.getTableItems().add(selectedIndex + 1, newTestDataLink);
                    ++selectedIndex;
                }
            } else if (ToolItemConstants.ADD_BEFORE.equals(offset)) {
                if (selectedIndex <= 0) {
                    this.getTableItems().add(0, newTestDataLink);
                    selectedIndex = 1;
                } else {
                    this.getTableItems().add(selectedIndex, newTestDataLink);
                    ++selectedIndex;
                }
            }
            addedTestDataLinkTreeNodes.add(newTestDataLink);
            ++i;
        }
        this.view.setTestCaseTestDataLinks(this.getTableItems());
        return addedTestDataLinkTreeNodes;
    }

    private TestCaseTestDataLink createTestDataLink(DataFileEntity testData) throws Exception {
        TestCaseTestDataLink testDataLink = new TestCaseTestDataLink();
        testDataLink.setTestDataId(testData.getIdForDisplay());
        return testDataLink;
    }

    private void removeTestDataLink() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        for (TestCaseTestDataLink linkNode : selection.toList()) {
            for (VariableLink variableLink : this.view.getListVariableLink()) {
                if (variableLink.getType() != VariableLink.VariableType.DATA_COLUMN && variableLink.getType() != VariableLink.VariableType.DATA_COLUMN_INDEX || !variableLink.getTestDataLinkId().equals(linkNode.getId())) continue;
                variableLink.setTestDataLinkId("");
                variableLink.setValue("");
            }
        }
        this.getTableItems().removeAll(selection.toList());
        this.tableViewer.refresh();
        this.view.refreshTestDataTable();
        this.view.refreshVariableBindingTable();
        this.view.setDirty(true);
    }

    private void upTestDataLink() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        List selectedLinks = selection.toList();
        this.sortListByAscending(this.getTableItems(), selectedLinks);
        boolean needToRefresh = false;
        for (TestCaseTestDataLink selectedLink : selectedLinks) {
            TestCaseTestDataLink linkBefore;
            int selectedIndex = this.getTableItems().indexOf(selectedLink);
            if (selectedIndex <= 0 || selectedLinks.contains(linkBefore = this.getTableItems().get(selectedIndex - 1))) continue;
            Collections.swap(this.getTableItems(), selectedIndex - 1, selectedIndex);
            needToRefresh = true;
        }
        if (needToRefresh) {
            this.tableViewer.refresh();
            this.view.refreshTestDataTable();
            this.view.setDirty(true);
        }
    }

    private void downTestDataLink() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        List selectedLinks = selection.toList();
        this.sortListByDescending(this.getTableItems(), selectedLinks);
        boolean needToRefresh = false;
        for (TestCaseTestDataLink selectedLink : selectedLinks) {
            TestCaseTestDataLink linkAfter;
            int selectedIndex = this.getTableItems().indexOf(selectedLink);
            if (selectedIndex >= this.getTableItems().size() - 1 || selectedLinks.contains(linkAfter = this.getTableItems().get(selectedIndex + 1))) continue;
            Collections.swap(this.getTableItems(), selectedIndex, selectedIndex + 1);
            needToRefresh = true;
        }
        if (needToRefresh) {
            this.tableViewer.refresh();
            this.view.refreshTestDataTable();
            this.view.setDirty(true);
        }
    }

    private void sortListByAscending(final List<TestCaseTestDataLink> data, List<TestCaseTestDataLink> testDataLinks) {
        Collections.sort(testDataLinks, new Comparator<TestCaseTestDataLink>(){

            @Override
            public int compare(TestCaseTestDataLink arg0, TestCaseTestDataLink arg1) {
                return data.indexOf(arg0) - data.indexOf(arg1);
            }
        });
    }

    private void sortListByDescending(final List<TestCaseTestDataLink> data, List<TestCaseTestDataLink> testDataLinks) {
        Collections.sort(testDataLinks, new Comparator<TestCaseTestDataLink>(){

            @Override
            public int compare(TestCaseTestDataLink arg0, TestCaseTestDataLink arg1) {
                return data.indexOf(arg1) - data.indexOf(arg0);
            }
        });
    }

    private void mapAllTestDataLink() {
        LinkedHashMap<String, String[]> columnNameHashmap = new LinkedHashMap<String, String[]>();
        LinkedHashMap<String, TestCaseTestDataLink> dataLinkHashMap = new LinkedHashMap<String, TestCaseTestDataLink>();
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        for (TestCaseTestDataLink dataLink : this.view.getTestCaseTestDataLinks()) {
            try {
                String[] columnNames;
                TestData testData = TestDataController.getInstance().getTestDataInstance(dataLink.getTestDataId(), projectEntity.getFolderLocation());
                if (testData == null || (columnNames = testData.getColumnNames()) == null) continue;
                columnNameHashmap.put(dataLink.getId(), columnNames);
                dataLinkHashMap.put(dataLink.getId(), dataLink);
            }
            catch (Exception exception) {}
        }
        try {
            int matches = 0;
            block5: for (VariableLink variableLink : this.view.getListVariableLink()) {
                VariableEntity variable = this.getVariable(variableLink.getVariableId());
                if (variable == null) continue;
                for (Map.Entry entry : columnNameHashmap.entrySet()) {
                    boolean isFound = false;
                    String[] stringArray = (String[])entry.getValue();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String columnName = stringArray[n2];
                        if (variable.getName().equalsIgnoreCase(columnName)) {
                            TestCaseTestDataLink dataLink = (TestCaseTestDataLink)dataLinkHashMap.get(entry.getKey());
                            variableLink.setType(VariableLink.VariableType.DATA_COLUMN);
                            variableLink.setTestDataLinkId(dataLink.getId());
                            variableLink.setValue(columnName);
                            ++matches;
                            isFound = true;
                        }
                        ++n2;
                    }
                    if (isFound) continue block5;
                }
            }
            MessageDialog.openInformation(null, (String)GlobalMessageConstants.INFO, (String)MessageFormat.format(ComposerTestcaseMessageConstants.LIS_INFO_MSG_MAP_DONE, Integer.toString(matches)));
            if (matches > 0) {
                this.view.refreshVariableBindingTable();
                this.view.setDirty(true);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private VariableEntity getVariable(String variableId) {
        if (variableId == null) {
            throw new IllegalArgumentException(ComposerTestcaseMessageConstants.CTRL_EXC_VAR_ID_CANNOT_BE_NULL);
        }
        for (VariableEntity variable : this.view.getVariablesList()) {
            if (!variableId.equals(variable.getId())) continue;
            return variable;
        }
        return null;
    }

    private List<DataFileEntity> getTestDatasFromFolderTree(FolderTreeEntity folderTree) {
        ArrayList<DataFileEntity> lstTestData = new ArrayList<DataFileEntity>();
        try {
            Object[] objectArray = folderTree.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof TestDataTreeEntity) {
                    DataFileEntity dataFile = ((TestDataTreeEntity)child).getObject();
                    if (dataFile != null) {
                        lstTestData.add(dataFile);
                    }
                } else if (child instanceof FolderTreeEntity) {
                    lstTestData.addAll(this.getTestDatasFromFolderTree((FolderTreeEntity)child));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return lstTestData;
    }
}

