/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.util;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.MethodNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.CastExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.model.InputParameter;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.ast.GroovyParser;
import com.kms.katalon.core.checkpoint.Checkpoint;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.WindowsTestObject;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.custom.keyword.KeywordParameter;
import com.kms.katalon.execution.setting.TestCaseSettingStore;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;

public class AstKeywordsInputUtil {
    public static ExpressionStatementWrapper createNewCustomKeywordStatement(ASTNodeWrapper parentNode) {
        List customKeywords = KeywordController.getInstance().getCustomKeywords(ProjectController.getInstance().getCurrentProject());
        if (customKeywords == null || customKeywords.isEmpty()) {
            return null;
        }
        MethodNode defaultCustomKeyword = (MethodNode)customKeywords.get(0);
        return AstKeywordsInputUtil.createNewCustomKeywordStatement(defaultCustomKeyword.getDeclaringClass().getName(), KeywordController.getInstance().getCustomKeywordName(defaultCustomKeyword.getName()), parentNode);
    }

    public static ExpressionStatementWrapper createNewCustomKeywordStatement(String keywordClass, String keywordName, ASTNodeWrapper parentNode) {
        return new ExpressionStatementWrapper(AstKeywordsInputUtil.generateCustomKeywordExpression(keywordClass, keywordName, null), parentNode);
    }

    public static ExpressionStatementWrapper createBuiltInKeywordStatement(String classSimpleName, String keyword, ASTNodeWrapper parentNode) {
        return new ExpressionStatementWrapper(AstKeywordsInputUtil.generateBuiltInKeywordExpression(classSimpleName, keyword, null), parentNode);
    }

    public static List<InputParameter> generateBuiltInKeywordInputParameters(String buitInKWClassSimpleName, String keyword, ArgumentListExpressionWrapper argumentListExpression) {
        if (argumentListExpression == null) {
            return null;
        }
        KeywordMethod keywordMethod = KeywordController.getInstance().getBuiltInKeywordByName(buitInKWClassSimpleName, keyword, argumentListExpression.getArgumentListParameterTypes());
        if (keywordMethod == null || keywordMethod.getParameters().length == 0) {
            return Collections.emptyList();
        }
        return AstKeywordsInputUtil.generateInputParameters(keywordMethod, argumentListExpression);
    }

    public static List<InputParameter> generateCustomKeywordInputParameters(String className, String keywordName, ArgumentListExpressionWrapper argumentListExpression) {
        if (argumentListExpression == null) {
            return null;
        }
        MethodNode keywordMethod = KeywordController.getInstance().getCustomKeywordByName(className, keywordName, ProjectController.getInstance().getCurrentProject());
        return AstKeywordsInputUtil.generateInputParameters(new MethodNodeWrapper(keywordMethod, null), argumentListExpression);
    }

    public static List<InputParameter> generateInputParameters(KeywordMethod keywordMethod, ArgumentListExpressionWrapper argumentListExpression) {
        ArrayList<InputParameter> inputParameters = new ArrayList<InputParameter>();
        int i = 0;
        while (i < keywordMethod.getParameters().length) {
            KeywordParameter keywordParam = keywordMethod.getParameters()[i];
            ExpressionWrapper value = argumentListExpression.getExpressions().size() > i ? argumentListExpression.getExpression(i) : null;
            inputParameters.add(new InputParameter(keywordParam, (Object)value));
            ++i;
        }
        return inputParameters;
    }

    public static List<InputParameter> generateInputParameters(MethodNodeWrapper method, ArgumentListExpressionWrapper argumentListExpression) {
        if (method == null || argumentListExpression == null || method.getParameters().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<InputParameter> inputParameters = new ArrayList<InputParameter>();
        int i = 0;
        while (i < method.getParameters().length) {
            ParameterWrapper inputParameter = method.getParameters()[i];
            ExpressionWrapper value = argumentListExpression.getExpressions().size() > i ? argumentListExpression.getExpression(i) : null;
            inputParameters.add(new InputParameter(inputParameter, (Object)value));
            ++i;
        }
        return inputParameters;
    }

    public static List<InputParameter> generateInputParameters(Method method, ArgumentListExpressionWrapper argumentListExpression) {
        if (method == null || argumentListExpression == null || method.getParameterTypes().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<InputParameter> inputParameters = new ArrayList<InputParameter>();
        int i = 0;
        while (i < method.getParameterTypes().length) {
            Class<?> inputParameterType = method.getParameterTypes()[i];
            ExpressionWrapper value = argumentListExpression.getExpressions().size() > i ? argumentListExpression.getExpression(i) : null;
            inputParameters.add(new InputParameter(inputParameterType, (Object)value));
            ++i;
        }
        return inputParameters;
    }

    public static PropertyExpressionWrapper createPropertyExpressionForClass(String className, ASTNodeWrapper parentNode) {
        if (className.equals(FailureHandling.class.getName()) || className.equals(FailureHandling.class.getSimpleName())) {
            return AstKeywordsInputUtil.getNewFailureHandlingPropertyExpression(parentNode);
        }
        return AstKeywordsInputUtil.createPropertyExpressionForClassFromPath(className, null);
    }

    public static PropertyExpressionWrapper getNewFailureHandlingPropertyExpression(ASTNodeWrapper parentNode) {
        FailureHandling defaultFailureHandling = new TestCaseSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation()).getDefaultFailureHandling();
        return new PropertyExpressionWrapper(FailureHandling.class.getSimpleName(), defaultFailureHandling.name(), parentNode);
    }

    private static PropertyExpressionWrapper createPropertyExpressionForClassFromPath(String parentPath, String childName) {
        if (!parentPath.contains(".")) {
            return new PropertyExpressionWrapper(parentPath, childName);
        }
        PropertyExpressionWrapper childPropertyExpression = AstKeywordsInputUtil.createPropertyExpressionForClassFromPath(parentPath.substring(0, parentPath.lastIndexOf(".")), parentPath.substring(parentPath.lastIndexOf(".") + 1));
        if (childName != null) {
            PropertyExpressionWrapper newPropertyExpression = new PropertyExpressionWrapper();
            newPropertyExpression.setObjectExpression(childPropertyExpression);
            newPropertyExpression.setProperty(new ConstantExpressionWrapper(childName, (ASTNodeWrapper)newPropertyExpression));
            childPropertyExpression.setParent(newPropertyExpression);
            return newPropertyExpression;
        }
        return childPropertyExpression;
    }

    public static MethodCallExpressionWrapper generateBuiltInKeywordExpression(String keywordClassName, String keywordMethodName, ASTNodeWrapper parentNode) {
        return AstKeywordsInputUtil.generateBuiltInKeywordExpression(keywordClassName, keywordMethodName, null, parentNode);
    }

    public static MethodCallExpressionWrapper generateBuiltInKeywordExpression(String keywordClassName, String keywordMethodName, ArgumentListExpressionWrapper currentArguments, ASTNodeWrapper parentNode) {
        MethodCallExpressionWrapper keywordMethodCallExpression = new MethodCallExpressionWrapper(keywordClassName, keywordMethodName, parentNode);
        KeywordController keywordController = KeywordController.getInstance();
        KeywordClass keywordClass = keywordController.getBuiltInKeywordClassByName(keywordClassName);
        if (keywordClass == null) {
            return keywordMethodCallExpression;
        }
        KeywordMethod keywordMethod = keywordController.getBuiltInKeywordByName(keywordClass.getName(), keywordMethodName, currentArguments != null ? currentArguments.getArgumentListParameterTypes() : null);
        if (keywordMethod == null) {
            keywordMethod = keywordController.getBuiltInKeywordByName(keywordClassName, keywordMethodName);
        }
        if (keywordMethod != null) {
            AstKeywordsInputUtil.generateMethodCallArguments(keywordMethodCallExpression, currentArguments, keywordMethod);
        }
        return keywordMethodCallExpression;
    }

    public static void generateMethodCallArguments(MethodCallExpressionWrapper keywordCallExpression, KeywordMethod keywordMethod) {
        AstKeywordsInputUtil.generateMethodCallArguments(keywordCallExpression, null, keywordMethod);
    }

    public static void generateMethodCallArguments(MethodCallExpressionWrapper keywordCallExpression, ArgumentListExpressionWrapper currentArguments, KeywordMethod keywordMethod) {
        ArgumentListExpressionWrapper parentNode = keywordCallExpression.getArguments();
        ArrayList exisitingArgumentList = currentArguments != null ? currentArguments.getExpressions() : new ArrayList();
        ArrayList<ExpressionWrapper> newArgumentList = new ArrayList<ExpressionWrapper>();
        String keywordName = keywordMethod.getName();
        int i = 0;
        while (i < keywordMethod.getParameters().length) {
            ExpressionWrapper existingParam = i < exisitingArgumentList.size() ? (ExpressionWrapper)exisitingArgumentList.get(i) : null;
            KeywordParameter keywordParam = keywordMethod.getParameters()[i];
            newArgumentList.add(AstKeywordsInputUtil.generateExpressionForKeyword(keywordName, keywordParam, existingParam, (ASTNodeWrapper)parentNode));
            ++i;
        }
        parentNode.setExpressions(newArgumentList);
    }

    public static void generateMethodCallArguments(MethodCallExpressionWrapper keywordCallExpression, Method method) {
        ArgumentListExpressionWrapper parentNode = keywordCallExpression.getArguments();
        List<ExpressionWrapper> exisitingArgumentList = parentNode.getExpressions();
        ArrayList<ExpressionWrapper> newArgumentList = new ArrayList<ExpressionWrapper>();
        String methodName = method.getName();
        int i = 0;
        while (i < method.getParameterTypes().length) {
            Class<?> keywordParam = method.getParameterTypes()[i];
            ExpressionWrapper existingParam = i < exisitingArgumentList.size() ? exisitingArgumentList.get(i) : null;
            newArgumentList.add(AstKeywordsInputUtil.generateExpressionForKeyword(methodName, keywordParam, existingParam, parentNode));
            ++i;
        }
        parentNode.setExpressions(newArgumentList);
    }

    public static MethodCallExpressionWrapper generateCustomKeywordExpression(String className, String methodName, ASTNodeWrapper parentNode) {
        return AstKeywordsInputUtil.generateCustomKeywordExpression(className, methodName, null, parentNode);
    }

    public static MethodCallExpressionWrapper generateCustomKeywordExpression(String className, String methodName, ArgumentListExpressionWrapper currentArguments, ASTNodeWrapper parentNode) {
        MethodCallExpressionWrapper keywordCallExpression = new MethodCallExpressionWrapper(className, methodName, parentNode);
        MethodNode keywordMethod = KeywordController.getInstance().getCustomKeywordByName(className, methodName, ProjectController.getInstance().getCurrentProject());
        if (keywordMethod == null) {
            return keywordCallExpression;
        }
        ArgumentListExpressionWrapper argumentListExpression = keywordCallExpression.getArguments();
        ArrayList exisitingArgumentList = currentArguments != null ? currentArguments.getExpressions() : new ArrayList();
        ArrayList<ExpressionWrapper> newArgumentList = new ArrayList<ExpressionWrapper>();
        int i = 0;
        while (i < keywordMethod.getParameters().length) {
            ClassNode classNode = keywordMethod.getParameters()[i].getType();
            if (classNode != null) {
                ExpressionWrapper existingParam = i < exisitingArgumentList.size() ? (ExpressionWrapper)exisitingArgumentList.get(i) : null;
                newArgumentList.add(AstKeywordsInputUtil.generateExpressionForKeyword(methodName, classNode, existingParam, argumentListExpression));
            }
            ++i;
        }
        argumentListExpression.setExpressions(newArgumentList);
        return keywordCallExpression;
    }

    private static ExpressionWrapper generateExpressionForKeyword(String keywordName, KeywordParameter keywordParam, ExpressionWrapper existingParam, ASTNodeWrapper parentNode) {
        Class keywordParamType = keywordParam.getType();
        return AstKeywordsInputUtil.generateArgument(keywordName, keywordParam.getName(), keywordParamType.getSimpleName(), keywordParamType.getName(), keywordParamType.isArray(), keywordParamType.isEnum(), existingParam, parentNode);
    }

    private static ExpressionWrapper generateExpressionForKeyword(String methodName, Class<?> keywordParam, ExpressionWrapper existingParam, ArgumentListExpressionWrapper parentNode) {
        return AstKeywordsInputUtil.generateArgument(methodName, keywordParam.getName(), keywordParam.getSimpleName(), keywordParam.getName(), keywordParam.isArray(), keywordParam.isEnum(), existingParam, parentNode);
    }

    private static ExpressionWrapper generateExpressionForKeyword(String methodName, ClassNode classNode, ExpressionWrapper existingParam, ArgumentListExpressionWrapper parentNode) {
        String classNameWithoutPackage = classNode.getNameWithoutPackage();
        return AstKeywordsInputUtil.generateArgument(methodName, classNameWithoutPackage, classNameWithoutPackage, classNode.getName(), classNode.isArray(), classNode.isEnum(), existingParam, parentNode);
    }

    public static ExpressionWrapper generateArgument(String methodName, String paramName, String paramClassSimpleName, String paramClassFullName, boolean isArrayParam, boolean isEnumParam, ExpressionWrapper existingParam, ASTNodeWrapper parentNode) {
        if (AstKeywordsInputUtil.isDelaySecondParam(methodName, paramName)) {
            return AstKeywordsInputUtil.generateArgumentForDelaySecondParam(existingParam, parentNode);
        }
        if (existingParam != null && !AstKeywordsInputUtil.isFailureHandlingExpression(existingParam) && AstKeywordsInputUtil.isClassAssignable(existingParam.getType().getName(), paramClassSimpleName, paramClassFullName)) {
            return existingParam;
        }
        if (isEnumParam) {
            return AstKeywordsInputUtil.generateArgumentForEnumParam(existingParam, paramClassSimpleName, paramClassFullName, parentNode);
        }
        if (AstKeywordsInputUtil.isClassAssignable(paramClassFullName, TestObject.class)) {
            return AstKeywordsInputUtil.generateArgumentForTestObjectParam(existingParam, parentNode);
        }
        if (AstKeywordsInputUtil.isClassAssignable(paramClassFullName, WindowsTestObject.class)) {
            return AstKeywordsInputUtil.generateArgumentForWindowsObjectParam(existingParam, parentNode);
        }
        if (AstKeywordsInputUtil.isClassAssignable(paramClassFullName, List.class) || isArrayParam) {
            return AstKeywordsInputUtil.generateArgumentForListParam(existingParam, parentNode);
        }
        if (AstKeywordsInputUtil.isClassAssignable(paramClassFullName, Checkpoint.class)) {
            return AstKeywordsInputUtil.generateArgumentForCheckPointParam(existingParam, parentNode);
        }
        ExpressionWrapper newExpression = AstKeywordsInputUtil.generateArgumentForConstantParam(existingParam, parentNode, paramClassFullName);
        if (newExpression != null) {
            return newExpression;
        }
        if (existingParam instanceof ExpressionWrapper && !AstKeywordsInputUtil.isFailureHandlingExpression(existingParam)) {
            return existingParam;
        }
        return new ConstantExpressionWrapper(parentNode);
    }

    public static boolean isFailureHandlingExpression(ExpressionWrapper expression) {
        return expression instanceof PropertyExpressionWrapper && AstKeywordsInputUtil.isFailureHandlingPropertyExpression((PropertyExpressionWrapper)expression);
    }

    private static boolean isFailureHandlingPropertyExpression(PropertyExpressionWrapper propertyExpression) {
        if (!(propertyExpression.getObjectExpression() instanceof VariableExpressionWrapper)) {
            return false;
        }
        return propertyExpression.isObjectExpressionOfClass(FailureHandling.class) && propertyExpression.getProperty() instanceof ConstantExpressionWrapper;
    }

    private static ExpressionWrapper generateArgumentForDelaySecondParam(ExpressionWrapper existingParam, ASTNodeWrapper parentNode) {
        if (existingParam == null) {
            return new ConstantExpressionWrapper(0, parentNode);
        }
        if (existingParam instanceof ConstantExpressionWrapper) {
            try {
                Integer.parseInt(existingParam.getText());
                return existingParam;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (AstKeywordsInputUtil.isUnknowTypeParam(existingParam)) {
            return existingParam;
        }
        return new ConstantExpressionWrapper(0, parentNode);
    }

    private static boolean isDelaySecondParam(String methodName, String paramName) {
        return StringUtils.equals((String)methodName, (String)"delay") && StringUtils.equals((String)paramName, (String)"second");
    }

    private static ExpressionWrapper generateArgumentForConstantParam(ExpressionWrapper existingParam, ASTNodeWrapper parentNode, String paramClassName) {
        if (AstKeywordsInputUtil.isClassAssignable(paramClassName, Boolean.class)) {
            return AstKeywordsInputUtil.generateArgumentForBooleanConstantParam(existingParam, parentNode);
        }
        if (AstKeywordsInputUtil.isClassAssignable(paramClassName, String.class) || AstKeywordsInputUtil.isClassAssignable(paramClassName, Character.class)) {
            return AstKeywordsInputUtil.generateArgumentForStringConstantParam(existingParam, parentNode);
        }
        if (AstKeywordsInputUtil.isClassAssignable(paramClassName, Number.class)) {
            return AstKeywordsInputUtil.generateArgumentForNumberConstantExpression(existingParam, parentNode);
        }
        return null;
    }

    private static ExpressionWrapper generateArgumentForNumberConstantExpression(ExpressionWrapper existingParam, ASTNodeWrapper parentNode) {
        if (existingParam != null && (AstKeywordsInputUtil.isClassAssignable(existingParam.getType().getName(), Number.class) || AstKeywordsInputUtil.isUnknowTypeParam(existingParam))) {
            return existingParam;
        }
        return new ConstantExpressionWrapper(0, parentNode);
    }

    private static ExpressionWrapper generateArgumentForStringConstantParam(ExpressionWrapper existingParam, ASTNodeWrapper parentNode) {
        if (existingParam != null && (AstKeywordsInputUtil.isClassAssignable(existingParam.getType().getName(), String.class) || AstKeywordsInputUtil.isClassAssignable(existingParam.getType().getName(), Character.class)) || AstKeywordsInputUtil.isUnknowTypeParam(existingParam)) {
            return existingParam;
        }
        return new ConstantExpressionWrapper("", parentNode);
    }

    private static ExpressionWrapper generateArgumentForBooleanConstantParam(ExpressionWrapper existingParam, ASTNodeWrapper parentNode) {
        if (existingParam != null && AstKeywordsInputUtil.isClassAssignable(existingParam.getType().getName(), Boolean.class) || AstKeywordsInputUtil.isUnknowTypeParam(existingParam)) {
            return existingParam;
        }
        return new ConstantExpressionWrapper(Boolean.FALSE, parentNode);
    }

    private static ExpressionWrapper generateArgumentForListParam(ExpressionWrapper existingParam, ASTNodeWrapper parentNode) {
        if (existingParam instanceof ListExpressionWrapper || existingParam instanceof CastExpressionWrapper && ((CastExpressionWrapper)existingParam).getExpression() instanceof ListExpressionWrapper || AstKeywordsInputUtil.isUnknowTypeParam(existingParam)) {
            return existingParam;
        }
        return new ListExpressionWrapper(parentNode);
    }

    private static ExpressionWrapper generateArgumentForTestObjectParam(ExpressionWrapper existingParam, ASTNodeWrapper parentNode) {
        if (AstKeywordsInputUtil.isFindTestObjectMethodCall(existingParam) || AstKeywordsInputUtil.isUnknowTypeParam(existingParam)) {
            return existingParam;
        }
        return AstEntityInputUtil.createNewFindTestObjectMethodCall(null, parentNode);
    }

    private static ExpressionWrapper generateArgumentForWindowsObjectParam(ExpressionWrapper existingParam, ASTNodeWrapper parentNode) {
        if (AstKeywordsInputUtil.isFindWindowsObjectMethodCall(existingParam) || AstKeywordsInputUtil.isUnknowTypeParam(existingParam)) {
            return existingParam;
        }
        return AstEntityInputUtil.createNewFindWindowsObjectMethodCall(null, parentNode);
    }

    private static ExpressionWrapper generateArgumentForCheckPointParam(ExpressionWrapper existingParam, ASTNodeWrapper parentNode) {
        if (AstKeywordsInputUtil.isFindCheckpointMethodCall(existingParam) || AstKeywordsInputUtil.isUnknowTypeParam(existingParam)) {
            return existingParam;
        }
        return AstEntityInputUtil.createNewFindCheckpointMethodCall(null, parentNode);
    }

    private static boolean isFindTestObjectMethodCall(ExpressionWrapper existingParam) {
        return existingParam instanceof MethodCallExpressionWrapper && ((MethodCallExpressionWrapper)existingParam).isFindTestObjectMethodCall();
    }

    private static boolean isFindWindowsObjectMethodCall(ExpressionWrapper existingParam) {
        return existingParam instanceof MethodCallExpressionWrapper && ((MethodCallExpressionWrapper)existingParam).isFindWindowsObjectMethodCall();
    }

    private static boolean isFindCheckpointMethodCall(ExpressionWrapper existingParam) {
        return existingParam instanceof MethodCallExpressionWrapper && ((MethodCallExpressionWrapper)existingParam).isFindCheckpointMethodCall();
    }

    private static boolean isUnknowTypeParam(ExpressionWrapper existingParam) {
        return existingParam instanceof VariableExpressionWrapper || existingParam instanceof MapExpressionWrapper || existingParam instanceof CastExpressionWrapper || existingParam instanceof BinaryExpressionWrapper || AstKeywordsInputUtil.isGlobalVariableExpression(existingParam) || existingParam instanceof MethodCallExpressionWrapper && !AstKeywordsInputUtil.isFindTestObjectMethodCall(existingParam);
    }

    private static boolean isGlobalVariableExpression(ExpressionWrapper existingParam) {
        return existingParam instanceof PropertyExpressionWrapper && StringUtils.equals((String)((PropertyExpressionWrapper)existingParam).getObjectExpressionAsString(), (String)InputValueType.GlobalVariable.getName());
    }

    private static ExpressionWrapper generateArgumentForEnumParam(ExpressionWrapper existingParam, String paramClassSimpleName, String paramClassFullName, ASTNodeWrapper parentNode) {
        if (existingParam instanceof PropertyExpressionWrapper && AstKeywordsInputUtil.isClassAssignable(((PropertyExpressionWrapper)existingParam).getObjectExpressionAsString(), paramClassSimpleName, paramClassFullName)) {
            return existingParam;
        }
        if (paramClassFullName.equals(FailureHandling.class.getName())) {
            return AstKeywordsInputUtil.getNewFailureHandlingPropertyExpression(parentNode);
        }
        return new ConstantExpressionWrapper(parentNode);
    }

    private static boolean isClassAssignable(String fromClassName, String toClassSimpleName, String toClassFullName) {
        Class<?> targetClass = AstKeywordsInputUtil.loadType(fromClassName, null);
        Class<?> paramClass = AstKeywordsInputUtil.loadType(toClassFullName, null);
        if (targetClass != null && paramClass != null) {
            return AstKeywordsInputUtil.isClassAssignable(targetClass, paramClass);
        }
        return StringUtils.equals((String)toClassSimpleName, (String)fromClassName) && StringUtils.equals((String)toClassFullName, (String)fromClassName);
    }

    private static boolean isClassAssignable(String fromClassName, Class<?> toClass) {
        Class<?> targetClass = AstKeywordsInputUtil.loadType(fromClassName, null);
        if (targetClass != null && toClass != null) {
            return AstKeywordsInputUtil.isClassAssignable(targetClass, toClass);
        }
        return StringUtils.equals((String)toClass.getName(), (String)fromClassName);
    }

    private static boolean isClassAssignable(Class<?> fromClass, Class<?> toClass) {
        return ClassUtils.isAssignable(fromClass, toClass, (boolean)true);
    }

    public static boolean isVoidClass(Class<?> clazz) {
        return clazz.getName().equals(Void.class.getName()) || clazz.getName().equals(Void.class.getSimpleName()) || clazz.getName().equals(Void.TYPE.getName());
    }

    public static boolean isVoidClass(ClassNodeWrapper classNode) {
        return classNode.getName().equals(Void.class.getName()) || classNode.getName().equals(Void.class.getSimpleName()) || classNode.getName().equals(Void.TYPE.getName());
    }

    public static boolean isVoidClass(ClassNode classNode) {
        return classNode.getName().equals(Void.class.getName()) || classNode.getName().equals(Void.class.getSimpleName()) || classNode.getName().equals(Void.TYPE.getName());
    }

    /*
     * Unable to fully structure code
     */
    public static Class<?> loadType(String typeName, ClassNodeWrapper classNode) {
        type = null;
        try {
            type = Class.forName(typeName);
            return type;
        }
        catch (ClassNotFoundException v0) {
            classLoader = null;
            try {
                classLoader = ProjectController.getInstance().getProjectClassLoader(ProjectController.getInstance().getCurrentProject());
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
            if (classLoader == null) {
                return null;
            }
            try {
                type = classLoader.loadClass(typeName);
                return type;
            }
            catch (ClassNotFoundException v1) {
                type = AstKeywordsInputUtil.loadClassFromImportedPackage(typeName, classLoader);
                try {
                    type = ClassUtils.getClass((String)typeName);
                }
                catch (ClassNotFoundException v2) {}
                if (classNode == null) {
                    return type;
                }
                ** for (importNode : classNode.getScriptClass().getImports())
            }
        }
lbl-1000:
        // 1 sources

        {
            className = importNode.getClassName();
            if (className == null || !className.endsWith("." + typeName)) continue;
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException v3) {}
            continue;
        }
lbl32:
        // 1 sources

        return type;
    }

    public static Class<?> loadClassFromImportedPackage(String typeName, ClassLoader classLoader) {
        if (StringUtils.isEmpty((String)typeName) || classLoader == null) {
            return null;
        }
        String[] stringArray = GroovyParser.GROOVY_IMPORTED_PACKAGES;
        int n = GroovyParser.GROOVY_IMPORTED_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String importedPackage = stringArray[n2];
            try {
                return classLoader.loadClass(String.valueOf(importedPackage) + "." + typeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n2;
            }
        }
        return null;
    }

    public static Class<?> getFirstAccessibleMethodReturnType(Class<?> clazz, String methodName, boolean staticOnly) {
        if (clazz == null || methodName == null) {
            return null;
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methodName.equals(method.getName()) || staticOnly && !Modifier.isStatic(method.getModifiers())) {
                return method.getReturnType();
            }
            ++n2;
        }
        return null;
    }

    public static boolean isGlobalVariablePropertyExpression(PropertyExpressionWrapper propertyExprs) {
        if (!(propertyExprs.getObjectExpression() instanceof VariableExpressionWrapper)) {
            return false;
        }
        return propertyExprs.getObjectExpressionAsString().equals(InputValueType.GlobalVariable.name()) && propertyExprs.getProperty() instanceof ConstantExpressionWrapper;
    }
}

