/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.decompiler.editor;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.decompiler.constants.ComposerDecompilerMessageConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.helper.DecompilerPreferencesHelper;
import com.kms.katalon.tracking.service.Trackings;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.AbstractClassFile;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IEditorInput;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.ClassFileSourceMap;
import org.sf.feeling.decompiler.editor.DecompilerSourceMapper;
import org.sf.feeling.decompiler.editor.IDecompilerDescriptor;
import org.sf.feeling.decompiler.editor.JavaDecompilerBufferManager;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.editor.SourceMapperFactory;
import org.sf.feeling.decompiler.source.attach.handler.JavaSourceAttacherHandler;
import org.sf.feeling.decompiler.util.UIUtil;

public class KatalonDecompilerClassFileEditor
extends JavaDecompilerClassFileEditor
implements EventHandler {
    private IBuffer classBuffer;
    private ISourceReference selectedElement = null;
    private String decompilerType = null;
    private static Set<String> libraries = KatalonDecompilerClassFileEditor.getLibraries();
    private static Set<String> sourceBufferedClassFiles = Collections.synchronizedSet(new HashSet());

    private static Set<String> getLibraries() {
        try {
            Field librariesField = JavaDecompilerPlugin.class.getDeclaredField("librarys");
            librariesField.setAccessible(true);
            Set libraries = (Set)librariesField.get(JavaDecompilerPlugin.getDefault());
            return Collections.unmodifiableSet(libraries);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LoggerSingleton.logError((Throwable)e);
            return Collections.emptySet();
        }
    }

    public KatalonDecompilerClassFileEditor() {
        EventBrokerSingleton.getInstance().getEventBroker().subscribe("WORKSPACE/PLUGIN_LOADED", (EventHandler)this);
    }

    public void createPartControl(Composite parent) {
        UserProfile curProfile = UserProfileHelper.getCurrentProfile();
        if (curProfile.isHideClassFileEditorInstruction()) {
            super.createPartControl(parent);
        } else {
            Composite wrapper = new Composite(parent, 0);
            GridLayout gdWrapper = new GridLayout(1, false);
            gdWrapper.marginWidth = 0;
            gdWrapper.marginHeight = 0;
            wrapper.setLayout((Layout)gdWrapper);
            this.createGuidingComposite(wrapper);
            this.createPartControlComposite(wrapper);
            wrapper.pack();
        }
        Trackings.trackOpenDecompilerEditor();
    }

    private void createPartControlComposite(Composite parent) {
        Composite hiddenComposite = new Composite(parent, 0);
        hiddenComposite.setLayout((Layout)new FillLayout());
        hiddenComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        super.createPartControl(hiddenComposite);
    }

    private void createGuidingComposite(final Composite parent) {
        final Composite instructionComposite = new Composite(parent, 0);
        instructionComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gdInstruction = new GridLayout(1, false);
        gdInstruction.marginWidth = 0;
        gdInstruction.marginHeight = 0;
        instructionComposite.setLayout((Layout)gdInstruction);
        instructionComposite.setBackground(ColorUtil.getColor((String)"#fbe5a2"));
        Composite instructionInnerComposite = new Composite(instructionComposite, 0);
        instructionInnerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        instructionInnerComposite.setLayout((Layout)new GridLayout(3, false));
        final Link lblInstruction = new Link(instructionInnerComposite, 64);
        lblInstruction.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        lblInstruction.setText(MessageFormat.format(ComposerDecompilerMessageConstants.MSG_SWITCH_TO_DEFAULT_CLASS_EDITOR, DocumentationMessageConstants.CHANGE_CLASS_FILE_EDITOR));
        lblInstruction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Program.launch((String)event.text);
            }
        });
        Button btnUseDefaultClassEditor = new Button(instructionInnerComposite, 0);
        btnUseDefaultClassEditor.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        btnUseDefaultClassEditor.setText(GlobalStringConstants.USE_DEFAULT);
        btnUseDefaultClassEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecompilerPreferencesHelper.useDefaultJavaEditor();
                lblInstruction.setText(ComposerDecompilerMessageConstants.MSG_DONE_SWITCH_TO_DEFAULT);
                lblInstruction.setForeground(ColorUtil.getTextSuccessfulColor());
                Trackings.trackClickUseDefaultClassFileEditor();
            }
        });
        Button btnHide = new Button(instructionInnerComposite, 0);
        btnHide.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        btnHide.setText(GlobalStringConstants.HIDE);
        btnHide.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserProfile curProfile = UserProfileHelper.getCurrentProfile();
                curProfile.setHideClassFileEditorInstruction(true);
                UserProfileHelper.saveProfile((UserProfile)curProfile);
                ((GridData)instructionComposite.getLayoutData()).exclude = true;
                instructionComposite.setVisible(false);
                parent.layout();
            }
        });
    }

    public ISourceReference getSelectedElement() {
        return this.selectedElement;
    }

    private boolean doOpenBuffer(IEditorInput input, boolean force) throws JavaModelException {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        String decompilerType = prefs.getString("org.sf.feeling.decompiler.type");
        return this.doOpenBuffer(input, decompilerType, force);
    }

    private boolean doOpenBuffer(IEditorInput input, String type, boolean force) throws JavaModelException {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean reuseBuf = prefs.getBoolean("org.sf.feeling.decompiler.reusebuff");
        boolean always = prefs.getBoolean("org.sf.feeling.decompiler.alwaysuse");
        return this.doOpenBuffer(input, type, force, reuseBuf, always);
    }

    private boolean doOpenBuffer(IEditorInput input, String type, boolean force, boolean reuseBuf, boolean always) throws JavaModelException {
        if (UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
            reuseBuf = false;
        }
        if (input instanceof IClassFileEditorInput) {
            boolean notYetBufferedLibrarySource;
            boolean opened = false;
            IClassFile cf = ((IClassFileEditorInput)input).getClassFile();
            this.decompilerType = type;
            String origSrc = cf.getSource();
            boolean bl = notYetBufferedLibrarySource = this.hasLibrarySource(cf) && !this.bufferedLibrarySource(cf);
            if (origSrc == null || origSrc != null && always || origSrc != null && !always && !reuseBuf || KatalonDecompilerClassFileEditor.debugOptionChange((String)origSrc) || force || notYetBufferedLibrarySource) {
                char[] src;
                DecompilerSourceMapper sourceMapper = SourceMapperFactory.getSourceMapper((String)this.decompilerType);
                char[] cArray = src = sourceMapper == null ? null : sourceMapper.findSource(cf.getType());
                if (src == null) {
                    if ("FernFlower".equals(this.decompilerType)) {
                        src = SourceMapperFactory.getSourceMapper((String)"FernFlower").findSource(cf.getType());
                    } else {
                        IDecompilerDescriptor decompilerDescriptor = JavaDecompilerPlugin.getDefault().getDecompilerDescriptor(this.decompilerType);
                        if (decompilerDescriptor != null) {
                            src = decompilerDescriptor.getDecompilerSourceMapper().findSource(cf.getType());
                        }
                    }
                }
                if (src == null) {
                    return false;
                }
                char[] markedSrc = src;
                this.classBuffer = BufferManager.createBuffer((IOpenable)cf);
                this.classBuffer.setContents(markedSrc);
                this.getBufferManager().addBuffer(this.classBuffer);
                sourceMapper.mapSourceSwitch(cf.getType(), markedSrc, true);
                ClassFileSourceMap.updateSource((JavaDecompilerBufferManager)this.getBufferManager(), (ClassFile)((ClassFile)cf), (char[])markedSrc);
                String strSrc = new String(src);
                if (notYetBufferedLibrarySource && !strSrc.equals(origSrc)) {
                    this.markLibrarySourceBuffered(cf);
                }
                opened = true;
            }
            return opened;
        }
        return false;
    }

    private boolean bufferedLibrarySource(IClassFile cf) {
        return sourceBufferedClassFiles.contains(this.getClassFileIdentifier(cf));
    }

    private void markLibrarySourceBuffered(IClassFile cf) {
        sourceBufferedClassFiles.add(this.getClassFileIdentifier(cf));
    }

    private String getClassFileIdentifier(IClassFile cf) {
        return String.valueOf(cf.getPath().toOSString()) + "." + cf.getElementName();
    }

    private boolean hasLibrarySource(IClassFile cf) {
        AbstractClassFile acf;
        PackageFragmentRoot packageFragmentRoot;
        if (cf instanceof AbstractClassFile && (packageFragmentRoot = (acf = (AbstractClassFile)cf).getPackageFragmentRoot()) != null) {
            return libraries.contains(acf.getPackageFragmentRoot().getPath().toOSString());
        }
        return false;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        InternalClassFileEditorInput classInput;
        if (input instanceof InternalClassFileEditorInput && (classInput = (InternalClassFileEditorInput)input).getClassFile().getParent() instanceof PackageFragment) {
            this.doOpenBuffer(input, false);
        }
        this.doOpenBuffer(input, false);
        super.doSetInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public void handleEvent(Event event) {
        IEditorInput editorInput;
        if ("WORKSPACE/PLUGIN_LOADED".equals(event.getTopic()) && (editorInput = this.getEditorInput()) instanceof IClassFileEditorInput) {
            final IClassFile cf = ((IClassFileEditorInput)editorInput).getClassFile();
            sourceBufferedClassFiles.remove(this.getClassFileIdentifier(cf));
            if (cf instanceof AbstractClassFile) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        List<IPackageFragmentRoot> packageFragmentRoots = Arrays.asList(((AbstractClassFile)cf).getPackageFragmentRoot());
                        JavaSourceAttacherHandler.updateSourceAttachments(packageFragmentRoots, null);
                    }
                }).start();
            }
        }
    }
}

