/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.windows;

import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.windows.driver.WindowsDriverType;
import com.kms.katalon.execution.configuration.AbstractDriverConnector;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WindowsDriverConnector
extends AbstractDriverConnector {
    private String configurationFolderPath;

    public WindowsDriverConnector(String configurationFolderPath) throws IOException {
        super(configurationFolderPath);
        this.configurationFolderPath = configurationFolderPath;
    }

    public DriverType getDriverType() {
        return WindowsDriverType.getInstance();
    }

    public String getSettingFileName() {
        return "com.kms.katalon.core.windows";
    }

    public WindowsDriverConnector clone() {
        try {
            WindowsDriverConnector clone = new WindowsDriverConnector(this.configurationFolderPath);
            Map cloneProperties = clone.getUserConfigProperties();
            if (this.driverProperties.containsKey("winAppDriverUrl")) {
                cloneProperties.put("winAppDriverUrl", this.getWinAppDriverUrl());
            }
            if (this.driverProperties.containsKey("desiredCapabilities")) {
                cloneProperties.put("desiredCapabilities", this.getDesiredCapabilities());
            }
            return clone;
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    public Map<String, Object> getDesiredCapabilities() {
        Map userProperties = this.getUserConfigProperties();
        if (userProperties.containsKey("desiredCapabilities")) {
            return (Map)userProperties.get("desiredCapabilities");
        }
        return new LinkedHashMap<String, Object>();
    }

    public String getWinAppDriverUrl() {
        Map userProperties = this.getUserConfigProperties();
        return userProperties.getOrDefault("winAppDriverUrl", "http://127.0.0.1:4723");
    }

    public static WindowsDriverConnector getInstance(String projectDir) throws IOException {
        return new WindowsDriverConnector(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME);
    }

    public Map<String, Object> getAllConfigProperties() {
        LinkedHashMap<String, Object> allConfigProperties = new LinkedHashMap<String, Object>();
        allConfigProperties.putAll(this.getDesiredCapabilities());
        String winAppDriverUrl = this.getWinAppDriverUrl();
        if (StringUtils.isNotBlank((CharSequence)winAppDriverUrl)) {
            allConfigProperties.put("winAppDriverUrl", winAppDriverUrl);
        }
        return allConfigProperties;
    }

    public void setAllConfigProperties(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        LinkedHashMap<String, Object> windowsConfigProperties = new LinkedHashMap<String, Object>();
        if (properties.containsKey("winAppDriverUrl")) {
            windowsConfigProperties.put("winAppDriverUrl", properties.get("winAppDriverUrl"));
            properties.remove("winAppDriverUrl");
        }
        if (!properties.isEmpty()) {
            windowsConfigProperties.put("desiredCapabilities", properties);
        }
        this.driverProperties = windowsConfigProperties;
    }
}

