/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.dialog;

import com.kms.katalon.composer.integration.qtest.constant.ComposerIntegrationQtestMessageConstants;
import com.kms.katalon.composer.integration.qtest.constant.ImageConstants;
import com.kms.katalon.composer.integration.qtest.dialog.model.BatchCheckForTestCaseUpdatesResult;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BatchCheckForTestCaseUpdatesResultDialog
extends Dialog {
    private BatchCheckForTestCaseUpdatesResult result;

    public BatchCheckForTestCaseUpdatesResultDialog(Shell parent, BatchCheckForTestCaseUpdatesResult result) {
        super(parent);
        this.result = result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout(1, false));
        body.setLayoutData((Object)new GridData(768));
        if (this.result.getObsoleteTestCases().size() == 0 && this.result.getAllTestCasesWithErrors().size() == 0) {
            this.showUpToDateMessage(body);
        } else {
            if (this.result.getObsoleteTestCases().size() > 0) {
                this.showObsolationMessage(body);
            }
            if (this.result.getAllTestCasesWithErrors().size() > 0) {
                this.showErrorMessage(body);
            }
        }
        return body;
    }

    private void showUpToDateMessage(Composite parent) {
        Label lblMessage = new Label(parent, 0);
        lblMessage.setText(ComposerIntegrationQtestMessageConstants.CheckForUpdatesResultDialog_MSG_ALL_TEST_CASES_UP_TO_DATE);
    }

    private void showObsolationMessage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblFirst = new Label(composite, 0);
        String firstMessage = this.result.getObsoleteTestCases().size() == 1 ? ComposerIntegrationQtestMessageConstants.CheckForUpdatesResultDialog_MSG_ONE_OBSOLETE_TEST_CASE : MessageFormat.format(ComposerIntegrationQtestMessageConstants.CheckForUpdatesResultDialog_MSG_MULTIPLE_OBSOLETE_TEST_CASES, this.result.getObsoleteTestCases().size());
        lblFirst.setText(firstMessage);
        Label lblFlagIcon = new Label(composite, 0);
        Image flagIcon = ImageConstants.IMG_8_FLAG;
        lblFlagIcon.setImage(flagIcon);
        Label lblSecond = new Label(composite, 0);
        lblSecond.setText(ComposerIntegrationQtestMessageConstants.CheckForUpdatesResultDialog_MSG_ICON);
    }

    private void showErrorMessage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblFirst = new Label(composite, 0);
        String firstMessage = this.result.getAllTestCasesWithErrors().size() == 1 ? "There is 1 test case with check-for-update error. It is marked with " : MessageFormat.format("There are {0} test cases with check-for-update error. They are marked with ", this.result.getAllTestCasesWithErrors().size());
        lblFirst.setText(firstMessage);
        Label lblFlagIcon = new Label(composite, 0);
        Image flagIcon = ImageConstants.IMG_8_WARNING;
        lblFlagIcon.setImage(flagIcon);
        Label lblSecond = new Label(composite, 0);
        lblSecond.setText(ComposerIntegrationQtestMessageConstants.CheckForUpdatesResultDialog_MSG_ICON);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComposerIntegrationQtestMessageConstants.CheckForUpdatesResultDialog_DIA_TITLE_CHECK_FOR_UPDATES);
    }

    protected boolean isResizable() {
        return true;
    }
}

