/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.dialog;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.model.TestSuiteParentCreationOption;
import com.kms.katalon.composer.integration.qtest.dialog.provider.QTestSuiteParentTreeContentProvider;
import com.kms.katalon.composer.integration.qtest.dialog.provider.QTestSuiteParentTreeLabelProvider;
import com.kms.katalon.composer.integration.qtest.preference.QTestPreferenceDefaultValueInitializer;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.integration.qtest.QTestIntegrationTestSuiteManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestReleaseRoot;
import com.kms.katalon.integration.qtest.entity.QTestSuiteParent;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class CreateNewTestSuiteParentDialog
extends Dialog {
    private TreeViewer treeViewer;
    private Label lblStatus;
    private Composite container;
    private boolean exit;
    private QTestProject qTestProject;
    private List<String> parentIds;
    private QTestSuiteParent newTestSuiteParent;
    private Map<TestSuiteParentCreationOption, Button> creationOptionButtons;
    private Group groupOptions;

    public CreateNewTestSuiteParentDialog(Shell parentShell, List<String> parentIds, QTestProject qTestProject) {
        super(parentShell);
        this.parentIds = parentIds;
        this.qTestProject = qTestProject;
        this.creationOptionButtons = new HashMap<TestSuiteParentCreationOption, Button>();
        this.exit = false;
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        Label lblTitle = new Label(this.container, 0);
        lblTitle.setText(StringConstants.DIA_TITLE_CHOOSE_PARENT_FOR_TEST_SUITE);
        this.lblStatus = new Label(this.container, 0);
        this.lblStatus.setText(StringConstants.CM_MSG_PLEASE_WAIT);
        this.treeViewer = new TreeViewer(this.container, 67584);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn treeViewerColumnName = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnName = treeViewerColumnName.getColumn();
        trclmnName.setWidth(200);
        trclmnName.setText(StringConstants.NAME);
        TreeViewerColumn treeViewerColumnType = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnType = treeViewerColumnType.getColumn();
        trclmnType.setWidth(100);
        trclmnType.setText(StringConstants.CM_TYPE);
        TreeViewerColumn treeViewerColumnIsUsed = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnIsUsed = treeViewerColumnIsUsed.getColumn();
        trclmnIsUsed.setWidth(100);
        trclmnIsUsed.setText(StringConstants.DIA_TITLE_IN_USE);
        this.groupOptions = new Group(this.container, 0);
        this.groupOptions.setText(StringConstants.DIA_TITLE_CREATION_OPTIONS);
        this.groupOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.groupOptions.setLayout((Layout)new GridLayout(1, false));
        TestSuiteParentCreationOption[] testSuiteParentCreationOptionArray = TestSuiteParentCreationOption.values();
        int n = testSuiteParentCreationOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestSuiteParentCreationOption option = testSuiteParentCreationOptionArray[n2];
            Button btnOption = new Button((Composite)this.groupOptions, 16);
            btnOption.setText(option.toString());
            this.creationOptionButtons.put(option, btnOption);
            ++n2;
        }
        this.treeViewer.setContentProvider((IContentProvider)new QTestSuiteParentTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new QTestSuiteParentTreeLabelProvider(this.parentIds));
        return this.container;
    }

    public void create() {
        super.create();
        this.loadInput();
        this.addSelectionListener();
    }

    private void addSelectionListener() {
        this.treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CreateNewTestSuiteParentDialog.this.validate();
            }
        });
        this.getShell().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (CreateNewTestSuiteParentDialog.this.exit) {
                    CreateNewTestSuiteParentDialog.this.close();
                }
            }
        });
    }

    private void validate() {
        StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
        if (selection == null || selection.getFirstElement() == null) {
            this.getButton(0).setEnabled(false);
            return;
        }
        QTestSuiteParent selectedParent = (QTestSuiteParent)selection.getFirstElement();
        if (this.parentIds.contains(Long.toString(selectedParent.getId()))) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    private void loadInput() {
        Display display = this.treeViewer.getControl().getDisplay();
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(false);
        ControlUtils.recursiveSetEnabled((Control)this.groupOptions, (boolean)false);
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                    QTestReleaseRoot releaseRoot = QTestIntegrationTestSuiteManager.getTestSuiteIdRootOnQTest((IQTestCredential)QTestSettingCredential.getCredential((String)projectDir), (QTestProject)CreateNewTestSuiteParentDialog.this.qTestProject);
                    CreateNewTestSuiteParentDialog.this.lblStatus.dispose();
                    CreateNewTestSuiteParentDialog.this.container.layout();
                    CreateNewTestSuiteParentDialog.this.treeViewer.setInput((Object)new QTestSuiteParent[]{releaseRoot});
                    CreateNewTestSuiteParentDialog.this.treeViewer.expandAll();
                    CreateNewTestSuiteParentDialog.this.getButton(0).setEnabled(true);
                    CreateNewTestSuiteParentDialog.this.getButton(1).setEnabled(true);
                    CreateNewTestSuiteParentDialog.this.initCreationButtons();
                    CreateNewTestSuiteParentDialog.this.validate();
                }
                catch (Exception e) {
                    CreateNewTestSuiteParentDialog.this.getShell().setVisible(false);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.DIA_MSG_UNABLE_TO_UPLOAD_TEST_SUITE, (String)e.getClass().getSimpleName());
                    CreateNewTestSuiteParentDialog.this.exit = true;
                }
            }
        });
    }

    private void initCreationButtons() {
        ControlUtils.recursiveSetEnabled((Control)this.groupOptions, (boolean)true);
        TestSuiteParentCreationOption defaultOption = QTestPreferenceDefaultValueInitializer.getCreationOption();
        this.creationOptionButtons.get((Object)defaultOption).setSelection(true);
    }

    protected void okPressed() {
        StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
        if (selection == null || selection.getFirstElement() == null) {
            return;
        }
        this.newTestSuiteParent = (QTestSuiteParent)selection.getFirstElement();
        this.saveCreationOptions();
        super.okPressed();
    }

    private void saveCreationOptions() {
        for (Map.Entry<TestSuiteParentCreationOption, Button> entry : this.creationOptionButtons.entrySet()) {
            if (!entry.getValue().getSelection()) continue;
            QTestPreferenceDefaultValueInitializer.setCreationOption(entry.getKey());
            break;
        }
        this.creationOptionButtons.clear();
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.DIA_TITLE_CREATE_TEST_SUITE_PARENT);
    }

    public QTestSuiteParent getNewTestSuiteParent() {
        return this.newTestSuiteParent;
    }
}

