/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.dialog;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.model.DownloadedPreviewTreeNode;
import com.kms.katalon.composer.integration.qtest.dialog.model.ModuleDownloadedPreviewTreeNode;
import com.kms.katalon.composer.integration.qtest.dialog.model.TestCaseDownloadedPreviewTreeNode;
import com.kms.katalon.composer.integration.qtest.dialog.provider.QTestDownloadedTreeContentProvider;
import com.kms.katalon.composer.integration.qtest.dialog.provider.QTestDownloadedTreeLabelProvider;
import com.kms.katalon.composer.integration.qtest.dialog.provider.QTestDownloadedTreeStateListener;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationFolderManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestCaseManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.entity.QTestModule;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.model.FolderModulePair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class TestCaseTreeDownloadedPreviewDialog
extends Dialog {
    private Composite container;
    private QTestModule module;
    private FolderEntity folderEntity;
    private CheckboxTreeViewer checkboxTreeViewer;
    private Object[] selectedElement;
    private Label lblSelectedItems;
    private Label lblTotalItems;
    private int totalItemsCount;

    public TestCaseTreeDownloadedPreviewDialog(Shell parentShell, FolderEntity folder, QTestModule module) {
        super(parentShell);
        this.module = module;
        this.folderEntity = folder;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        Composite compositeHeader = new Composite(this.container, 0);
        compositeHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        compositeHeader.setLayout((Layout)new GridLayout(1, false));
        Label lblHeader = new Label(compositeHeader, 0);
        lblHeader.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblHeader.setText(StringConstants.DIA_INFO_TEST_CASE_DOWNLOADED_PREVIEW);
        Composite compositeSelected = new Composite(compositeHeader, 0);
        compositeSelected.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout gl_compositeSelected = new GridLayout(2, false);
        gl_compositeSelected.marginHeight = 0;
        gl_compositeSelected.marginWidth = 0;
        compositeSelected.setLayout((Layout)gl_compositeSelected);
        this.lblSelectedItems = new Label(compositeSelected, 0);
        this.lblTotalItems = new Label(compositeSelected, 0);
        this.lblTotalItems.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite compositeTable = new Composite(this.container, 0);
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.checkboxTreeViewer = new CheckboxTreeViewer(compositeTable, 67584);
        Tree tree = this.checkboxTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        tree.setHeaderVisible(true);
        TreeViewerColumn treeViewerColumnName = new TreeViewerColumn((TreeViewer)this.checkboxTreeViewer, 0);
        TreeColumn trclmnName = treeViewerColumnName.getColumn();
        trclmnName.setText(StringConstants.NAME);
        TreeViewerColumn treeViewerColumnType = new TreeViewerColumn((TreeViewer)this.checkboxTreeViewer, 0);
        TreeColumn trclmnType = treeViewerColumnType.getColumn();
        trclmnType.setText(StringConstants.CM_TYPE);
        TreeViewerColumn treeViewerColumnStatus = new TreeViewerColumn((TreeViewer)this.checkboxTreeViewer, 0);
        TreeColumn trclmnStatus = treeViewerColumnStatus.getColumn();
        trclmnStatus.setText(StringConstants.STATUS);
        TreeColumnLayout tableLayout = new TreeColumnLayout();
        tableLayout.setColumnData((Widget)trclmnName, (ColumnLayoutData)new ColumnWeightData(80, 0));
        tableLayout.setColumnData((Widget)trclmnType, (ColumnLayoutData)new ColumnWeightData(0, 100));
        tableLayout.setColumnData((Widget)trclmnStatus, (ColumnLayoutData)new ColumnWeightData(0, 150));
        compositeTable.setLayout((Layout)tableLayout);
        this.checkboxTreeViewer.setContentProvider((IContentProvider)new QTestDownloadedTreeContentProvider());
        this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new QTestDownloadedTreeLabelProvider());
        this.checkboxTreeViewer.addCheckStateListener((ICheckStateListener)new QTestDownloadedTreeStateListener(this));
        return this.container;
    }

    public void create() {
        super.create();
        this.setInput();
    }

    private void setInput() {
        try {
            ModuleDownloadedPreviewTreeNode rootTree = this.getModuleUpdatedPreviewTreeItem(this.module, this.folderEntity, null);
            this.isModuleAvailableForCreating(rootTree);
            ArrayList<DownloadedPreviewTreeNode> chilren = new ArrayList<DownloadedPreviewTreeNode>();
            chilren.addAll(rootTree.getChildModuleTrees());
            chilren.addAll(rootTree.getChildTestCaseTrees());
            this.checkboxTreeViewer.setInput(chilren);
            this.totalItemsCount = 0;
            for (Object e : chilren) {
                this.checkboxTreeViewer.setSubtreeChecked(e, true);
                this.totalItemsCount += this.getChildCount(e);
            }
            this.checkboxTreeViewer.expandAll();
            this.updateStatus();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void setShellStyle(int arg) {
        super.setShellStyle(112);
    }

    private ModuleDownloadedPreviewTreeNode getModuleUpdatedPreviewTreeItem(QTestModule module, FolderEntity folderEntity, ModuleDownloadedPreviewTreeNode parentModuleTree) throws Exception {
        ModuleDownloadedPreviewTreeNode moduleTree = new ModuleDownloadedPreviewTreeNode(module, folderEntity, parentModuleTree);
        if (folderEntity != null) {
            List childTestCaseEntities = FolderController.getInstance().getTestCaseChildren(folderEntity);
            module.getChildTestCases().removeAll(this.getChildQTestCases(childTestCaseEntities));
        }
        for (QTestTestCase qTestCaseNew : module.getChildTestCases()) {
            TestCaseDownloadedPreviewTreeNode testCaseTree = new TestCaseDownloadedPreviewTreeNode(moduleTree, qTestCaseNew);
            moduleTree.getChildTestCaseTrees().add(testCaseTree);
        }
        ArrayList<FolderEntity> childFolderEntities = new ArrayList<FolderEntity>();
        if (folderEntity != null) {
            childFolderEntities.addAll(FolderController.getInstance().getChildFolders(folderEntity));
        }
        Map<Long, FolderModulePair> qTestModuleMap = this.getChildQTestModules(childFolderEntities);
        for (QTestModule childModule : module.getChildModules()) {
            if (!qTestModuleMap.containsKey(childModule.getId())) {
                qTestModuleMap.put(childModule.getId(), new FolderModulePair(null, childModule));
                continue;
            }
            FolderModulePair pair = qTestModuleMap.get(childModule.getId());
            pair.setModule(childModule);
            qTestModuleMap.put(childModule.getId(), pair);
        }
        for (FolderModulePair pair : qTestModuleMap.values()) {
            ModuleDownloadedPreviewTreeNode childModuleTree = this.getModuleUpdatedPreviewTreeItem(pair.getModule(), pair.getFolder(), moduleTree);
            moduleTree.getChildModuleTrees().add(childModuleTree);
        }
        return moduleTree;
    }

    private boolean isModuleAvailableForCreating(ModuleDownloadedPreviewTreeNode moduleTree) {
        int index = 0;
        while (index < moduleTree.getChildModuleTrees().size()) {
            ModuleDownloadedPreviewTreeNode childModuleTree = moduleTree.getChildModuleTrees().get(index);
            boolean isChildQualified = this.isModuleAvailableForCreating(childModuleTree);
            if (!isChildQualified) {
                moduleTree.getChildModuleTrees().remove(index);
                continue;
            }
            ++index;
        }
        if (moduleTree.getChildModuleTrees().size() > 0) {
            return true;
        }
        if (moduleTree.getFolderEntity() == null) {
            return true;
        }
        return moduleTree.getChildTestCaseTrees().size() > 0;
    }

    private Map<Long, FolderModulePair> getChildQTestModules(List<FolderEntity> folderEntities) {
        LinkedHashMap<Long, FolderModulePair> qTestModuleMap = new LinkedHashMap<Long, FolderModulePair>();
        for (FolderEntity folderEntity : folderEntities) {
            QTestModule qTestModule;
            IntegratedEntity folderIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)folderEntity);
            if (folderIntegratedEntity == null || (qTestModule = QTestIntegrationFolderManager.getQTestModuleByIntegratedEntity((IntegratedEntity)folderIntegratedEntity)) == null) continue;
            FolderModulePair folderModulePair = new FolderModulePair(folderEntity, qTestModule);
            qTestModuleMap.put(qTestModule.getId(), folderModulePair);
        }
        return qTestModuleMap;
    }

    private List<QTestTestCase> getChildQTestCases(List<TestCaseEntity> testCaseEntities) {
        ArrayList<QTestTestCase> qTestCases = new ArrayList<QTestTestCase>();
        for (TestCaseEntity testCase : testCaseEntities) {
            IntegratedEntity testCaseIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCase);
            QTestTestCase qTestCase = QTestIntegrationTestCaseManager.getQTestTestCaseByIntegratedEntity((IntegratedEntity)testCaseIntegratedEntity);
            if (qTestCase == null) continue;
            qTestCases.add(qTestCase);
        }
        return qTestCases;
    }

    public void updateStatus() {
        int selectedItemsCount = this.checkboxTreeViewer.getCheckedElements().length;
        this.lblSelectedItems.setText(Integer.toString(selectedItemsCount));
        this.lblTotalItems.setText("items selected, " + Integer.toString(this.totalItemsCount) + " items total.");
        this.lblTotalItems.getParent().layout(true);
        if (selectedItemsCount == 0) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    private int getChildCount(Object item) {
        QTestDownloadedTreeContentProvider contentProvider = (QTestDownloadedTreeContentProvider)this.checkboxTreeViewer.getContentProvider();
        Object[] children = contentProvider.getChildren(item);
        int childrenSize = 0;
        if (children != null) {
            int index = 0;
            while (index < children.length) {
                childrenSize += this.getChildCount(children[index]);
                ++index;
            }
        }
        return childrenSize + 1;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.DIA_TITLE_TEST_CASE_DOWNLOADED_PREVIEW);
    }

    protected void okPressed() {
        this.selectedElement = this.checkboxTreeViewer.getCheckedElements();
        super.okPressed();
    }

    public Object[] selectedElements() {
        return this.selectedElement;
    }
}

