/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.handler;

import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.QTestSyncStatusUtil;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DeleteEntityEventHandler
implements EventHandler {
    @Inject
    IEventBroker eventBroker;

    @PostConstruct
    public void registerEventListener() {
        this.eventBroker.subscribe("EXPLORER/DELETED_SELECTED_ITEM", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        try {
            FolderEntity parentFolder;
            String deletedArtifactId;
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            Object eventData = EventUtil.getData((Event)event);
            if (eventData instanceof String && this.isUnderTestCaseRoot(deletedArtifactId = (String)eventData) && (parentFolder = this.getParentFolder(deletedArtifactId)) != null && QTestIntegrationUtil.isIntegrated((IntegratedFileEntity)parentFolder, (ProjectEntity)project)) {
                QTestSyncStatusUtil.recursivelyUnmarkAllStatusesIfNoChildWithSameStatus((FolderEntity)parentFolder, (ProjectEntity)project);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private boolean isUnderTestCaseRoot(String artifactId) throws ControllerException {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        FolderEntity testCaseRoot = FolderController.getInstance().getTestCaseRoot(project);
        return artifactId.startsWith(testCaseRoot.getName());
    }

    private FolderEntity getParentFolder(String artifactId) throws ControllerException {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        String parentFolderId = artifactId.substring(0, artifactId.lastIndexOf(47));
        FolderEntity parentFolder = FolderController.getInstance().getFolderByDisplayId(project, parentFolderId);
        return parentFolder;
    }
}

