/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.handler;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.qtest.constant.ComposerIntegrationQtestMessageConstants;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.model.CheckForTestCaseUpdatesResult;
import com.kms.katalon.composer.integration.qtest.handler.QTestCheckForUpdatesBaseHandler;
import com.kms.katalon.composer.integration.qtest.job.CheckForTestCaseUpdatesJob;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.QTestSyncStatusUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class QTestCheckForTestCaseUpdatesHandler
extends QTestCheckForUpdatesBaseHandler {
    private static final long DIALOG_CLOSED_DELAY_MILLIS = 500L;
    private static final String[] dialogButtonLabels = new String[]{StringConstants.DIA_BTN_SYNC_UP, IDialogConstants.CANCEL_LABEL};

    public static void execute(TestCaseEntity tc) {
        TestCaseEntity testCase;
        try {
            testCase = TestCaseController.getInstance().getTestCaseByDisplayId(tc.getIdForDisplay());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)QTestCheckForTestCaseUpdatesHandler.getActiveShell(), (String)StringConstants.DIA_TITLE_QTEST_INTEGRATION_UPDATE, (String)StringConstants.DIA_MSG_UNABLE_TO_UPDATE_TEST_CASE);
            LoggerSingleton.logError((Throwable)e);
            return;
        }
        try {
            QTestSyncStatusUtil.recursivelyUnmarkAllStatuses((IntegratedFileEntity)testCase, (ProjectEntity)testCase.getProject());
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
        if (!QTestCheckForTestCaseUpdatesHandler.validateTestCasesNotDirty(Arrays.asList(testCase))) {
            MessageDialog.openWarning((Shell)QTestCheckForTestCaseUpdatesHandler.getActiveShell(), (String)StringConstants.WARN, (String)ComposerIntegrationQtestMessageConstants.QTestCheckForTestCaseUpdatesHandler_MSG_WARN_SAVE_TEST_CASE);
            return;
        }
        final CheckForTestCaseUpdatesJob checkForTestCaseUpdatesJob = new CheckForTestCaseUpdatesJob(StringConstants.JOB_TITLE_CHECKING_FOR_UPDATES, testCase);
        checkForTestCaseUpdatesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!checkForTestCaseUpdatesJob.getResult().isOK()) {
                    return;
                }
                Executors.newSingleThreadExecutor().submit(() -> {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    UISynchronizeService.syncExec(() -> {
                        CheckForTestCaseUpdatesResult result = checkForTestCaseUpdatesJob.getCheckForUpdatesResult();
                        if (result.hasError(testCase)) {
                            try {
                                QTestSyncStatusUtil.recursivelyMarkError((IntegratedFileEntity)testCase, (ProjectEntity)testCase.getProject());
                                Throwable error = result.getError(testCase);
                                MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)"Error checking for updates", (String)error.getMessage());
                                LoggerSingleton.logError((Throwable)error);
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                        } else if (result.isUpToDate()) {
                            MessageDialog.openInformation((Shell)QTestCheckForTestCaseUpdatesHandler.getActiveShell(), (String)StringConstants.DIA_TITLE_QTEST_INTEGRATION_UPDATE, (String)StringConstants.DIA_MSG_TEST_CASE_UP_TO_DATE);
                        } else if (result.getLatestContent() != null) {
                            MessageDialog dialog = new MessageDialog(QTestCheckForTestCaseUpdatesHandler.getActiveShell(), StringConstants.DIA_TITLE_QTEST_INTEGRATION_UPDATE, null, String.valueOf(StringConstants.DIA_MSG_TEST_CASE_TEST_STEPS_CHANGED) + "\n\n" + MessageFormat.format(StringConstants.DIA_MSG_TEST_CASE_VERSIONS, result.getCurrentVersion(), result.getLatestVersion()), 0, 0, dialogButtonLabels);
                            try {
                                QTestSyncStatusUtil.recursivelyMarkObsolete((IntegratedFileEntity)testCase, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
                                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH", null);
                            }
                            catch (Exception exception) {}
                            if (dialog.open() == 0) {
                                try {
                                    QTestCheckForTestCaseUpdatesHandler.updateContent(testCase, result);
                                    QTestCheckForTestCaseUpdatesHandler.updateVersion(testCase, result);
                                    QTestCheckForTestCaseUpdatesHandler.updateTestCase(testCase);
                                    QTestSyncStatusUtil.recursivelyUnmarkObsolete((IntegratedFileEntity)testCase, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
                                    EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH", null);
                                }
                                catch (Exception e) {
                                    MessageDialog.openError((Shell)QTestCheckForTestCaseUpdatesHandler.getActiveShell(), (String)StringConstants.DIA_TITLE_QTEST_INTEGRATION_UPDATE, (String)StringConstants.DIA_MSG_UNABLE_TO_UPDATE_TEST_CASE);
                                    LoggerSingleton.logError((Throwable)e);
                                }
                            }
                        } else {
                            MessageDialog dialog = new MessageDialog(QTestCheckForTestCaseUpdatesHandler.getActiveShell(), StringConstants.DIA_TITLE_QTEST_INTEGRATION_UPDATE, null, String.valueOf(StringConstants.DIA_MSG_TEST_CASE_TEST_STEPS_UNCHANGED) + "\n\n" + MessageFormat.format(StringConstants.DIA_MSG_TEST_CASE_VERSIONS, result.getCurrentVersion(), result.getLatestVersion()), 0, 0, dialogButtonLabels);
                            if (dialog.open() == 0) {
                                try {
                                    QTestCheckForTestCaseUpdatesHandler.updateVersion(testCase, result);
                                    QTestCheckForTestCaseUpdatesHandler.updateTestCaseDescription(testCase, result);
                                    QTestCheckForTestCaseUpdatesHandler.updateTestCase(testCase);
                                }
                                catch (Exception e) {
                                    MessageDialog.openError((Shell)QTestCheckForTestCaseUpdatesHandler.getActiveShell(), (String)StringConstants.DIA_TITLE_QTEST_INTEGRATION_UPDATE, (String)StringConstants.DIA_MSG_UNABLE_TO_UPDATE_TEST_CASE);
                                    LoggerSingleton.logError((Throwable)e);
                                }
                            }
                        }
                    });
                });
            }
        });
        checkForTestCaseUpdatesJob.setUser(true);
        checkForTestCaseUpdatesJob.schedule();
    }

    private static void updateVersion(TestCaseEntity testCase, CheckForTestCaseUpdatesResult result) {
        IntegratedEntity integratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCase);
        integratedEntity.getProperties().put("version", result.getLatestVersion());
    }

    private static void updateTestCaseDescription(TestCaseEntity testCase, CheckForTestCaseUpdatesResult result) {
        testCase.setDescription(result.getLatestDescription());
    }

    private static void updateContent(TestCaseEntity testCase, CheckForTestCaseUpdatesResult result) {
        testCase.setComment(result.getLatestContent());
    }

    private static void updateTestCase(TestCaseEntity testCase) throws Exception {
        TestCaseController.getInstance().updateTestCase(testCase);
        EventBrokerSingleton.getInstance().getEventBroker().send("TESTCASE/UPDATED", (Object)new Object[]{testCase.getId(), testCase});
        MessageDialog.openInformation((Shell)QTestCheckForTestCaseUpdatesHandler.getActiveShell(), (String)StringConstants.DIA_TITLE_QTEST_INTEGRATION_UPDATE, (String)StringConstants.DIA_MSG_TEST_CASE_NOW_UP_TO_DATE);
    }

    private static Shell getActiveShell() {
        return Display.getCurrent().getActiveShell();
    }

    static /* synthetic */ Shell access$0() {
        return QTestCheckForTestCaseUpdatesHandler.getActiveShell();
    }

    static /* synthetic */ String[] access$1() {
        return dialogButtonLabels;
    }

    static /* synthetic */ void access$2(TestCaseEntity testCaseEntity, CheckForTestCaseUpdatesResult checkForTestCaseUpdatesResult) {
        QTestCheckForTestCaseUpdatesHandler.updateContent(testCaseEntity, checkForTestCaseUpdatesResult);
    }

    static /* synthetic */ void access$3(TestCaseEntity testCaseEntity, CheckForTestCaseUpdatesResult checkForTestCaseUpdatesResult) {
        QTestCheckForTestCaseUpdatesHandler.updateVersion(testCaseEntity, checkForTestCaseUpdatesResult);
    }

    static /* synthetic */ void access$4(TestCaseEntity testCaseEntity) throws Exception {
        QTestCheckForTestCaseUpdatesHandler.updateTestCase(testCaseEntity);
    }

    static /* synthetic */ void access$5(TestCaseEntity testCaseEntity, CheckForTestCaseUpdatesResult checkForTestCaseUpdatesResult) {
        QTestCheckForTestCaseUpdatesHandler.updateTestCaseDescription(testCaseEntity, checkForTestCaseUpdatesResult);
    }
}

