/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.handler.AbstractQTestHandler;
import com.kms.katalon.composer.integration.qtest.job.UploadTestCaseJob;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public class QTestUploadTestCaseHandler
extends AbstractQTestHandler {
    @Inject
    private UISynchronize sync;
    @Inject
    private ESelectionService selectionService;

    @CanExecute
    public boolean canExecute() {
        Object selectedEntity;
        ProjectEntity projectEntity;
        block5: {
            projectEntity = ProjectController.getInstance().getCurrentProject();
            selectedEntity = this.getFirstSelectedObject(this.selectionService);
            if (selectedEntity != null) break block5;
            return false;
        }
        try {
            FolderEntity folder;
            if (selectedEntity instanceof TestCaseEntity) {
                return QTestIntegrationUtil.canBeUploaded((IntegratedFileEntity)((IntegratedFileEntity)selectedEntity), (ProjectEntity)projectEntity);
            }
            if (selectedEntity instanceof FolderEntity && (folder = (FolderEntity)selectedEntity).getFolderType() == FolderEntity.FolderType.TESTCASE) {
                return QTestIntegrationUtil.canBeUploaded((IntegratedFileEntity)folder, (ProjectEntity)projectEntity);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return false;
    }

    private List<IntegratedFileEntity> getNotIntegratedChildren(IntegratedFileEntity entity) {
        boolean isNotIntegrated = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)entity) == null;
        ArrayList<IntegratedFileEntity> unIntegratedEntities = new ArrayList<IntegratedFileEntity>();
        if (isNotIntegrated) {
            unIntegratedEntities.add(entity);
        }
        if (entity instanceof FolderEntity) {
            FolderEntity folderEntity = (FolderEntity)entity;
            try {
                for (FileEntity childEntity : FolderController.getInstance().getChildren(folderEntity)) {
                    unIntegratedEntities.addAll(this.getNotIntegratedChildren((IntegratedFileEntity)childEntity));
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return Collections.emptyList();
            }
        }
        return unIntegratedEntities;
    }

    private void uploadTestCases(List<IntegratedFileEntity> unIntegratedTestCases) {
        UploadTestCaseJob job = new UploadTestCaseJob("Upload test cases", this.sync);
        job.setFileEntities(unIntegratedTestCases);
        job.doTask();
    }

    public static void addParentToUploadedEntities(IntegratedFileEntity childEntity, List<IntegratedFileEntity> uploadedEntites) {
        IntegratedEntity parentIntegratedEntitity;
        FolderEntity parentFolder = childEntity.getParentFolder();
        if (parentFolder != null && (parentIntegratedEntitity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)parentFolder)) == null) {
            uploadedEntites.add(0, (IntegratedFileEntity)parentFolder);
            QTestUploadTestCaseHandler.addParentToUploadedEntities((IntegratedFileEntity)parentFolder, uploadedEntites);
        }
    }

    @Execute
    public void execute() {
        try {
            Object selectedObject = this.getFirstSelectedObject(this.selectionService);
            if (selectedObject instanceof TestCaseEntity) {
                TestCaseEntity testCaseEntity = (TestCaseEntity)selectedObject;
                ArrayList<IntegratedFileEntity> uploadedEntities = new ArrayList<IntegratedFileEntity>();
                QTestUploadTestCaseHandler.addParentToUploadedEntities((IntegratedFileEntity)testCaseEntity, uploadedEntities);
                uploadedEntities.add((IntegratedFileEntity)testCaseEntity);
                this.uploadTestCases(uploadedEntities);
            } else if (selectedObject instanceof FolderEntity) {
                FolderEntity folder = (FolderEntity)selectedObject;
                if (folder.getFolderType() != FolderEntity.FolderType.TESTCASE) {
                    return;
                }
                List<IntegratedFileEntity> uploadedEntities = this.getNotIntegratedChildren((IntegratedFileEntity)folder);
                this.uploadTestCases(uploadedEntities);
                if (QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)folder) == null) {
                    QTestUploadTestCaseHandler.addParentToUploadedEntities((IntegratedFileEntity)folder, uploadedEntities);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

