/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.job;

import com.kms.katalon.application.utils.EntityTrackingHelper;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.TestCaseRootSelectionDialog;
import com.kms.katalon.composer.integration.qtest.dialog.TestCaseTreeDownloadedPreviewDialog;
import com.kms.katalon.composer.integration.qtest.dialog.model.DownloadedPreviewTreeNode;
import com.kms.katalon.composer.integration.qtest.dialog.model.ModuleDownloadedPreviewTreeNode;
import com.kms.katalon.composer.integration.qtest.dialog.model.TestCaseDownloadedPreviewTreeNode;
import com.kms.katalon.composer.integration.qtest.job.QTestJob;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.ast.GroovyParser;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.integration.qtest.QTestIntegrationFolderManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestCaseManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestModule;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestStep;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class DownloadTestCaseJob
extends QTestJob {
    private UISynchronize sync;
    private Object[] selectedElements;
    private QTestModule qTestSelectedModule;
    private boolean isMonitorCanceled;
    private boolean isMergeFolderConfirmed;
    private boolean isMergeTestCaseConfimed;
    private IQTestCredential credential;
    private static final int MAX_SUFFIX_LENGTH = 7;
    private static final int GROOVY_SCRIPT_FILE_NAME_LENGTH = 19;
    private static final int FILE_SEPAPRATOR_LENGTH = 1;

    public DownloadTestCaseJob(UISynchronize sync) {
        super(StringConstants.JOB_TASK_DOWNLOAD_TEST_CASE);
        this.setUser(true);
        this.sync = sync;
        this.qTestSelectedModule = null;
        this.isMonitorCanceled = false;
        this.credential = QTestSettingCredential.getCredential((String)this.getProjectDir());
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(StringConstants.JOB_SUB_TASK_DOWNLOAD_TEST_CASE, 2);
        monitor.subTask(StringConstants.JOB_SUB_TASK_CHECK_SYSTEM);
        FileEntity fileEntity = (FileEntity)this.getFileEntities().get(0);
        FolderEntity folderEntity = (FolderEntity)fileEntity;
        monitor.worked(1);
        try {
            monitor.subTask(MessageFormat.format(StringConstants.JOB_SUB_TASK_FETCH_CHILDREN, folderEntity.getName()));
            IntegratedEntity folderIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)folderEntity);
            String projectDir = this.projectEntity.getFolderLocation();
            QTestProject qTestProject = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)folderEntity, (ProjectEntity)this.projectEntity).getQTestProject();
            if (folderIntegratedEntity != null) {
                this.qTestSelectedModule = QTestIntegrationFolderManager.getQTestModuleByFolderEntity((FolderEntity)folderEntity);
                QTestIntegrationFolderManager.updateModule((IQTestCredential)this.credential, (long)qTestProject.getId(), (QTestModule)this.qTestSelectedModule, (boolean)true);
            } else {
                QTestModule moduleRoot = QTestIntegrationFolderManager.getModuleRoot((IQTestCredential)QTestSettingCredential.getCredential((String)projectDir), (QTestProject)qTestProject);
                QTestIntegrationFolderManager.updateModule((IQTestCredential)this.credential, (long)qTestProject.getId(), (QTestModule)moduleRoot, (boolean)true);
                this.performTestCaseRootSelection(moduleRoot);
            }
            monitor.worked(1);
            if (this.qTestSelectedModule == null || monitor.isCanceled() || this.isMonitorCanceled) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.performTestCaseCreatedSelection(folderEntity);
            if (monitor.isCanceled() || this.isMonitorCanceled) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (this.selectedElements != null && this.selectedElements.length > 0) {
                if (folderIntegratedEntity == null) {
                    folderIntegratedEntity = QTestIntegrationFolderManager.getFolderIntegratedEntityByQTestModule((QTestModule)this.qTestSelectedModule);
                    folderEntity.getIntegratedEntities().add(folderIntegratedEntity);
                    FolderController.getInstance().saveFolder(folderEntity);
                }
                monitor.done();
                monitor.beginTask(StringConstants.JOB_TASK_CREATE_TEST_CASE, this.selectedElements.length);
                int index = 0;
                while (index < this.selectedElements.length) {
                    block18: {
                        if (!monitor.isCanceled()) break block18;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        this.doUpdateSelectedItem(qTestProject, this.selectedElements[index], monitor);
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                    ++index;
                }
                GroovyUtil.refreshInfiniteScriptTestCaseClasspath((ProjectEntity)this.projectEntity, (FolderEntity)folderEntity, null);
            }
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH", null);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception exception) {
            monitor.setCanceled(true);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private void performTestCaseCreatedSelection(final FolderEntity folderEntity) {
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                TestCaseTreeDownloadedPreviewDialog dialog = new TestCaseTreeDownloadedPreviewDialog(Display.getDefault().getActiveShell(), folderEntity, DownloadTestCaseJob.this.qTestSelectedModule);
                if (dialog.open() == 0) {
                    DownloadTestCaseJob.this.selectedElements = dialog.selectedElements();
                } else {
                    DownloadTestCaseJob.this.isMonitorCanceled = true;
                }
            }
        });
    }

    private void performTestCaseRootSelection(final QTestModule moduleRoot) {
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                TestCaseRootSelectionDialog testCaseRootSelectionDialog = new TestCaseRootSelectionDialog(Display.getDefault().getActiveShell(), moduleRoot, false);
                if (testCaseRootSelectionDialog.open() == 0) {
                    DownloadTestCaseJob.this.qTestSelectedModule = testCaseRootSelectionDialog.getSelectedModule();
                } else {
                    DownloadTestCaseJob.this.isMonitorCanceled = true;
                }
            }
        });
    }

    private void openMergeFoldersDialog(final QTestModule qTestModule) {
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                DownloadTestCaseJob.this.isMergeFolderConfirmed = MessageDialog.openConfirm(null, (String)StringConstants.DIA_TITLE_FOLDER_DUPLICATION, (String)MessageFormat.format(StringConstants.DIA_MSG_CONFIRM_MERGE_DOWNLOADED_TEST_CASE_FOLDER, qTestModule.getName()));
            }
        });
    }

    private void openMergeTestCasesDialog(final QTestTestCase qTestCase) {
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                DownloadTestCaseJob.this.isMergeTestCaseConfimed = MessageDialog.openConfirm(null, (String)StringConstants.DIA_TITLE_TEST_CASE_DUPLICATION, (String)MessageFormat.format(StringConstants.DIA_MSG_CONFIRM_MERGE_DOWNLOADED_TEST_CASE, qTestCase.getName()));
            }
        });
    }

    private void addIntegratedEntityToFolder(FolderEntity folderEntity, ModuleDownloadedPreviewTreeNode moduleTree) throws Exception {
        IntegratedEntity newIntegratedEntity = QTestIntegrationFolderManager.getFolderIntegratedEntityByQTestModule((QTestModule)moduleTree.getModule());
        folderEntity.getIntegratedEntities().add(newIntegratedEntity);
        moduleTree.setFolderEntity(folderEntity);
        FolderController.getInstance().saveFolder(folderEntity);
    }

    private void addIntegratedEntityToTestCase(TestCaseEntity testCaseEntity, TestCaseDownloadedPreviewTreeNode testCaseTree, QTestProject qTestProject) throws Exception {
        QTestTestCase qTestCase = testCaseTree.getTestCase();
        if (qTestCase.getVersionId() == 0L) {
            qTestCase.setVersionId(QTestIntegrationTestCaseManager.getTestCaseVersionId((IQTestCredential)this.credential, (long)qTestProject.getId(), (long)qTestCase.getId()));
        }
        IntegratedEntity newIntegratedEntity = QTestIntegrationTestCaseManager.getIntegratedEntityByQTestTestCase((QTestTestCase)testCaseTree.getTestCase());
        testCaseEntity.getIntegratedEntities().add(newIntegratedEntity);
        TestCaseController.getInstance().updateTestCase(testCaseEntity);
    }

    private void doUpdateSelectedItem(QTestProject qTestProject, Object selectedItem, IProgressMonitor monitor) throws Exception {
        this.isMergeFolderConfirmed = false;
        this.isMergeTestCaseConfimed = false;
        if (!(selectedItem instanceof DownloadedPreviewTreeNode)) {
            return;
        }
        DownloadedPreviewTreeNode treeItem = (DownloadedPreviewTreeNode)selectedItem;
        FolderEntity parentFolder = treeItem.getParent().getFolderEntity();
        String dialogDisplayedName = this.getWrappedName(treeItem.getName());
        if (selectedItem instanceof ModuleDownloadedPreviewTreeNode) {
            ModuleDownloadedPreviewTreeNode moduleTree = (ModuleDownloadedPreviewTreeNode)selectedItem;
            if (moduleTree.getFolderEntity() == null) {
                IntegratedEntity existingIntegratedFolderEntity;
                monitor.subTask(MessageFormat.format(StringConstants.JOB_SUB_TASK_CREATE_TEST_CASE_FOLDER, dialogDisplayedName));
                FolderEntity existingFolder = FolderController.getInstance().getFolder(String.valueOf(parentFolder.getId()) + File.separator + treeItem.getName());
                if (existingFolder != null && (existingIntegratedFolderEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)existingFolder)) == null) {
                    this.openMergeFoldersDialog(moduleTree.getModule());
                }
                if (this.isMergeFolderConfirmed) {
                    this.addIntegratedEntityToFolder(existingFolder, moduleTree);
                } else {
                    FolderEntity newFolderEntity = FolderController.getInstance().addNewFolder(parentFolder, moduleTree.getModule().getName());
                    this.addIntegratedEntityToFolder(newFolderEntity, moduleTree);
                }
            }
        } else if (selectedItem instanceof TestCaseDownloadedPreviewTreeNode) {
            IntegratedEntity existingIntegratedTestCaseEntity;
            TestCaseDownloadedPreviewTreeNode testCaseTree = (TestCaseDownloadedPreviewTreeNode)selectedItem;
            QTestTestCase qTestCase = testCaseTree.getTestCase();
            monitor.subTask(MessageFormat.format(StringConstants.JOB_SUB_TASK_CREATE_TEST_CASE, dialogDisplayedName));
            TestCaseEntity existingTestCase = TestCaseController.getInstance().getTestCase(String.valueOf(parentFolder.getId()) + File.separator + treeItem.getName() + TestCaseEntity.getTestCaseFileExtension());
            if (existingTestCase != null && (existingIntegratedTestCaseEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)existingTestCase)) == null) {
                this.openMergeTestCasesDialog(qTestCase);
            }
            if (this.isMergeTestCaseConfimed) {
                this.addIntegratedEntityToTestCase(existingTestCase, testCaseTree, qTestProject);
                EventBrokerSingleton.getInstance().getEventBroker().post("TESTCASE/UPDATED", (Object)new Object[]{existingTestCase.getId(), existingTestCase});
            } else {
                TestCaseEntity newTestCaseEntity = TestCaseController.getInstance().newTestCase(parentFolder, this.toValidTestCaseName(parentFolder, String.valueOf(qTestCase.getPid()) + " " + qTestCase.getName()));
                EntityTrackingHelper.trackTestCaseCreated();
                this.addDescriptionForTestCase(qTestProject, qTestCase, newTestCaseEntity);
                this.addIntegratedEntityToTestCase(newTestCaseEntity, testCaseTree, qTestProject);
            }
        }
        monitor.worked(1);
    }

    private void addDescriptionForTestCase(QTestProject qTestProject, QTestTestCase qTestCase, TestCaseEntity testCaseEntity) throws Exception {
        GroovyCompilationUnit unit = (GroovyCompilationUnit)GroovyUtil.getOrCreateGroovyScriptForTestCaseFromPlugin((TestCaseEntity)testCaseEntity);
        ClassNode clazzNode = (ClassNode)unit.getModuleNode().getClasses().get(0);
        Statement statement = ((MethodNode)clazzNode.getMethods("run").get(0)).getCode();
        List qTestSteps = QTestIntegrationTestCaseManager.getListSteps((IQTestCredential)this.credential, (long)qTestProject.getId(), (QTestTestCase)qTestCase);
        ArrayList<String> descriptions = new ArrayList<String>();
        if (statement instanceof BlockStatement) {
            BlockStatement blockStatement = (BlockStatement)statement;
            blockStatement.getStatements().clear();
            for (QTestStep qTestStep : qTestSteps) {
                BlockStatement stepBlock = new BlockStatement();
                String description = QTestIntegrationUtil.getTestStepDescription((QTestStep)qTestStep);
                descriptions.add(description);
                ExpressionStatement descriptionStatement = new ExpressionStatement((Expression)new ConstantExpression((Object)description));
                stepBlock.addStatement((Statement)descriptionStatement);
                blockStatement.addStatement((Statement)stepBlock);
            }
        }
        testCaseEntity.setDescription(QTestIntegrationUtil.getHtmlInnerText((String)qTestCase.getDescription()));
        testCaseEntity.setComment(StringUtils.join(descriptions, (char)'\n'));
        TestCaseController.getInstance().updateTestCase(testCaseEntity);
        GroovyParser parser = new GroovyParser(new StringBuilder());
        ArrayList<Object> astNodes = new ArrayList<Object>();
        astNodes.add(clazzNode);
        astNodes.add(statement);
        parser.parseGroovyAstIntoScript(astNodes);
        FileUtils.writeStringToFile((File)new File(TestCaseController.getInstance().getGroovyScriptFilePath(testCaseEntity)), (String)parser.getValue());
    }

    private String toValidTestCaseName(FolderEntity parentFolder, String name) {
        int taken = parentFolder.getLocation().length() + 1 + 7 + 1 + 19;
        int available = 255 - taken;
        return name.length() > available ? name.substring(0, available) : name;
    }
}

