/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.preference;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.preference.AbstractQTestIntegrationPage;
import com.kms.katalon.composer.integration.qtest.preference.provider.ExecutionStatusMappingTableLabelProvider;
import com.kms.katalon.composer.integration.qtest.preference.provider.QTestStatusEditingSupport;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.integration.qtest.model.ExecutionStatusMapping;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ExecutionStatusMappingPreferencePage
extends AbstractQTestIntegrationPage {
    private Composite container;
    private TableViewer tableViewer;
    private String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
    private List<ExecutionStatusMapping> mappings;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        Composite compositeText = new Composite(this.container, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        compositeText.setLayout((Layout)gl);
        Label text = new Label(compositeText, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        text.setLayoutData((Object)gridData);
        text.setText(StringConstants.QTestExecutionStatusMappingPreferencePage_INFO);
        Label asterisk = new Label(compositeText, 0);
        asterisk.setText(StringConstants.QTestExecutionStatusMappingPreferencePage_ASTERISK);
        new HelpComposite(compositeText, "https://docs.katalon.com/katalon-studio/docs/qtest-integration.html#execution-status-mapping");
        Composite compositeTable = new Composite(this.container, 0);
        this.tableViewer = new TableViewer(compositeTable, 67584);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setHeaderVisible(true);
        TableViewerColumn tableViewerColumnKatalonStatus = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnKatalonStatus = tableViewerColumnKatalonStatus.getColumn();
        tblclmnKatalonStatus.setText(StringConstants.QTestExecutionStatusMappingPreferencePage_KS_STATUS);
        TableViewerColumn tableViewerColumnQTestStatus = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnQTestStatus = tableViewerColumnQTestStatus.getColumn();
        tblclmnQTestStatus.setText(StringConstants.QTestExecutionStatusMappingPreferencePage_QT_STATUS);
        tableViewerColumnQTestStatus.setEditingSupport((EditingSupport)new QTestStatusEditingSupport(this.tableViewer));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExecutionStatusMappingTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tblclmnKatalonStatus, (ColumnLayoutData)new ColumnWeightData(0, 173));
        tableLayout.setColumnData((Widget)tblclmnQTestStatus, (ColumnLayoutData)new ColumnWeightData(90, 173));
        compositeTable.setLayout((Layout)tableLayout);
        this.initialize();
        this.setStatusColor(table);
        return this.container;
    }

    private void setStatusColor(Table table) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(ColorUtil.getPassedLogBackgroundColor());
        colors.add(ColorUtil.getFailedLogBackgroundColor());
        colors.add(ColorUtil.getIncompleteLogColor());
        colors.add(ColorUtil.getErrorLogBackgroundColor());
        colors.add(ColorUtil.getSkippedLogColor());
        int i = 0;
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setForeground(0, (Color)colors.get(i++));
            ++n2;
        }
    }

    @Override
    protected void initialize() {
        if (this.container == null || this.container.isDisposed()) {
            return;
        }
        this.mappings = new ArrayList<ExecutionStatusMapping>(QTestSettingStore.getExecutionStatusMappings((String)this.projectDir));
        this.tableViewer.setInput(this.mappings);
        this.tableViewer.editElement(this.tableViewer.getElementAt(0), 1);
    }

    @Focus
    public void focus() {
        this.initialize();
    }

    protected void performDefaults() {
        QTestSettingStore.saveExecutionStatusMappings((List)QTestSettingStore.getDefaultStatusMappings(), (String)this.projectDir);
        this.initialize();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.container == null) {
            return true;
        }
        if (this.tableViewer.isCellEditorActive()) {
            this.tableViewer.applyEditorValue();
        }
        QTestSettingStore.saveExecutionStatusMappings(this.mappings, (String)this.projectDir);
        return true;
    }
}

