/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.view.testsuite.provider;

import com.kms.katalon.composer.integration.qtest.constant.ImageConstants;
import com.kms.katalon.integration.qtest.entity.QTestCycle;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.entity.QTestSuiteParent;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class QTestSuiteTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int CLMN_PARENT_NAME_IDX = 0;
    private static final int CLMN_PARENT_TYPE_IDX = 1;
    private static final int CLMN_PARENT_IS_DEFAULT_IDX = 2;

    public Image getColumnImage(Object element, int columnIndex) {
        if (element != null && element instanceof QTestSuite) {
            QTestSuite qTestSuite = (QTestSuite)element;
            switch (columnIndex) {
                case 0: {
                    if (qTestSuite.getId() > 0L) {
                        return ImageConstants.IMG_16_UPLOADED;
                    }
                    return ImageConstants.IMG_16_UPLOADING;
                }
                case 2: {
                    if (qTestSuite.isSelected()) {
                        return ImageConstants.IMG_16_CHECKED;
                    }
                    return ImageConstants.IMG_16_UNCHECKED;
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element == null || !(element instanceof QTestSuite) || columnIndex < 0 || columnIndex > 1) {
            return "";
        }
        QTestSuite qTestSuite = (QTestSuite)element;
        switch (columnIndex) {
            case 0: {
                QTestSuiteParent parent = qTestSuite.getParent();
                if (parent instanceof QTestCycle && parent.getParent() != null) {
                    String parentName = parent.getParent().getName();
                    if (parent != null && !parentName.isEmpty()) {
                        return String.valueOf(parent.getParent().getName()) + " / " + parent.getName();
                    }
                    return parent.getName();
                }
                return parent.getName();
            }
            case 1: {
                return qTestSuite.getParent().getTypeName();
            }
        }
        return "";
    }
}

