/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.wizard.page;

import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.wizard.AbstractWizardPage;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.provider.TestCaseFolderEntityProvider;
import com.kms.katalon.composer.integration.qtest.wizard.page.QTestWizardPage;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TestSuiteFolderSelectionWizardPage
extends AbstractWizardPage
implements QTestWizardPage {
    private TreeViewer treeViewer;
    private Composite folderBrowserComposite;

    @Override
    public String getStepIndexAsString() {
        return "3.3";
    }

    public boolean canFlipToNextPage() {
        return this.treeViewer != null && this.treeViewer.getSelection() != null && !this.treeViewer.getSelection().isEmpty();
    }

    @Override
    public boolean isChild() {
        return true;
    }

    public void createStepArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite headerComposite = new Composite(composite, 0);
        headerComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        headerComposite.setLayout((Layout)new GridLayout(1, false));
        Label lblHeader = new Label(headerComposite, 64);
        lblHeader.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        lblHeader.setText(StringConstants.WZ_P_TEST_SUITE_INFO);
        this.folderBrowserComposite = new Composite(composite, 0);
        this.folderBrowserComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    public void setInput(Map<String, Object> sharedData) {
        TestCaseFolderEntityProvider entityProvider = new TestCaseFolderEntityProvider(new ArrayList<String>());
        TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(null, (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)entityProvider, (AbstractEntityViewerFilter)new EntityViewerFilter((EntityProvider)entityProvider));
        dialog.setAllowMultiple(false);
        dialog.setTitle(StringConstants.DIA_TITLE_TEST_CASE_FOLDER_BROWSER);
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        try {
            FolderEntity rootFolder = FolderController.getInstance().getTestSuiteRoot(currentProject);
            FolderTreeEntity rootFolderTreeEntity = new FolderTreeEntity(rootFolder, null);
            dialog.setInput(Arrays.asList(rootFolderTreeEntity));
            this.treeViewer = dialog.createTreeViewer(this.folderBrowserComposite);
            Object selection = sharedData.get("testSuiteFolder");
            if (selection == null) {
                selection = rootFolderTreeEntity;
            }
            this.treeViewer.setSelection((ISelection)new StructuredSelection(selection));
            this.firePageChanged();
            this.folderBrowserComposite.layout(true, true);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void registerControlModifyListeners() {
        this.treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestSuiteFolderSelectionWizardPage.this.firePageChanged();
            }
        });
    }

    public Map<String, Object> storeControlStates() {
        HashMap<String, Object> sharedData = new HashMap<String, Object>();
        sharedData.put("testSuiteFolder", ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement());
        return sharedData;
    }

    public String getTitle() {
        return StringConstants.WZ_P_TEST_SUITE_TITLE;
    }
}

