/*
 * Decompiled with CFR 0.152.
 */
package coms.kms.katalon.composer.integration.testcloud.dialogs;

import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.integration.testcloud.constants.IntegrationTestCloudComposerMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.integration.analytics.entity.AnalyticsUser;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SetupTunnelInstructionDialog
extends AbstractDialog {
    private static final Map<String, String> OS_OPTIONS = new LinkedHashMap<String, String>();
    private String CONFIG_TUNNEL_COMMAND_WINDOWS = "kt config --tenant KatalonStudio --username \"{0}\" --organization-id \"{1,number,#}\" --api-key \"{2}\"";
    private String CONFIG_TUNNEL_COMMAND_MAC = "/Applications/kt config --tenant KatalonStudio --username \"{0}\" --organization-id \"{1,number,#}\" --api-key \"{2}\"";
    private String CONFIG_TUNNEL_COMMAND_LINUX = "./kt config --tenant KatalonStudio --username \"{0}\" --organization-id \"{1,number,#}\" --api-key \"{2}\"";
    private String START_TUNNEL_COMMAND_WINDOWS = "kt start";
    private String START_TUNNEL_COMMAND_MAC = "/Applications/kt start";
    private String START_TUNNEL_COMMAND_LINUX = "./kt start";
    private AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
    private Combo osSelect;
    private Text setupCommandText;
    private Text startCommandText;
    private String cachedApiKey;

    static {
        OS_OPTIONS.put("Windows x64", "windows-64");
        OS_OPTIONS.put("Windows x86", "windows-32");
        OS_OPTIONS.put("MacOS x64", "macos");
        OS_OPTIONS.put("Linux x86", "linux");
    }

    public SetupTunnelInstructionDialog(Shell parentShell) {
        super(parentShell);
    }

    public String getDialogTitle() {
        return IntegrationTestCloudComposerMessageConstants.DIA_TUNNEL_HELPER_TITLE;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
        this.updateCommands();
    }

    protected Control createDialogContainer(Composite parent) {
        Composite containerWrapper = (Composite)ComponentBuilder.gridContainer((Composite)parent).build();
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)containerWrapper).autoWidth(400).margin(10).fillHorizontal().gridVerticalSpacing(20).build();
        Composite osSection = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        ComponentBuilder.label((Composite)osSection).text(IntegrationTestCloudComposerMessageConstants.LBL_SELECT_OS).fillHorizontal().build();
        Composite osInputSection = (Composite)ComponentBuilder.gridContainer((Composite)osSection, (int)3).groupIndent().fillHorizontal().build();
        ComponentBuilder.label((Composite)osInputSection).text(IntegrationTestCloudComposerMessageConstants.LBL_YOUR_OS).build();
        this.osSelect = (Combo)ComponentBuilder.comboBox((Composite)osInputSection, (int)2056).options(OS_OPTIONS).select(this.getCurrentOSIndex()).onChange(event -> this.updateCommands()).fillHorizontal().build();
        ComponentBuilder.button((Composite)osInputSection).text(GlobalMessageConstants.DOWNLOAD).onClick(event -> {
            String os = (String)this.osSelect.getData();
            try {
                String downloadUrl = this.getDownloadUrl(os);
                ComponentUtil.triggerLink((String)downloadUrl);
            }
            catch (MalformedURLException error) {
                LoggerSingleton.logError((Throwable)error);
            }
        }).top().build();
        Composite configCommandSection = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        ComponentBuilder.label((Composite)configCommandSection).text(IntegrationTestCloudComposerMessageConstants.LBL_SETUP_TUNNEL_COMMAND).fillHorizontal().build();
        Composite configCommandInputSection = (Composite)ComponentBuilder.gridContainer((Composite)configCommandSection, (int)3).groupIndent().fillHorizontal().build();
        this.setupCommandText = (Text)ComponentBuilder.textArea((Composite)configCommandInputSection, (int)2056).rows(4).autoSelect().fillHorizontal().build();
        ComponentBuilder.button((Composite)configCommandInputSection).text(GlobalMessageConstants.COPY).top().onClick(event -> {
            this.setupCommandText.selectAll();
            this.setupCommandText.copy();
        }).build();
        Composite runCommandSection = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        ComponentBuilder.label((Composite)runCommandSection).text(IntegrationTestCloudComposerMessageConstants.LBL_START_TUNNEL_COMMAND).fillHorizontal().build();
        Composite runCommandInputSection = (Composite)ComponentBuilder.gridContainer((Composite)runCommandSection, (int)3).groupIndent().fillHorizontal().build();
        this.startCommandText = (Text)ComponentBuilder.textArea((Composite)runCommandInputSection, (int)2056).rows(1).autoSelect().fillHorizontal().build();
        ComponentBuilder.button((Composite)runCommandInputSection).text(GlobalMessageConstants.COPY).top().onClick(event -> {
            this.startCommandText.selectAll();
            this.startCommandText.copy();
        }).build();
        return null;
    }

    private int getCurrentOSIndex() {
        String arch;
        String currentOS = "";
        String os = SystemUtils.OS_NAME;
        currentOS = (os = os.toLowerCase()).contains("windows") ? ((arch = SystemUtils.OS_ARCH).contains("86") ? "windows-32" : "windows-64") : (os.contains("mac") ? "macos" : "linux");
        ArrayList<String> supportedOSes = new ArrayList<String>(OS_OPTIONS.values());
        return supportedOSes.indexOf(currentOS);
    }

    private String getDownloadUrl(String os) throws MalformedURLException {
        String tunnelServer = StringUtils.defaultString((String)System.getProperty("tunnelServer"), (String)"https://tunnel-manager.katalon.com");
        String tunnelPackagePath = MessageFormat.format("/clients/downloads/latest?os={0}", os);
        return new URL(new URL(tunnelServer), tunnelPackagePath).toString();
    }

    private boolean checkOsType(String osName) {
        return StringUtils.containsIgnoreCase((String)this.osSelect.getText(), (String)osName);
    }

    private void updateCommands() {
        if (!this.hasApiKey()) {
            DialogUtil.createSafeProgressDialog(monitor -> {
                monitor.beginTask(IntegrationTestCloudComposerMessageConstants.MSG_GENERATING_COMMAND, 2);
                monitor.worked(1);
                this.fetchApiKey();
                monitor.worked(1);
                UISynchronizeService.syncExec(() -> this.updateCommands());
            });
        } else {
            UISynchronizeService.syncExec(() -> {
                try {
                    String command = this.generateSetupCommand();
                    this.setupCommandText.setText(command);
                }
                catch (Exception exception) {}
            });
        }
        UISynchronizeService.syncExec(() -> {
            String startCommand = this.generateStartCommand();
            this.startCommandText.setText(startCommand);
        });
    }

    private boolean hasApiKey() {
        return StringUtils.isNotBlank((String)this.cachedApiKey);
    }

    private void fetchApiKey() throws Exception {
        this.cachedApiKey = TestOpsService.getActiveInstance().fetchAPIKey();
    }

    private String generateSetupCommand() throws Exception {
        String email;
        AnalyticsUser user = TestOpsService.getActiveInstance().getUser();
        String string = email = user != null ? user.getEmail() : ApplicationContext.getInstance().getUserId();
        if (!this.hasApiKey()) {
            this.fetchApiKey();
        }
        AnalyticsOrganization organization = this.analyticsSettingStore.getOrganization();
        Long orgId = organization.getId();
        String commandTemplate = this.checkOsType("Windows") ? this.CONFIG_TUNNEL_COMMAND_WINDOWS : (this.checkOsType("MacOS") ? this.CONFIG_TUNNEL_COMMAND_MAC : this.CONFIG_TUNNEL_COMMAND_LINUX);
        return MessageFormat.format(commandTemplate, email, orgId, this.cachedApiKey);
    }

    private String generateStartCommand() {
        if (this.checkOsType("Windows")) {
            return this.START_TUNNEL_COMMAND_WINDOWS;
        }
        if (this.checkOsType("MacOS")) {
            return this.START_TUNNEL_COMMAND_MAC;
        }
        return this.START_TUNNEL_COMMAND_LINUX;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, GlobalMessageConstants.DIA_CLOSE, true);
    }
}

