/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.codeassist.proposal.completion;

import com.kms.katalon.composer.codeassist.util.KatalonContextUtil;
import com.kms.katalon.custom.keyword.KeywordClass;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyJavaFieldCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.TypeProposalInfo;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.StyledString;

public class KatalonBuiltInKeywordCompletionProposal
extends GroovyCompletionProposal {
    private final KeywordClass keywordClass;
    private JavaContentAssistInvocationContext javaContext;

    public KatalonBuiltInKeywordCompletionProposal(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, KeywordClass keywordClass) {
        super(9, context.completionLocation);
        this.keywordClass = keywordClass;
        this.javaContext = javaContext;
        this.setRelevance(Relevance.HIGH.getRelevance());
        String aliasName = keywordClass.getAliasName();
        if (context.location == ContentAssistLocation.IMPORT) {
            aliasName = String.valueOf(keywordClass.getName()) + " as " + keywordClass.getAliasName();
        }
        this.setName(aliasName.toCharArray());
        this.setCompletion(aliasName.toCharArray());
        int completionLength = context.completionExpression.length();
        this.setReplaceRange(context.completionLocation - completionLength, context.completionLocation + aliasName.length() - completionLength);
        ClassNode classNode = new ClassNode(keywordClass.getType());
        char[] classSignature = ProposalUtils.createTypeSignature((ClassNode)classNode);
        this.setTypeName(classSignature);
        this.setSignature(classSignature);
    }

    public StyledString getStyledDisplayString() {
        return new StyledString(this.keywordClass.getAliasName()).append(KatalonContextUtil.getClassSignature(this.keywordClass)).append(KatalonContextUtil.getKatalonSignature());
    }

    public KeywordClass getKeywordClass() {
        return this.keywordClass;
    }

    public IJavaCompletionProposal getCompletionProposal() {
        return new LocalKeywordCompletionProposal(this, this.getStyledDisplayString());
    }

    private class LocalKeywordCompletionProposal
    extends GroovyJavaFieldCompletionProposal {
        private ImportRewrite fImportRewrite;
        private ContextSensitiveImportRewriteContext fImportContext;
        private ICompilationUnit fCompilationUnit;
        private KatalonBuiltInKeywordCompletionProposal proposal;

        public LocalKeywordCompletionProposal(KatalonBuiltInKeywordCompletionProposal proposal, StyledString styledString) {
            super((CompletionProposal)proposal, styledString, KatalonBuiltInKeywordCompletionProposal.this.javaContext);
            this.proposal = proposal;
        }

        protected ProposalInfo getProposalInfo() {
            return new TypeProposalInfo(KatalonBuiltInKeywordCompletionProposal.this.javaContext.getProject(), (CompletionProposal)this.proposal);
        }

        public String getReplacementString() {
            return super.getReplacementString();
        }

        public int getReplacementLength() {
            return this.fPrefix.length();
        }

        public void apply(IDocument document, char trigger, int offset) {
            super.apply(document, trigger, offset);
            try {
                boolean isImportedSuccessfully = this.addingPackage(this.proposal.getKeywordClass());
                if (isImportedSuccessfully && this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges()) {
                    int oldLen = document.getLength();
                    this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()).apply(document, 2);
                    this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log((Throwable)e);
            }
            catch (BadLocationException e) {
                JavaPlugin.log((Throwable)e);
            }
        }

        private ImportRewrite createImportRewrite() {
            this.fCompilationUnit = KatalonBuiltInKeywordCompletionProposal.this.javaContext.getCompilationUnit();
            if (this.fCompilationUnit != null && this.allowAddingImports() && !JavaModelUtil.isPackageInfo((ICompilationUnit)this.fCompilationUnit)) {
                try {
                    CompilationUnit cu = this.getASTRoot(this.fCompilationUnit);
                    if (cu == null) {
                        ImportRewrite rewrite = StubUtility.createImportRewrite((ICompilationUnit)this.fCompilationUnit, (boolean)true);
                        this.fImportContext = null;
                        return rewrite;
                    }
                    ImportRewrite rewrite = StubUtility.createImportRewrite((CompilationUnit)cu, (boolean)true);
                    this.fImportContext = new ContextSensitiveImportRewriteContext(cu, this.fInvocationContext.getInvocationOffset(), rewrite);
                    return rewrite;
                }
                catch (CoreException x) {
                    JavaPlugin.log((Throwable)x);
                }
            }
            return null;
        }

        private CompilationUnit getASTRoot(ICompilationUnit compilationUnit) {
            return SharedASTProviderCore.getAST((ITypeRoot)compilationUnit, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
        }

        private boolean allowAddingImports() {
            if (this.isInJavadoc() && this.proposal.getKind() == 9 && this.fInvocationContext.getCoreContext().isInJavadocText()) {
                return false;
            }
            IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            return preferenceStore.getBoolean("content_assist_add_import");
        }

        public boolean addingPackage(KeywordClass keywordClass) {
            if (keywordClass != null) {
                if (this.fImportRewrite == null) {
                    this.fImportRewrite = this.createImportRewrite();
                }
                if (this.fImportRewrite != null) {
                    List existingImports = (List)ReflectionUtils.getPrivateField(ImportRewrite.class, (String)"existingImports", (Object)this.fImportRewrite);
                    boolean isImported = true;
                    for (String importPackage : existingImports) {
                        if (!importPackage.contains(this.getQualifiedTypeName())) continue;
                        isImported = false;
                    }
                    if (isImported) {
                        String qualifiedTypeName = String.valueOf(this.getQualifiedTypeName()) + " as " + keywordClass.getAliasName();
                        this.fImportRewrite.addImport(qualifiedTypeName, (ImportRewrite.ImportRewriteContext)this.fImportContext);
                        return true;
                    }
                }
            }
            return false;
        }

        public String getQualifiedTypeName() {
            return String.valueOf(Signature.toCharArray((char[])Signature.getTypeErasure((char[])this.proposal.getSignature())));
        }
    }
}

