/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.WebDriverCleanerUtil;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.webui.configuration.WebDriverManagerRunConfiguration;
import com.kms.katalon.execution.webui.configuration.WebUiRunConfiguration;
import com.kms.katalon.execution.webui.driver.IEDriverConnector;
import com.kms.katalon.execution.webui.driver.SeleniumWebDriverProvider;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class IERunConfiguration
extends WebUiRunConfiguration {
    private String ieDriverPath = this.buildIEDriverPath();

    public IERunConfiguration(String projectDir) throws IOException {
        super(projectDir, new IEDriverConnector(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
    }

    private String buildIEDriverPath() {
        String driverPath = SeleniumWebDriverProvider.getIEDriverPath();
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.core.webui");
        boolean isUpdateDriverAllowed = store.getBoolean("webui.autoUpdateDrivers");
        if (isUpdateDriverAllowed && ApplicationRunningMode.get() == RunningMode.CONSOLE) {
            WebDriverManagerRunConfiguration webDriverManagerRunConfiguration = new WebDriverManagerRunConfiguration();
            try {
                WebDriverCleanerUtil.terminateIEDriverServer();
                webDriverManagerRunConfiguration.downloadDriver(WebUIDriverType.IE_DRIVER, SeleniumWebDriverProvider.getTempDriverDirectory());
                String tempDriverPath = SeleniumWebDriverProvider.getTempIEDriverPath();
                if (new File(tempDriverPath).exists()) {
                    driverPath = tempDriverPath;
                }
            }
            catch (IOException | InterruptedException e) {
                LogUtil.logError((Throwable)e);
            }
            LogUtil.printOutputLine((String)("IEDriverServer is located at: " + driverPath));
        } else {
            LogUtil.printOutputLine((String)String.format("IEDriverServer is located at default location: %s. In case your browser is updated to a newer version, please use this command to update IEDriverServer: --config -%s=true", driverPath, "webui.autoUpdateDrivers"));
        }
        return driverPath;
    }

    @Override
    public Map<String, IDriverConnector> getDriverConnectors() {
        Map<String, IDriverConnector> driverConnectors = super.getDriverConnectors();
        for (Map.Entry<String, IDriverConnector> entry : driverConnectors.entrySet()) {
            if (!(entry.getValue() instanceof IEDriverConnector)) continue;
            IEDriverConnector driverConnector = (IEDriverConnector)entry.getValue();
            driverConnector.setIeDriverPath(this.ieDriverPath);
        }
        return driverConnectors;
    }

    public IRunConfiguration cloneConfig() throws IOException {
        return new IERunConfiguration(this.projectDir);
    }

    public boolean allowsRecording() {
        return true;
    }
}

