/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.util.HttpClientUtil;
import com.kms.katalon.core.util.download.FileDownloader;
import com.kms.katalon.core.util.download.FileDownloaderException;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.execution.webui.configuration.WebDriverManagerInfo;
import com.kms.katalon.execution.webui.util.PlatformUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class WebDriverManagerRunConfiguration {
    private static final String KATALON_WEB_DRIVER_MANAGER_UPDATE_JSON = "https://download.katalon.com/webdrivermanager/jdk17/update.json";
    private static final String GECKO_RELEASES_JSON = "https://raw.githubusercontent.com/katalon-studio/katalon-studio/master/gecko-releases.json";
    private File logFile;
    private File errorLogFile;

    public File getWebDriverManagerFatJar() throws IOException {
        if (Platform.inDevelopmentMode()) {
            File parentFolder = new File(ClassPathResolver.getBundleLocation((Bundle)FrameworkUtil.getBundle(WebDriverManagerRunConfiguration.class)));
            return new File(parentFolder, "resources/tools/webdriver/webdrivermanager-5.7.0-fat.jar");
        }
        File parentFolder = ClassPathResolver.getConfigurationFolder();
        return new File(parentFolder, "resources/tools/webdriver/webdrivermanager-5.7.0-fat.jar");
    }

    public void downloadDriver(WebUIDriverType webUIDriverType, File driverLocation) throws IOException, InterruptedException {
        String osArg;
        String architecture;
        if (!driverLocation.exists()) {
            driverLocation.mkdirs();
        }
        File webDriverManagerFile = null;
        try {
            webDriverManagerFile = this.downloadWebDriverManager();
        }
        catch (FileDownloaderException e) {
            this.printErrorLog("Failed to download WebDriverManager, error: " + e.getMessage() + "\n");
        }
        if (webDriverManagerFile == null || !webDriverManagerFile.exists()) {
            this.printLog("Use built-in WebDriverManager\n");
            webDriverManagerFile = this.getWebDriverManagerFatJar();
        }
        String proxyCommand = this.getProxyCommand();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(ClassPathResolver.getInstalledJRE((boolean)false));
        commands.add(String.format("-Dwdm.cachePath=%s", driverLocation.getCanonicalPath()));
        commands.add("-Dwdm.forceDownload=true");
        commands.add(String.format("-Dwdm.geckoDriverUrl=%s", GECKO_RELEASES_JSON));
        if (StringUtils.isNotEmpty((String)proxyCommand)) {
            commands.add(proxyCommand);
        }
        if (StringUtils.isNotEmpty((String)(architecture = this.getArchitecture(webUIDriverType)))) {
            commands.add(architecture);
        }
        if (StringUtils.isNotBlank((String)(osArg = this.getOSArgument()))) {
            commands.add(osArg);
        }
        commands.add("-jar");
        commands.add(webDriverManagerFile.getName());
        commands.add("resolveDriverFor");
        commands.add(this.getDriverName(webUIDriverType));
        ProcessBuilder builder = new ProcessBuilder(commands).directory(new File(webDriverManagerFile.getParent()));
        if (this.getLogFile() != null) {
            builder.redirectOutput(ProcessBuilder.Redirect.appendTo(this.getLogFile()));
        }
        if (this.getErrorLogFile() != null) {
            builder.redirectError(ProcessBuilder.Redirect.appendTo(this.getErrorLogFile()));
        }
        if (!builder.start().waitFor(120L, TimeUnit.SECONDS)) {
            throw new IOException("Process Timeout");
        }
    }

    private String getArchitecture(WebUIDriverType webUIDriverType) {
        switch (webUIDriverType) {
            case IE_DRIVER: {
                return "-Dwdm.architecture=32";
            }
            case EDGE_CHROMIUM_DRIVER: {
                if (!PlatformUtil.isWindowsOS()) break;
                return "-Dwdm.architecture=32";
            }
        }
        return "";
    }

    private String getOSArgument() {
        if (OSUtil.isMac()) {
            return "-Dwdm.os=MAC";
        }
        if (OSUtil.isWindows()) {
            return "-Dwdm.os=WIN";
        }
        if (OSUtil.isUnix() || OSUtil.isSolaris()) {
            return "-Dwdm.os=LINUX";
        }
        return "";
    }

    private String getDriverName(WebUIDriverType webUIDriverType) {
        switch (webUIDriverType) {
            case CHROME_DRIVER: 
            case HEADLESS_DRIVER: {
                return "chrome";
            }
            case EDGE_DRIVER: 
            case EDGE_CHROMIUM_DRIVER: {
                return "edge";
            }
            case FIREFOX_DRIVER: 
            case FIREFOX_HEADLESS_DRIVER: {
                return "firefox";
            }
            case IE_DRIVER: {
                return "iexplorer";
            }
        }
        throw new IllegalArgumentException("Driver is not supported");
    }

    private String getProxyCommand() {
        ProxyInformation proxy = ProxyPreferences.getSystemProxyInformation();
        switch (ProxyOption.valueOf((String)proxy.getProxyOption())) {
            case NO_PROXY: 
            case USE_SYSTEM: {
                return "";
            }
            case MANUAL_CONFIG: {
                String url = proxy.getProxyServerAddress();
                String port = Integer.toString(proxy.getProxyServerPort());
                String userName = proxy.getUsername();
                String password = proxy.getPassword();
                if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)password)) {
                    return "-Dwdm.proxy=" + userName + ":" + password + "@" + url + ":" + port;
                }
                return "-Dwdm.proxy=" + url + ":" + port;
            }
        }
        return "";
    }

    public File getErrorLogFile() {
        return this.errorLogFile;
    }

    public void setErrorLogFile(File errorLogFile) {
        this.errorLogFile = errorLogFile;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    private File downloadWebDriverManager() throws FileDownloaderException {
        File downloadedFile = null;
        try {
            this.printLog("Checking WebDriverManager");
            URL url = new URL(KATALON_WEB_DRIVER_MANAGER_UPDATE_JSON);
            URIBuilder uriBuilder = new URIBuilder(url.toURI());
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            WebDriverManagerInfo webDriverManagerInfo = (WebDriverManagerInfo)HttpClientUtil.executeRequest((HttpUriRequest)httpGet, WebDriverManagerInfo.class);
            if (Objects.nonNull(webDriverManagerInfo)) {
                File downloadedFolder;
                File webDriverManagerBuiltinFile = this.getWebDriverManagerFatJar();
                if (Objects.nonNull(webDriverManagerBuiltinFile) && webDriverManagerBuiltinFile.exists()) {
                    this.printLog("Verify built-in webdrivermanager");
                    String fileName = FilenameUtils.getName((String)webDriverManagerBuiltinFile.getAbsolutePath());
                    if (StringUtils.equalsIgnoreCase((String)fileName, (String)webDriverManagerInfo.getFile())) {
                        this.printLog("Using built-in file");
                        return webDriverManagerBuiltinFile;
                    }
                    this.printLog("file name mismatch");
                }
                if (Objects.nonNull(downloadedFile = Paths.get((downloadedFolder = new File(GlobalStringConstants.APP_USER_DIR_LOCATION)).getAbsolutePath(), webDriverManagerInfo.getFile()).toFile()) && downloadedFile.exists()) {
                    this.printLog("The caching file exists");
                    String checksum = this.hashSha256(downloadedFile);
                    if (StringUtils.equalsIgnoreCase((String)checksum, (String)webDriverManagerInfo.getSha256())) {
                        this.printLog("Using caching file");
                        return downloadedFile;
                    }
                    this.printLog("checksum mismatch");
                }
                this.printLog("Downloading file from S3...");
                URIBuilder builder = new URIBuilder();
                builder.setScheme(url.getProtocol());
                builder.setHost(url.getHost());
                CharSequence[] paths = url.getPath().split("/");
                paths[paths.length - 1] = webDriverManagerInfo.getFile();
                builder.setPath(String.join((CharSequence)"/", paths));
                URL downloadUrl = builder.build().toURL();
                FileOutputStream outputStream = new FileOutputStream(downloadedFile);
                FileDownloader fileDownloader = new FileDownloader(-1L);
                fileDownloader.download(downloadUrl.toString(), (OutputStream)outputStream, null);
                this.printLog("The file download was successful");
                String checksum = this.hashSha256(downloadedFile);
                if (!StringUtils.equalsIgnoreCase((String)checksum, (String)webDriverManagerInfo.getSha256())) {
                    throw new IOException("checksum mismatch");
                }
                return downloadedFile;
            }
        }
        catch (Exception e) {
            throw new FileDownloaderException(e);
        }
        return null;
    }

    private void printLog(String log) {
        try {
            if (Objects.nonNull(this.logFile) && this.logFile.exists()) {
                FileUtils.writeStringToFile((File)this.logFile, (String)(String.valueOf(log) + "\n"), (boolean)true);
            } else {
                LogUtil.printOutputLine((String)log);
            }
        }
        catch (IOException iOException) {}
    }

    private void printErrorLog(String log) {
        try {
            if (Objects.nonNull(this.errorLogFile) && this.errorLogFile.exists()) {
                FileUtils.writeStringToFile((File)this.errorLogFile, (String)(String.valueOf(log) + "\n"), (boolean)true);
            } else {
                LogUtil.printErrorLine((String)log);
            }
        }
        catch (IOException iOException) {}
    }

    private String hashSha256(File file) {
        byte[] data = null;
        try {
            data = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
        }
        catch (IOException iOException) {}
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("SHA-256").digest(data);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return new BigInteger(1, hash).toString(16);
    }
}

