/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration.contributor;

import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.webui.configuration.RemoteWebRunConfiguration;
import com.kms.katalon.execution.webui.constants.StringConstants;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RemoteWebRunConfigurationContributor
implements IRunConfigurationContributor {
    public static final String REMOTE_CONFIGURATION_KEY = "remoteWebDriverUrl";
    public static final String REMOTE_CONFIGURATION_TYPE_KEY = "remoteWebDriverType";
    private static final RemoteWebDriverConnector.RemoteWebDriverConnectorType DEFAULT_REMOTE_WEB_DRIVER_CONNECTOR_TYPE = RemoteWebDriverConnector.RemoteWebDriverConnectorType.Selenium;
    private String remoteWebDriverUrl = "";
    private RemoteWebDriverConnector.RemoteWebDriverConnectorType remoteWebDriverType;
    public static final StringConsoleOption REMOTE_WEB_DRIVER_URL_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return RemoteWebRunConfigurationContributor.REMOTE_CONFIGURATION_KEY;
        }

        public boolean isRequired() {
            return false;
        }
    };
    public static final StringConsoleOption REMOTE_WEB_DRIVER_CONNECTOR_TYPE_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return RemoteWebRunConfigurationContributor.REMOTE_CONFIGURATION_TYPE_KEY;
        }

        public String getDefaultArgumentValue() {
            return DEFAULT_REMOTE_WEB_DRIVER_CONNECTOR_TYPE.toString();
        }

        public boolean isRequired() {
            return false;
        }
    };

    public String getId() {
        return WebUIDriverType.REMOTE_WEB_DRIVER.toString();
    }

    public IRunConfiguration getRunConfiguration(String projectDir) throws IOException, ExecutionException {
        RemoteWebRunConfiguration runConfiguration = new RemoteWebRunConfiguration(projectDir);
        this.remoteWebDriverUrl = StringUtils.isNotBlank((String)this.remoteWebDriverUrl) ? this.remoteWebDriverUrl : runConfiguration.getRemoteServerUrl();
        RemoteWebDriverConnector.RemoteWebDriverConnectorType remoteWebDriverConnectorType = this.remoteWebDriverType = this.remoteWebDriverType != null ? this.remoteWebDriverType : runConfiguration.getRemoteWebDriverConnectorType();
        if (StringUtils.isBlank((String)this.remoteWebDriverUrl)) {
            throw new ExecutionException(StringConstants.REMOTE_WEB_DRIVER_ERR_NO_URL_AVAILABLE);
        }
        if (this.remoteWebDriverType == null) {
            throw new ExecutionException(StringConstants.REMOTE_WEB_DRIVER_ERR_NO_TYPE_AVAILABLE);
        }
        runConfiguration.setRemoteServerUrl(this.remoteWebDriverUrl);
        runConfiguration.setRemoteWebDriverConnectorType(this.remoteWebDriverType);
        return runConfiguration;
    }

    public IRunConfiguration getRunConfiguration(String projectDir, RunConfigurationDescription runConfigurationDescription) throws IOException, ExecutionException, InterruptedException {
        if (runConfigurationDescription != null && runConfigurationDescription.getRunConfigurationData() != null) {
            RemoteWebRunConfiguration remoteWebRunConfiguration = new RemoteWebRunConfiguration(projectDir);
            Map runConfigurationData = runConfigurationDescription.getRunConfigurationData();
            String remoteWebDriverUrlConfig = this.getRemoteWebDriverUrl(runConfigurationData);
            this.remoteWebDriverUrl = StringUtils.isNotEmpty((String)remoteWebDriverUrlConfig) ? remoteWebDriverUrlConfig : remoteWebRunConfiguration.getRemoteServerUrl();
            RemoteWebDriverConnector.RemoteWebDriverConnectorType remoteWebDriverTypeConfig = this.getRemoteWebDriverType(runConfigurationData);
            this.remoteWebDriverType = remoteWebDriverTypeConfig != null ? remoteWebDriverTypeConfig : remoteWebRunConfiguration.getRemoteWebDriverConnectorType();
            RemoteWebRunConfiguration clone = (RemoteWebRunConfiguration)remoteWebRunConfiguration.cloneConfig();
            clone.setRemoteServerUrl(this.remoteWebDriverUrl);
            clone.setRemoteWebDriverConnectorType(this.remoteWebDriverType);
            this.setExecutionProfile(clone, runConfigurationDescription);
            return clone;
        }
        RemoteWebRunConfiguration remoteWebRunConfiguration = new RemoteWebRunConfiguration(projectDir);
        this.remoteWebDriverUrl = remoteWebRunConfiguration.getRemoteServerUrl();
        this.remoteWebDriverType = remoteWebRunConfiguration.getRemoteWebDriverConnectorType();
        if (runConfigurationDescription != null) {
            this.setExecutionProfile(remoteWebRunConfiguration, runConfigurationDescription);
        }
        return remoteWebRunConfiguration;
    }

    private void setExecutionProfile(RemoteWebRunConfiguration configuration, RunConfigurationDescription runConfigurationDescription) throws ExecutionException {
        try {
            configuration.setExecutionProfile(GlobalVariableController.getInstance().getGlobalVariableCollection(runConfigurationDescription.getProfileName(), ProjectController.getInstance().getCurrentProject()));
        }
        catch (DALException dALException) {
            throw new ExecutionException(MessageFormat.format("Profile {0} not found.", runConfigurationDescription.getProfileName()));
        }
    }

    public int getPreferredOrder() {
        return 6;
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList consoleOptionList = new ArrayList();
        consoleOptionList.add((ConsoleOption<?>)REMOTE_WEB_DRIVER_URL_CONSOLE_OPTION);
        consoleOptionList.add((ConsoleOption<?>)REMOTE_WEB_DRIVER_CONNECTOR_TYPE_CONSOLE_OPTION);
        return consoleOptionList;
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (StringUtils.isBlank((String)argumentValue)) {
            return;
        }
        if (consoleOption == REMOTE_WEB_DRIVER_URL_CONSOLE_OPTION) {
            this.remoteWebDriverUrl = argumentValue.trim();
            return;
        }
        if (consoleOption == REMOTE_WEB_DRIVER_CONNECTOR_TYPE_CONSOLE_OPTION) {
            this.remoteWebDriverType = RemoteWebDriverConnector.RemoteWebDriverConnectorType.valueOf(argumentValue);
        }
    }

    public List<ConsoleOption<?>> getConsoleOptions(final RunConfigurationDescription runConfigurationDescription) {
        return Arrays.asList(new StringConsoleOption(){

            public String getOption() {
                return RemoteWebRunConfigurationContributor.REMOTE_CONFIGURATION_TYPE_KEY;
            }

            public String getDefaultArgumentValue() {
                return DEFAULT_REMOTE_WEB_DRIVER_CONNECTOR_TYPE.toString();
            }

            public boolean isRequired() {
                return false;
            }

            public boolean hasArgument() {
                if (runConfigurationDescription == null) {
                    return false;
                }
                Map runConfigurationData = runConfigurationDescription.getRunConfigurationData();
                return runConfigurationData != null && runConfigurationData.containsKey(RemoteWebRunConfigurationContributor.REMOTE_CONFIGURATION_TYPE_KEY);
            }

            public String getValue() {
                Map runConfigurationData = runConfigurationDescription.getRunConfigurationData();
                return RemoteWebRunConfigurationContributor.this.getRemoteWebDriverType(runConfigurationData).name();
            }
        }, new StringConsoleOption(){

            public String getOption() {
                return RemoteWebRunConfigurationContributor.REMOTE_CONFIGURATION_KEY;
            }

            public boolean isRequired() {
                return false;
            }

            public boolean hasArgument() {
                if (runConfigurationDescription == null) {
                    return false;
                }
                Map runConfigurationData = runConfigurationDescription.getRunConfigurationData();
                return runConfigurationDescription != null && runConfigurationData.containsKey(RemoteWebRunConfigurationContributor.REMOTE_CONFIGURATION_KEY);
            }

            public String getValue() {
                return RemoteWebRunConfigurationContributor.this.getRemoteWebDriverUrl(runConfigurationDescription.getRunConfigurationData());
            }
        });
    }

    private RemoteWebDriverConnector.RemoteWebDriverConnectorType getRemoteWebDriverType(Map<String, String> runConfigurationData) {
        String webDriverType = runConfigurationData.get(REMOTE_CONFIGURATION_TYPE_KEY);
        if (StringUtils.isEmpty((String)webDriverType)) {
            return null;
        }
        return RemoteWebDriverConnector.RemoteWebDriverConnectorType.valueOf(webDriverType);
    }

    private String getRemoteWebDriverUrl(Map<String, String> runConfigurationData) {
        return runConfigurationData.get(REMOTE_CONFIGURATION_KEY);
    }
}

