/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.integration.azure.constant.StringConstants;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureTestSuiteRef;
import com.kms.katalon.integration.azure.model.AzureTestSuitesRef;
import com.kms.katalon.integration.azure.provider.AzureIntegrationRequest;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import com.kms.katalon.logging.LogUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AzureIntegrationUtil {
    public static boolean isIntegrationEnabled(String projectDir) {
        AzureSettingStore store = new AzureSettingStore(projectDir);
        return store.isIntegrationEnabled();
    }

    public static IntegratedEntity getIntegratedEntity(IntegratedFileEntity fileEntity) {
        return fileEntity.getIntegratedEntity(GlobalStringConstants.AZURE_DEVOPS_NAME);
    }

    public static boolean isPositiveInteger(String number) {
        if (number == null) {
            return false;
        }
        try {
            int parsedNumber = Integer.parseInt(number);
            return parsedNumber >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static List<AzureTestSuiteRef> getTestSuiteRefs(AzureCredential credential, int testPlanId, int testCaseId) {
        try {
            AzureTestSuitesRef testSuites = AzureIntegrationRequest.getTestSuitesByTestCaseId(credential, testCaseId);
            ArrayList<AzureTestSuiteRef> result = new ArrayList<AzureTestSuiteRef>();
            AzureTestSuiteRef[] azureTestSuiteRefArray = testSuites.getValue();
            int n = azureTestSuiteRefArray.length;
            int n2 = 0;
            while (n2 < n) {
                AzureTestSuiteRef testSuite = azureTestSuiteRefArray[n2];
                if (testSuite.getTestPlan().getId() == testPlanId) {
                    result.add(testSuite);
                }
                ++n2;
            }
            if (!result.isEmpty()) {
                return result;
            }
            LogUtil.logError((String)MessageFormat.format(StringConstants.MSG_ERROR_TEST_CASE_IS_NOT_CONTAINED_IN_TEST_PLAN, testCaseId, testPlanId));
            return Collections.emptyList();
        }
        catch (AzureApiException azureApiException) {
            return Collections.emptyList();
        }
    }
}

