/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.integration;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.core.util.internal.ProcessUtil;
import com.kms.katalon.core.util.internal.ZipUtil;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.util.EntityTagUtil;
import com.kms.katalon.execution.collector.AzureDevOpsReport;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.integration.azure.AzureIntegrationUtil;
import com.kms.katalon.integration.azure.constant.StringConstants;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureBuildRef;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureProjectRef;
import com.kms.katalon.integration.azure.model.AzureReleaseRef;
import com.kms.katalon.integration.azure.model.AzureTestAttachment;
import com.kms.katalon.integration.azure.model.AzureTestCaseResult;
import com.kms.katalon.integration.azure.model.AzureTestCaseResultBody;
import com.kms.katalon.integration.azure.model.AzureTestPlanRef;
import com.kms.katalon.integration.azure.model.AzureTestPoint;
import com.kms.katalon.integration.azure.model.AzureTestPointList;
import com.kms.katalon.integration.azure.model.AzureTestRun;
import com.kms.katalon.integration.azure.model.AzureTestSuiteRef;
import com.kms.katalon.integration.azure.model.TestPointMapper;
import com.kms.katalon.integration.azure.model.TestPointMappers;
import com.kms.katalon.integration.azure.provider.AzureIntegrationRequest;
import com.kms.katalon.integration.azure.setting.AzureAttachmentSendingType;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import com.kms.katalon.integration.azure.setting.ExecutionMappingUtil;
import com.kms.katalon.integration.azure.setting.ExecutionStatusHelper;
import com.kms.katalon.integration.azure.setting.ExecutionStatusMapping;
import com.kms.katalon.integration.azure.setting.ReportFormatHelper;
import com.kms.katalon.integration.azure.setting.TestConfigurationMapping;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class AzureReportIntegrationContribution
implements ReportIntegrationContribution {
    public static final String ADO_TEST_PLAN_ID_OPTION = "adoPlanId";
    public static final String ADO_TEST_PLAN_ID_SECOND_OPTION = "adoPlanID";
    public static final String ADO_TEST_RUN_NAME = "adoTestRunName";
    private String rawADOPlanId;
    private int testPlanId = -1;
    private String testRunName;
    private AzureDevOpsReport trackingReport = new AzureDevOpsReport();
    public static final StringConsoleOption ADO_TEST_PLAN_ID_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return AzureReportIntegrationContribution.ADO_TEST_PLAN_ID_OPTION;
        }

        public boolean isRequired() {
            return false;
        }
    };
    public static final StringConsoleOption ADO_TEST_PLAN_ID_SECOND_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return AzureReportIntegrationContribution.ADO_TEST_PLAN_ID_SECOND_OPTION;
        }

        public boolean isRequired() {
            return false;
        }
    };
    public static final StringConsoleOption ADO_TEST_RUN_NAME_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return AzureReportIntegrationContribution.ADO_TEST_RUN_NAME;
        }

        public boolean isRequired() {
            return false;
        }
    };

    public boolean isAllowedGenerateTestSuiteReportWhenRunningTestSuiteCollection() {
        return false;
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList integrationCommandList = new ArrayList();
        integrationCommandList.add((ConsoleOption<?>)ADO_TEST_PLAN_ID_CONSOLE_OPTION);
        integrationCommandList.add((ConsoleOption<?>)ADO_TEST_PLAN_ID_SECOND_CONSOLE_OPTION);
        integrationCommandList.add((ConsoleOption<?>)ADO_TEST_RUN_NAME_CONSOLE_OPTION);
        return integrationCommandList;
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (StringUtils.isBlank((CharSequence)argumentValue)) {
            return;
        }
        if (consoleOption == ADO_TEST_PLAN_ID_CONSOLE_OPTION) {
            this.rawADOPlanId = argumentValue.trim();
        } else if (consoleOption == ADO_TEST_PLAN_ID_SECOND_CONSOLE_OPTION) {
            if (StringUtils.isEmpty((CharSequence)this.rawADOPlanId)) {
                this.rawADOPlanId = argumentValue.trim();
            }
        } else if (consoleOption == ADO_TEST_RUN_NAME_CONSOLE_OPTION) {
            this.testRunName = argumentValue.trim();
        }
    }

    public boolean isIntegrationActive(TestSuiteEntity testSuite) {
        this.trackingReport = new AzureDevOpsReport();
        String projectDir = testSuite.getProject().getFolderLocation();
        boolean isIntegrationEnabled = AzureIntegrationUtil.isIntegrationEnabled(projectDir);
        this.trackingReport.setIntegrationEnabled(isIntegrationEnabled);
        if (!isIntegrationEnabled) {
            return false;
        }
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        return settingStore.isAutoSubmitTestRunEnabled();
    }

    private boolean isUploadedByDefault(String planIdParam, String testRunNameParam, String buildDefIdParam, String releaseDefIdParam) {
        return StringUtils.isEmpty((CharSequence)planIdParam) && StringUtils.isEmpty((CharSequence)testRunNameParam) && StringUtils.isEmpty((CharSequence)buildDefIdParam) && StringUtils.isEmpty((CharSequence)releaseDefIdParam);
    }

    private boolean checkAndSetConsoleArgs(String planIdParam, String testRunNameParam, String buildDefIdParam, String releaseDefIdParam) {
        if (this.isUploadedByDefault(planIdParam, testRunNameParam, buildDefIdParam, releaseDefIdParam)) {
            return true;
        }
        if (!ProcessUtil.isKRE()) {
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringConstants.MSG_INFO_PARAMETER_RECEIVED);
        if (StringUtils.isNotEmpty((CharSequence)planIdParam)) {
            try {
                this.testPlanId = Integer.parseInt(planIdParam);
                if (this.testPlanId < 0) {
                    throw new NumberFormatException();
                }
                stringBuilder.append(" AzureTestPlanId=" + this.testPlanId);
            }
            catch (NumberFormatException exception) {
                exception = new NumberFormatException(MessageFormat.format(StringConstants.MSG_ERROR_INVALID_PARAMETER, planIdParam, ADO_TEST_PLAN_ID_OPTION));
                LogUtil.printAndLogError((Throwable)exception);
                return false;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)testRunNameParam)) {
            stringBuilder.append(" AzureTestRunName=" + testRunNameParam);
        }
        if (StringUtils.isNotEmpty((CharSequence)buildDefIdParam)) {
            try {
                int buildDefId = Integer.parseInt(buildDefIdParam);
                if (buildDefId < 0) {
                    throw new NumberFormatException();
                }
                stringBuilder.append(" AzureBuildDefinitionId=" + buildDefIdParam);
            }
            catch (NumberFormatException exception) {
                exception = new NumberFormatException(MessageFormat.format(StringConstants.MSG_ERROR_INVALID_PARAMETER, buildDefIdParam, "adoBuildDefId (adoDefinitionId)"));
                LogUtil.printAndLogError((Throwable)exception);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)releaseDefIdParam)) {
            try {
                int releaseDefId = Integer.parseInt(releaseDefIdParam);
                if (releaseDefId < 0) {
                    throw new NumberFormatException();
                }
                stringBuilder.append(" AzureReleaseDefinitionId=" + releaseDefIdParam);
            }
            catch (NumberFormatException exception) {
                exception = new NumberFormatException(MessageFormat.format(StringConstants.MSG_ERROR_INVALID_PARAMETER, releaseDefIdParam, "adoReleaseDefId"));
                LogUtil.printAndLogError((Throwable)exception);
            }
        }
        LogUtil.logInfo((String)stringBuilder.toString());
        return true;
    }

    public void uploadTestSuiteCollectionResult(TestSuiteCollectionLogRecord collectionLogRecord) throws Exception {
        AzureBuildRef build;
        String rawReleaseDefinitionId;
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        if (!settingStore.isIntegrationEnabled()) {
            return;
        }
        this.resetArgumentsForKS();
        if (collectionLogRecord == null || collectionLogRecord.getTestSuiteRecords() == null || collectionLogRecord.getTestSuiteRecords().size() <= 0) {
            return;
        }
        List suiteLogRecordList = collectionLogRecord.getTestSuiteRecords();
        String rawBuildDefinitionId = ((TestSuiteLogRecord)suiteLogRecordList.get(0)).getAzurebBuildDefinitionId();
        if (!this.checkAndSetConsoleArgs(this.rawADOPlanId, this.testRunName, rawBuildDefinitionId, rawReleaseDefinitionId = ((TestSuiteLogRecord)suiteLogRecordList.get(0)).getAzurebReleaseDefinitionId())) {
            return;
        }
        int buildDefId = -1;
        if (StringUtils.isNotEmpty((CharSequence)rawBuildDefinitionId)) {
            try {
                buildDefId = Integer.parseInt(rawBuildDefinitionId);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int releaseDefId = -1;
        if (StringUtils.isNotEmpty((CharSequence)rawReleaseDefinitionId)) {
            try {
                releaseDefId = Integer.parseInt(rawReleaseDefinitionId);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        AzureCredential credential = settingStore.getCredential();
        AzureProjectRef azureProject = settingStore.getIntegratedProject();
        if (azureProject == null) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_NO_PROJECT_SELECTED);
            return;
        }
        if (this.testPlanId < 0) {
            AzureTestPlanRef testPlanRef = settingStore.getAzureTestPlan();
            if (testPlanRef == null) {
                LogUtil.logInfo((String)StringConstants.MSG_INFO_NO_TEST_PLAN_SELECTED);
                return;
            }
            this.testPlanId = testPlanRef.getId();
        }
        if (!settingStore.isAutoSubmitTestRunEnabled()) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_SUBMIT_TEST_RUN_IS_DISABLED);
            return;
        }
        if (buildDefId < 0) {
            buildDefId = settingStore.getBuildDefinitionId();
        }
        int buildNumberId = -1;
        if (buildDefId >= 0 && (build = AzureIntegrationRequest.getLatestBuildNumber(credential, azureProject.getId(), buildDefId)) != null) {
            buildNumberId = build.getId();
        }
        if (releaseDefId < 0) {
            releaseDefId = settingStore.getReleaseDefinitionId();
        }
        AzureReleaseRef release = null;
        try {
            if (releaseDefId >= 0) {
                LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_GETTING_LATEST_RELEASE, releaseDefId));
                release = AzureIntegrationRequest.getLatestReleaseWithInProgressEnvironment(credential, azureProject.getId(), releaseDefId);
                if (release == null) {
                    LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_LATEST_RELEASE_NOT_IN_PROGRESS, releaseDefId));
                }
            }
        }
        catch (AzureApiException exception) {
            LogUtil.logError((String)exception.getMessage());
        }
        if (StringUtils.isEmpty((CharSequence)this.testRunName)) {
            this.testRunName = settingStore.getTestRunName();
        }
        if (StringUtils.isEmpty((CharSequence)this.testRunName)) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_TEST_RUN_NAME_IS_EMPTY);
            return;
        }
        TestPointMappers testPointMappers = new TestPointMappers();
        List<TestConfigurationMapping> testConfigurationMappingList = settingStore.getTestConfigurationMappings();
        ArrayList<TestSuiteLogRecord> testSuitesHaveFailedOrErrorTestPoints = new ArrayList<TestSuiteLogRecord>();
        for (TestSuiteLogRecord suiteLog : suiteLogRecordList) {
            TestPointMappers mappersForCurrentTS = this.getAzureTestPointsWithKatalonTestCases(testConfigurationMappingList, project, suiteLog);
            if (mappersForCurrentTS == null || mappersForCurrentTS.isEmpty()) continue;
            testPointMappers.addAll(mappersForCurrentTS);
            if (!this.doesTestSuiteHasFailedOrErrorTestPoints(suiteLog, mappersForCurrentTS)) continue;
            testSuitesHaveFailedOrErrorTestPoints.add(suiteLog);
        }
        if (!testPointMappers.isEmpty()) {
            String azureProjectId = azureProject.getId();
            int[] testPointIds = testPointMappers.getTestPointIds();
            LogUtil.logInfo((String)StringConstants.MSG_INFO_CREATING_TEST_RUN);
            AzureTestRun testRun = AzureIntegrationRequest.createTestRun(credential, azureProjectId, buildNumberId, this.testRunName, this.testPlanId, testPointIds, release);
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_CREATED_TEST_RUN, testRun.getId(), testRun.getUrl()));
            this.trackingReport.setTestRunCreated(true);
            LogUtil.logInfo((String)StringConstants.MSG_INFO_RETRIEVING_TEST_RESULTS);
            AzureTestCaseResultBody getTestCaseResultsBody = AzureIntegrationRequest.getTestCaseResults(credential, azureProjectId, testRun);
            this.trackingReport.setAdoCreatedTestResultCount(getTestCaseResultsBody.getCount());
            AzureTestCaseResult[] updatedResults = this.updateStatusForTestCaseResult(((TestSuiteLogRecord)suiteLogRecordList.get(0)).getHostName(), testPointMappers, settingStore.getExecutionStatusMappings(), getTestCaseResultsBody);
            LogUtil.logInfo((String)StringConstants.MSG_INFO_UPDATE_TEST_RESULTS);
            AzureIntegrationRequest.updateTestCaseResults(credential, azureProjectId, testRun, updatedResults);
            List<AzureTestAttachment> attachments = this.getTestSuiteCollectionAttachments(settingStore, collectionLogRecord, testSuitesHaveFailedOrErrorTestPoints);
            if (attachments != null && !attachments.isEmpty()) {
                for (AzureTestAttachment a : attachments) {
                    LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_UPLOAD_ATTACHMENT, a.getFileName()));
                    try {
                        AzureIntegrationRequest.uploadAttachment(credential, azureProjectId, testRun, a);
                        if (a.getAbsolutePath() == null) continue;
                        File attachmentFile = new File(a.getAbsolutePath());
                        if (a.getFileName() == null || !a.getFileName().contains(".zip") || !attachmentFile.exists()) continue;
                        attachmentFile.delete();
                    }
                    catch (AzureApiException azureApiException) {}
                }
            }
            LogUtil.logInfo((String)StringConstants.MSG_INFO_COMPLETING_TEST_RUN);
            AzureTestRun completedTestRun = AzureIntegrationRequest.completeTestRun(credential, azureProjectId, testRun);
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_COMPLETED_TEST_RUN, this.testRunName, completedTestRun.getId(), this.testPlanId, completedTestRun.getUrl()));
        }
    }

    private List<AzureTestAttachment> getTestSuiteCollectionAttachments(AzureSettingStore store, TestSuiteCollectionLogRecord collectionLogRecord, List<TestSuiteLogRecord> testSuiteHasFailedOrErrorTestPoints) {
        File[] fileArray;
        if (!store.isIncludeAttachmentEnabled()) {
            return Collections.emptyList();
        }
        List<Object> testSuiteNeededToAttach = new ArrayList();
        testSuiteNeededToAttach = store.getAttachmentSendingType() == AzureAttachmentSendingType.SEND_IF_FAILS ? testSuiteHasFailedOrErrorTestPoints : collectionLogRecord.getTestSuiteRecords();
        File collectionReportFolder = new File(collectionLogRecord.getReportFolder());
        if (!collectionReportFolder.exists() || !collectionReportFolder.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<AzureTestAttachment> azureTestAttachments = new ArrayList<AzureTestAttachment>();
        List<ReportFormatType> reportFormatTypes = store.getAttachmentFileTypes();
        if (reportFormatTypes == null || reportFormatTypes.isEmpty()) {
            return Collections.emptyList();
        }
        if (!testSuiteNeededToAttach.isEmpty()) {
            for (TestSuiteLogRecord testSuiteLogRecord : testSuiteNeededToAttach) {
                List<AzureTestAttachment> testSuiteAttachments = this.getTestSuiteAttachments(store, testSuiteLogRecord, true);
                if (testSuiteAttachments.isEmpty()) continue;
                int lastSeparatorIndex = FilenameUtils.indexOfLastSeparator((String)testSuiteLogRecord.getLogFolder());
                String zipFileName = lastSeparatorIndex > 0 ? testSuiteLogRecord.getLogFolder().substring(lastSeparatorIndex) : testSuiteLogRecord.getName();
                try {
                    File zipTestSuiteReport = this.createTempFile(zipFileName, ".zip");
                    ArrayList<Path> filePaths = new ArrayList<Path>();
                    for (AzureTestAttachment attachment : testSuiteAttachments) {
                        filePaths.add(Paths.get(attachment.getAbsolutePath(), new String[0]));
                    }
                    ZipUtil.compress(filePaths, (Path)Paths.get(zipTestSuiteReport.getAbsolutePath(), new String[0]));
                    AzureTestAttachment zippedTestSuiteAttachment = new AzureTestAttachment();
                    zippedTestSuiteAttachment.setFileName(zipTestSuiteReport.getName());
                    zippedTestSuiteAttachment.setStream(Base64.encodeFile((File)zipTestSuiteReport));
                    zippedTestSuiteAttachment.setAbsolutePath(zipTestSuiteReport.getAbsolutePath());
                    azureTestAttachments.add(zippedTestSuiteAttachment);
                }
                catch (IOException iOException) {
                    LogUtil.logError((String)MessageFormat.format(StringConstants.MSG_ERROR_CANNOT_ENCODE_FILE, String.valueOf(zipFileName) + ".zip"));
                }
            }
        }
        if ((fileArray = collectionReportFolder.listFiles()) == null) {
            return Collections.emptyList();
        }
        ReportFormatHelper helper = new ReportFormatHelper(reportFormatTypes);
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (helper.match(file)) {
                AzureTestAttachment attachment = new AzureTestAttachment();
                attachment.setFileName(file.getName());
                try {
                    attachment.setStream(Base64.encodeFile((File)file));
                    azureTestAttachments.add(attachment);
                }
                catch (IOException iOException) {
                    LogUtil.logError((String)MessageFormat.format(StringConstants.MSG_ERROR_CANNOT_ENCODE_FILE, file.getName()));
                }
            }
            ++n2;
        }
        return azureTestAttachments;
    }

    private File createTempFile(String prefix, String suffix) throws IOException {
        File parent = new File(System.getProperty("java.io.tmpdir"));
        File temp = new File(parent, String.valueOf(prefix) + suffix);
        if (temp.exists()) {
            temp.delete();
        }
        temp.createNewFile();
        return temp;
    }

    public void uploadTestSuiteResult(TestSuiteLogRecord suiteLogRecord) throws Exception {
        AzureBuildRef build;
        this.resetArgumentsForKS();
        String rawBuildDefId = suiteLogRecord.getAzurebBuildDefinitionId();
        String rawReleaseDefId = suiteLogRecord.getAzurebReleaseDefinitionId();
        if (!this.checkAndSetConsoleArgs(this.rawADOPlanId, this.testRunName, rawBuildDefId, rawReleaseDefId)) {
            return;
        }
        int buildDefId = -1;
        if (StringUtils.isNotEmpty((CharSequence)rawBuildDefId)) {
            try {
                buildDefId = Integer.parseInt(rawBuildDefId);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int releaseDefId = -1;
        if (StringUtils.isNotEmpty((CharSequence)rawReleaseDefId)) {
            try {
                releaseDefId = Integer.parseInt(rawReleaseDefId);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        AzureCredential credential = settingStore.getCredential();
        AzureProjectRef azureProject = settingStore.getIntegratedProject();
        if (azureProject == null) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_NO_PROJECT_SELECTED);
            return;
        }
        if (this.testPlanId < 0) {
            AzureTestPlanRef testPlanRef = settingStore.getAzureTestPlan();
            if (testPlanRef == null) {
                LogUtil.logInfo((String)StringConstants.MSG_INFO_NO_TEST_PLAN_SELECTED);
                return;
            }
            this.testPlanId = testPlanRef.getId();
        }
        if (!settingStore.isAutoSubmitTestRunEnabled()) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_SUBMIT_TEST_RUN_IS_DISABLED);
            return;
        }
        TestPointMappers testPointMappers = this.getAzureTestPointsWithKatalonTestCases(settingStore.getTestConfigurationMappings(), project, suiteLogRecord);
        if (buildDefId < 0) {
            buildDefId = settingStore.getBuildDefinitionId();
        }
        int buildNumberId = -1;
        if (buildDefId >= 0 && (build = AzureIntegrationRequest.getLatestBuildNumber(credential, azureProject.getId(), buildDefId)) != null) {
            buildNumberId = build.getId();
        }
        if (releaseDefId < 0) {
            releaseDefId = settingStore.getReleaseDefinitionId();
        }
        AzureReleaseRef release = null;
        try {
            if (releaseDefId >= 0) {
                LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_GETTING_LATEST_RELEASE, releaseDefId));
                release = AzureIntegrationRequest.getLatestReleaseWithInProgressEnvironment(credential, azureProject.getId(), releaseDefId);
                if (release == null) {
                    LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_LATEST_RELEASE_NOT_IN_PROGRESS, releaseDefId));
                }
            }
        }
        catch (AzureApiException exception) {
            LogUtil.logError((String)exception.getMessage());
        }
        if (StringUtils.isEmpty((CharSequence)this.testRunName)) {
            this.testRunName = settingStore.getTestRunName();
        }
        if (StringUtils.isEmpty((CharSequence)this.testRunName)) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_TEST_RUN_NAME_IS_EMPTY);
            return;
        }
        if (testPointMappers != null && !testPointMappers.isEmpty()) {
            String azureProjectId = azureProject.getId();
            int[] testPointIds = testPointMappers.getTestPointIds();
            LogUtil.logInfo((String)StringConstants.MSG_INFO_CREATING_TEST_RUN);
            AzureTestRun testRun = AzureIntegrationRequest.createTestRun(credential, azureProjectId, buildNumberId, this.testRunName, this.testPlanId, testPointIds, release);
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_CREATED_TEST_RUN, testRun.getId(), testRun.getUrl()));
            this.trackingReport.setTestRunCreated(true);
            LogUtil.logInfo((String)StringConstants.MSG_INFO_RETRIEVING_TEST_RESULTS);
            AzureTestCaseResultBody getTestCaseResultsBody = AzureIntegrationRequest.getTestCaseResults(credential, azureProjectId, testRun);
            this.trackingReport.setAdoCreatedTestResultCount(getTestCaseResultsBody.getCount());
            AzureTestCaseResult[] updatedResults = this.updateStatusForTestCaseResult(suiteLogRecord.getHostName(), testPointMappers, settingStore.getExecutionStatusMappings(), getTestCaseResultsBody);
            LogUtil.logInfo((String)StringConstants.MSG_INFO_UPDATE_TEST_RESULTS);
            AzureIntegrationRequest.updateTestCaseResults(credential, azureProjectId, testRun, updatedResults);
            boolean doesTestSuiteHasFailedOrErrorTestPoints = this.doesTestSuiteHasFailedOrErrorTestPoints(suiteLogRecord, testPointMappers);
            List<AzureTestAttachment> attachments = this.getTestSuiteAttachments(settingStore, suiteLogRecord, doesTestSuiteHasFailedOrErrorTestPoints);
            if (attachments != null && !attachments.isEmpty()) {
                for (AzureTestAttachment a : attachments) {
                    LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_UPLOAD_ATTACHMENT, a.getFileName()));
                    try {
                        AzureIntegrationRequest.uploadAttachment(credential, azureProjectId, testRun, a);
                    }
                    catch (AzureApiException azureApiException) {}
                }
            }
            LogUtil.logInfo((String)StringConstants.MSG_INFO_COMPLETING_TEST_RUN);
            AzureTestRun completedTestRun = AzureIntegrationRequest.completeTestRun(credential, azureProjectId, testRun);
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_COMPLETED_TEST_RUN, this.testRunName, completedTestRun.getId(), this.testPlanId, completedTestRun.getUrl()));
        }
    }

    private TestPointMappers getAzureTestPointsWithKatalonTestCases(List<TestConfigurationMapping> storedTestConfigurationMappingList, ProjectEntity project, TestSuiteLogRecord suiteLogRecord) throws Exception {
        if (suiteLogRecord == null) {
            return null;
        }
        TestPointMappers mappers = new TestPointMappers();
        String testSuiteId = suiteLogRecord.getId();
        TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, project);
        List<Integer> configurationIdList = ExecutionMappingUtil.getSuitableConfigurations(suiteLogRecord, storedTestConfigurationMappingList);
        if (configurationIdList.isEmpty()) {
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_NO_SUITABLE_TEST_CONFIGURATION, testSuite.getName()));
            return null;
        }
        ILogRecord[] iLogRecordArray = suiteLogRecord.filterFinalTestCasesResult();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord logRecord = iLogRecordArray[n2];
            if (logRecord instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)logRecord;
                List<Object> testCasePoints = new ArrayList();
                try {
                    testCasePoints = this.getTestPoints(testSuite, testCaseLogRecord, suiteLogRecord, configurationIdList);
                }
                catch (Exception exception) {}
                if (!testCasePoints.isEmpty()) {
                    for (AzureTestPoint point : testCasePoints) {
                        mappers.add(point, testCaseLogRecord);
                    }
                }
            }
            ++n2;
        }
        return mappers;
    }

    private String getTestPointsIdString(List<AzureTestPoint> testPoints) {
        return "<" + StringUtils.join((int[])this.getTestPointsIds(testPoints), (char)',') + ">";
    }

    private int[] getTestPointsIds(List<AzureTestPoint> testPoints) {
        int[] testPointsIds = new int[testPoints.size()];
        int i = 0;
        while (i < testPoints.size()) {
            testPointsIds[i] = testPoints.get(i).getId();
            ++i;
        }
        return testPointsIds;
    }

    private List<AzureTestAttachment> getTestSuiteAttachments(AzureSettingStore store, TestSuiteLogRecord suiteLogRecord, boolean hasFailedOrErrorTestPoints) {
        if (!store.isIncludeAttachmentEnabled()) {
            return Collections.emptyList();
        }
        if (store.getAttachmentSendingType() == AzureAttachmentSendingType.SEND_IF_FAILS && !hasFailedOrErrorTestPoints) {
            return Collections.emptyList();
        }
        List<ReportFormatType> reportFormatTypes = store.getAttachmentFileTypes();
        if (reportFormatTypes == null || reportFormatTypes.isEmpty()) {
            return Collections.emptyList();
        }
        File logFolder = new File(suiteLogRecord.getLogFolder());
        if (!logFolder.exists() || !logFolder.isDirectory()) {
            return Collections.emptyList();
        }
        File[] childFiles = logFolder.listFiles();
        if (childFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<AzureTestAttachment> azureTestAttachments = new ArrayList<AzureTestAttachment>();
        ReportFormatHelper helper = new ReportFormatHelper(reportFormatTypes);
        File[] fileArray = childFiles;
        int n = childFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (helper.match(file)) {
                AzureTestAttachment attachment = new AzureTestAttachment();
                attachment.setFileName(file.getName());
                attachment.setAbsolutePath(file.getAbsolutePath());
                try {
                    attachment.setStream(Base64.encodeFile((File)file));
                    azureTestAttachments.add(attachment);
                }
                catch (IOException iOException) {
                    LogUtil.logError((String)MessageFormat.format(StringConstants.MSG_ERROR_CANNOT_ENCODE_FILE, file.getName()));
                }
            }
            ++n2;
        }
        return azureTestAttachments;
    }

    private AzureTestCaseResult[] updateStatusForTestCaseResult(String hostName, TestPointMappers testPointMappers, List<ExecutionStatusMapping> statusMappings, AzureTestCaseResultBody resultBody) {
        TestPointMappers mappers = testPointMappers.copy();
        ArrayList<AzureTestCaseResult> updatedResults = new ArrayList<AzureTestCaseResult>();
        ExecutionStatusHelper helper = new ExecutionStatusHelper(statusMappings);
        int i = 0;
        while (i < resultBody.getCount()) {
            AzureTestCaseResult result = resultBody.getValue()[i];
            TestPointMapper mapper = mappers.getMapper(result.getTestPoint().getId());
            TestCaseLogRecord testCaseLogRecord = mapper.getTestCaseLogRecord();
            result.setState("Completed");
            result.setComputerName(hostName);
            if (testCaseLogRecord != null) {
                long duration;
                TestStatus testStatus = testCaseLogRecord.getStatus();
                if (testStatus != null) {
                    result.setOutcome(helper.getAzureStatus(testCaseLogRecord));
                    if (testStatus.getStatusValue().isError()) {
                        result.setErrorMessage(testCaseLogRecord.getMessage());
                    }
                }
                if ((duration = testCaseLogRecord.getEndTime() - testCaseLogRecord.getStartTime()) > 0L) {
                    result.setDurationInMs(duration);
                }
                mappers.remove(mapper);
                updatedResults.add(result);
            }
            ++i;
        }
        return updatedResults.toArray(new AzureTestCaseResult[updatedResults.size()]);
    }

    private List<AzureTestPoint> getTestPoints(TestSuiteEntity testSuiteEntity, TestCaseLogRecord testLogEntity, TestSuiteLogRecord suiteLog, List<Integer> configurationIdList) throws Exception {
        TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId(testLogEntity.getId());
        IntegratedEntity testCaseIntegratedEntity = AzureIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCaseEntity);
        if (testCaseIntegratedEntity == null) {
            return new ArrayList<AzureTestPoint>();
        }
        String rawTestCaseIds = (String)testCaseIntegratedEntity.getProperties().get("azure.testcase.ids");
        if (StringUtils.isNotBlank((CharSequence)rawTestCaseIds)) {
            this.trackingReport.addIntegratedTestCase(testLogEntity);
        }
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        AzureCredential credential = settingStore.getCredential();
        AzureProjectRef azureProject = settingStore.getIntegratedProject();
        if (this.testPlanId < 0) {
            this.testPlanId = settingStore.getAzureTestPlan().getId();
        }
        boolean isSubmitMultipleTestPointsEnabled = settingStore.isSubmitMultipleTestPointsEnabled();
        ArrayList<AzureTestPoint> testPoints = new ArrayList<AzureTestPoint>();
        for (String id : EntityTagUtil.parse((String)rawTestCaseIds)) {
            int testCaseId;
            List<AzureTestSuiteRef> testSuiteOfTestCase;
            if (!AzureIntegrationUtil.isPositiveInteger(id) || (testSuiteOfTestCase = AzureIntegrationUtil.getTestSuiteRefs(credential, this.testPlanId, testCaseId = Integer.parseInt(id))) == null || testSuiteOfTestCase.isEmpty()) continue;
            List<AzureTestPoint> testPointsOfTestCase = new ArrayList<AzureTestPoint>();
            for (AzureTestSuiteRef testSuite : testSuiteOfTestCase) {
                AzureTestPointList testPointsByTestSuite = AzureIntegrationRequest.getTestPointListByTestCase(credential, azureProject.getId(), this.testPlanId, testSuite.getId(), testCaseId);
                if (testPointsByTestSuite == null || testPointsByTestSuite.getCount() <= 0) continue;
                testPointsOfTestCase.addAll(Arrays.asList(testPointsByTestSuite.getValue()));
            }
            if (testPointsOfTestCase.isEmpty()) continue;
            if (testPointsOfTestCase.size() > 1 && !isSubmitMultipleTestPointsEnabled) {
                LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_DUPLICATE_TEST_POINTS, testCaseId, this.getTestPointsIdString(testPointsOfTestCase)));
                continue;
            }
            testPointsOfTestCase = this.filterTestPointsByConfigurationIdList(testPointsOfTestCase, configurationIdList);
            testPoints.addAll(testPointsOfTestCase);
        }
        return testPoints;
    }

    private List<AzureTestPoint> filterTestPointsByConfigurationIdList(List<AzureTestPoint> testPointList, List<Integer> configurationIdList) {
        return testPointList.stream().filter(testPoint -> configurationIdList.contains(testPoint.getConfiguration().getId())).collect(Collectors.toList());
    }

    private void resetArgumentsForKS() {
        if (ProcessUtil.isKRE()) {
            return;
        }
        this.testPlanId = -1;
        this.testRunName = "";
    }

    private boolean doesTestSuiteHasFailedOrErrorTestPoints(TestSuiteLogRecord suiteLogRecord, TestPointMappers testPointMappers) throws Exception {
        if (suiteLogRecord == null) {
            return false;
        }
        ILogRecord[] iLogRecordArray = suiteLogRecord.filterFinalTestCasesResult();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord logRecord = iLogRecordArray[n2];
            if (logRecord instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)logRecord;
                boolean isTestCaseFailed = testCaseLogRecord.getStatus().getStatusValue().equals((Object)TestStatus.TestStatusValue.FAILED);
                boolean isTestCaseError = testCaseLogRecord.getStatus().getStatusValue().equals((Object)TestStatus.TestStatusValue.ERROR);
                if (isTestCaseFailed || isTestCaseError) {
                    for (TestPointMapper mapper : testPointMappers.get()) {
                        boolean areTestCasesRunFromTestSuite;
                        TestCaseLogRecord testCaseLog = mapper.getTestCaseLogRecord();
                        boolean foundTestCaseLog = testCaseLog.getId().equals(testCaseLogRecord.getId());
                        boolean bl = areTestCasesRunFromTestSuite = testCaseLog.getParentLogRecord() instanceof TestSuiteLogRecord && testCaseLogRecord.getParentLogRecord() instanceof TestSuiteLogRecord;
                        if (!foundTestCaseLog || !areTestCasesRunFromTestSuite) continue;
                        TestSuiteLogRecord currentTestSuite = (TestSuiteLogRecord)testCaseLogRecord.getParentLogRecord();
                        TestSuiteLogRecord testSuiteOfCurrentTestPoint = (TestSuiteLogRecord)testCaseLog.getParentLogRecord();
                        if (!currentTestSuite.getLogFolder().equals(testSuiteOfCurrentTestPoint.getLogFolder())) continue;
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public boolean isNeededTrackingData() {
        return true;
    }

    public Map<String, Object> getTrackingProperties() {
        if (this.trackingReport == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        boolean isIntegrationEnabled = this.trackingReport.isIntegrationEnabled();
        properties.put("ado_integration_enabled", isIntegrationEnabled);
        if (isIntegrationEnabled) {
            properties.put("ado_testrun_created", this.trackingReport.isTestRunCreated());
            properties.put("ado_testcases_integrated_count", this.trackingReport.getAdoIntegratedTestCaseCount());
            properties.put("ado_testresults_created_count", this.trackingReport.getAdoCreatedTestResultCount());
        }
        return properties;
    }
}

