/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.integration.azure.constant.AzureMessagesConstants;
import com.kms.katalon.integration.azure.constant.StringConstants;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureAPIErrorMessage;
import com.kms.katalon.integration.azure.model.AzureAttachmentResponseBody;
import com.kms.katalon.integration.azure.model.AzureBuildRef;
import com.kms.katalon.integration.azure.model.AzureBuildsRef;
import com.kms.katalon.integration.azure.model.AzureCompleteTestRunBody;
import com.kms.katalon.integration.azure.model.AzureCreateTestRunBody;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureProjectsRef;
import com.kms.katalon.integration.azure.model.AzureReleaseDefinitionRef;
import com.kms.katalon.integration.azure.model.AzureReleaseEnvironmentRef;
import com.kms.katalon.integration.azure.model.AzureReleaseRef;
import com.kms.katalon.integration.azure.model.AzureTestAttachment;
import com.kms.katalon.integration.azure.model.AzureTestCaseResult;
import com.kms.katalon.integration.azure.model.AzureTestCaseResultBody;
import com.kms.katalon.integration.azure.model.AzureTestConfigurationsRef;
import com.kms.katalon.integration.azure.model.AzureTestPlansRef;
import com.kms.katalon.integration.azure.model.AzureTestPointList;
import com.kms.katalon.integration.azure.model.AzureTestRun;
import com.kms.katalon.integration.azure.model.AzureTestSuitesRef;
import com.kms.katalon.integration.azure.model.ShallowReference;
import com.kms.katalon.integration.azure.provider.AzureAPIProvider;
import com.kms.katalon.logging.LogUtil;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Base64;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class AzureIntegrationRequest {
    protected static String executeRequest(HttpUriRequest httpRequest) throws Exception {
        HttpClientProxyBuilder httpClientProxyBuilder = HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getAuthProxyInformation(), (String)httpRequest.getURI().toURL().toString());
        CloseableHttpClient httpClient = httpClientProxyBuilder.getClientBuilder().build();
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        HttpEntity entity = httpResponse.getEntity();
        String responseString = "";
        if (entity != null) {
            responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
            return responseString;
        }
        Gson gson = new GsonBuilder().create();
        try {
            AzureAPIErrorMessage exception = (AzureAPIErrorMessage)gson.fromJson(responseString, AzureAPIErrorMessage.class);
            if (exception != null && StringUtils.isNotEmpty((CharSequence)exception.getMessage())) {
                responseString = exception.getMessage();
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            responseString = "";
        }
        if (StringUtils.isEmpty((CharSequence)responseString)) {
            switch (statusCode) {
                case 401: {
                    responseString = AzureMessagesConstants.MSG_API_STATUS_UNAUTHORIZED;
                    break;
                }
                case 404: {
                    responseString = AzureMessagesConstants.MSG_API_STATUS_NOT_FOUND;
                    break;
                }
                case 203: {
                    responseString = AzureMessagesConstants.MSG_API_STATUS_NON_AUTHORITATIVE_INFO;
                    break;
                }
                case 403: {
                    responseString = AzureMessagesConstants.MSG_API_STATUS_FORBIDDEN;
                }
            }
        }
        LogUtil.logError((String)MessageFormat.format(StringConstants.MSG_AZURE_EXCEPTION, httpRequest.getURI(), statusCode, responseString));
        throw new AzureApiException(responseString);
    }

    protected static <T> T executeRequest(HttpUriRequest httpRequest, AzureCredential credential, Class<T> returnType) throws Exception {
        String clientCredentials = ":" + credential.getToken();
        httpRequest.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(clientCredentials.getBytes()));
        String responseString = AzureIntegrationRequest.executeRequest(httpRequest);
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(responseString, returnType);
    }

    protected static <T> T executeRequest(HttpUriRequest httpRequest, Class<T> returnType) throws Exception {
        String responseString = AzureIntegrationRequest.executeRequest(httpRequest);
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(responseString, returnType);
    }

    public static AzureProjectsRef getProjects(AzureCredential credential) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getProjectsAPIUrl(credential));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AzureProjectsRef unsortedResult = AzureIntegrationRequest.executeRequest((HttpUriRequest)httpGet, credential, AzureProjectsRef.class);
            return unsortedResult.sort();
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestSuitesRef getTestSuitesByTestCaseId(AzureCredential credential, int testCaseId) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getTestSuitesByTestCaseIdAPIUrl(credential, testCaseId));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return AzureIntegrationRequest.executeRequest((HttpUriRequest)httpGet, credential, AzureTestSuitesRef.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestConfigurationsRef getAllTestConfigurations(AzureCredential credential, String projectId) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getAllTestConfigurationsAPIUrl(credential, projectId, 0));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return AzureIntegrationRequest.executeRequest((HttpUriRequest)httpGet, credential, AzureTestConfigurationsRef.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestPointList getTestPointListByTestCase(AzureCredential credential, String projectId, int testPlanId, int testSuiteId, int testCaseId) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getPointsAPIUrl(credential, projectId, testPlanId, testSuiteId, testCaseId));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return AzureIntegrationRequest.executeRequest((HttpUriRequest)httpGet, credential, AzureTestPointList.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestRun createTestRun(AzureCredential credential, String projectId, int buildNumber, String testRunName, int planId, int[] pointIds, AzureReleaseRef release) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getCreateTestRunAPIUrl(credential, projectId));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpPost httpPost = new HttpPost(uriBuilder.build().toASCIIString());
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            AzureCreateTestRunBody testRunBody = new AzureCreateTestRunBody();
            testRunBody.setName(testRunName);
            if (buildNumber >= 0) {
                testRunBody.setBuild(new ShallowReference(buildNumber));
            }
            testRunBody.setPlan(new ShallowReference(planId));
            testRunBody.setPointIds(pointIds);
            if (release != null) {
                testRunBody.setReleaseUri(release.getId());
                testRunBody.setReleaseEnvironmentUri(release.getInProgressEnvironmentId());
            }
            StringEntity entity = new StringEntity(JsonUtil.toJson((Object)testRunBody), Charsets.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
            return AzureIntegrationRequest.executeRequest((HttpUriRequest)httpPost, credential, AzureTestRun.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestRun completeTestRun(AzureCredential credential, String projectId, AzureTestRun testRun) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getUpdateTestRunAPIUrl(credential, projectId, testRun.getId()));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpPatch httpPatch = new HttpPatch(uriBuilder.build().toASCIIString());
            httpPatch.setHeader("Accept", "application/json");
            httpPatch.setHeader("Content-type", "application/json");
            AzureCompleteTestRunBody completeTestRunBody = new AzureCompleteTestRunBody();
            completeTestRunBody.setState("Completed");
            StringEntity entity = new StringEntity(JsonUtil.toJson((Object)completeTestRunBody), Charsets.UTF_8);
            httpPatch.setEntity((HttpEntity)entity);
            return AzureIntegrationRequest.executeRequest((HttpUriRequest)httpPatch, credential, AzureTestRun.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestCaseResultBody getTestCaseResults(AzureCredential credential, String projectId, AzureTestRun testRun) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getUpdateTestCaseResultsAPIUrl(credential, projectId, testRun.getId()));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpPatch = new HttpGet(uriBuilder.build().toASCIIString());
            return AzureIntegrationRequest.executeRequest((HttpUriRequest)httpPatch, credential, AzureTestCaseResultBody.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestCaseResultBody updateTestCaseResults(AzureCredential credential, String projectId, AzureTestRun testRun, AzureTestCaseResult[] requestBody) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getUpdateTestCaseResultsAPIUrl(credential, projectId, testRun.getId()));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpPatch httpPatch = new HttpPatch(uriBuilder.build().toASCIIString());
            httpPatch.setHeader("Accept", "application/json");
            httpPatch.setHeader("Content-type", "application/json");
            StringEntity entity = new StringEntity(JsonUtil.toJson((Object)requestBody), Charsets.UTF_8);
            httpPatch.setEntity((HttpEntity)entity);
            return AzureIntegrationRequest.executeRequest((HttpUriRequest)httpPatch, credential, AzureTestCaseResultBody.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureAttachmentResponseBody uploadAttachment(AzureCredential credential, String projectId, AzureTestRun testRun, AzureTestAttachment requestBody) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getUploadAttachmentAPIUrl(credential, projectId, testRun.getId()));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpPost httpPatch = new HttpPost(uriBuilder.build().toASCIIString());
            httpPatch.setHeader("Accept", "application/json");
            httpPatch.setHeader("Content-type", "application/json");
            StringEntity entity = new StringEntity(JsonUtil.toJson((Object)requestBody), Charsets.UTF_8);
            httpPatch.setEntity((HttpEntity)entity);
            return AzureIntegrationRequest.executeRequest((HttpUriRequest)httpPatch, credential, AzureAttachmentResponseBody.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureTestPlansRef getAllTestPlans(AzureCredential credential, String projectId) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getAllTestPlansAPIUrl(credential, projectId));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AzureTestPlansRef unsortedTestPlans = AzureIntegrationRequest.executeRequest((HttpUriRequest)httpGet, credential, AzureTestPlansRef.class);
            return unsortedTestPlans.sort();
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static ShallowReference getBuildDefinition(AzureCredential credential, String projectId, int definitionId) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getBuildDefinitionAPIUrl(credential, projectId, definitionId));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return AzureIntegrationRequest.executeRequest((HttpUriRequest)httpGet, credential, ShallowReference.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureBuildRef getLatestBuildNumber(AzureCredential credential, String projectId, int definitionId) throws AzureApiException {
        AzureBuildsRef buildList;
        block3: {
            try {
                URI uri = new URI(AzureAPIProvider.getLatestBuildByDefinitionIdAPIUrl(credential, projectId, definitionId));
                URIBuilder uriBuilder = new URIBuilder(uri);
                HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
                buildList = AzureIntegrationRequest.executeRequest((HttpUriRequest)httpGet, credential, AzureBuildsRef.class);
                if (buildList != null && buildList.getCount() > 0) break block3;
                return null;
            }
            catch (Exception exception) {
                throw AzureApiException.wrap(exception);
            }
        }
        return buildList.sort().getValue()[0];
    }

    public static AzureReleaseDefinitionRef getReleaseDefinition(AzureCredential credential, String projectId, int definitionId) throws AzureApiException {
        try {
            URI uri = new URI(AzureAPIProvider.getReleaseDefinitionAPIUrl(credential, projectId, definitionId));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return AzureIntegrationRequest.executeRequest((HttpUriRequest)httpGet, credential, AzureReleaseDefinitionRef.class);
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }

    public static AzureReleaseRef getLatestReleaseWithInProgressEnvironment(AzureCredential credential, String projectId, int definitionId) throws AzureApiException {
        AzureReleaseRef release;
        block5: {
            AzureReleaseDefinitionRef releaseDefinition = AzureIntegrationRequest.getReleaseDefinition(credential, projectId, definitionId);
            AzureReleaseRef latestRelease = releaseDefinition.getLastRelease();
            URI uri = new URI(AzureAPIProvider.getReleaseAPIUrl(credential, projectId, latestRelease.getId()));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            release = AzureIntegrationRequest.executeRequest((HttpUriRequest)httpGet, credential, AzureReleaseRef.class);
            if (release != null) break block5;
            return null;
        }
        try {
            AzureReleaseEnvironmentRef[] environments;
            AzureReleaseEnvironmentRef[] azureReleaseEnvironmentRefArray = environments = release.getEnvironments();
            int n = environments.length;
            int n2 = 0;
            while (n2 < n) {
                AzureReleaseEnvironmentRef env = azureReleaseEnvironmentRefArray[n2];
                if (env.getStatus().equals("inProgress")) {
                    release.setInProgressEnvironmentId(env.getId());
                    return release;
                }
                ++n2;
            }
            return null;
        }
        catch (Exception exception) {
            throw AzureApiException.wrap(exception);
        }
    }
}

