/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.attacher;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.decompiler.source.attach.attacher.SourceAttacher;
import org.sf.feeling.decompiler.source.attach.utils.MethodUtils;
import org.sf.feeling.decompiler.util.Logger;

public class InternalBasedSourceAttacherImpl35
implements SourceAttacher {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean attachSource(IPackageFragmentRoot fRoot, File newSourcePath) throws CoreException {
        try {
            IPath fContainerPath = null;
            IClasspathEntry fEntry = null;
            if (fRoot == null || fRoot.getKind() != 2) {
                Logger.debug((String)"error(!=K_BINARY)", null);
                return false;
            }
            IPath containerPath = null;
            IJavaProject jproject = fRoot.getJavaProject();
            IClasspathEntry entry = fRoot.getRawClasspathEntry();
            if (entry == null) {
                entry = JavaCore.newLibraryEntry((IPath)fRoot.getPath(), null, null);
            } else if (entry.getEntryKind() == 5) {
                containerPath = entry.getPath();
                ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
                if (initializer == null || container == null) {
                    Logger.debug((String)"error(initializer == null || container == null)", null);
                    return false;
                }
                IStatus status = initializer.getSourceAttachmentStatus(containerPath, jproject);
                if (status.getCode() == 1) {
                    Logger.debug((String)"error(ATTRIBUTE_NOT_SUPPORTED)", null);
                    return false;
                }
                if (status.getCode() == 2) {
                    Logger.debug((String)"error(ATTRIBUTE_READ_ONLY)", null);
                    return false;
                }
                entry = JavaModelUtil.findEntryInContainer((IClasspathContainer)container, (IPath)fRoot.getPath());
                Assert.isNotNull((Object)entry);
            }
            fContainerPath = containerPath;
            fEntry = entry;
            CPListElement elem = CPListElement.createFromExisting((IClasspathEntry)fEntry, null);
            IPath srcAttPath = Path.fromOSString((String)newSourcePath.getAbsolutePath()).makeAbsolute();
            if (fEntry.getEntryKind() == 4) {
                File sourceAttacherDir = newSourcePath.getParentFile();
                JavaCore.setClasspathVariable((String)"SOURCE_ATTACHER", (IPath)new Path(sourceAttacherDir.getAbsolutePath()), null);
                srcAttPath = new Path("SOURCE_ATTACHER/" + newSourcePath.getName());
            }
            elem.setAttribute("sourcepath", (Object)srcAttPath);
            IClasspathEntry entry2 = elem.getClasspathEntry();
            if (entry2.equals(fEntry)) {
                Logger.debug((String)"NO CHANGE", null);
                return true;
            }
            IClasspathEntry newEntry = entry2;
            String[] changedAttributes = new String[]{"sourcepath"};
            try {
                Object[] objectArray = new Object[6];
                objectArray[1] = newEntry;
                objectArray[2] = changedAttributes;
                objectArray[3] = jproject;
                objectArray[4] = fContainerPath;
                objectArray[5] = new NullProgressMonitor();
                MethodUtils.invokeExactStaticMethod(BuildPathSupport.class, "modifyClasspathEntry", objectArray, new Class[]{Shell.class, IClasspathEntry.class, String[].class, IJavaProject.class, IPath.class, IProgressMonitor.class});
                return true;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
        }
        catch (InvocationTargetException e3) {
            Logger.debug((String)"error", (Throwable)e3);
            return false;
        }
        catch (CoreException e4) {
            Logger.debug((String)"error", (Throwable)e4);
            return false;
        }
    }
}

