/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.attacher;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.sf.feeling.decompiler.source.attach.attacher.SourceAttacher;
import org.sf.feeling.decompiler.util.Logger;

public class InternalBasedSourceAttacherImpl36
implements SourceAttacher {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean attachSource(IPackageFragmentRoot fRoot, File newSourcePath) throws CoreException {
        try {
            IPath fContainerPath = null;
            IClasspathEntry fEntry = null;
            if (fRoot == null || fRoot.getKind() != 2) {
                Logger.debug((String)"error(!=K_BINARY)", null);
                return false;
            }
            IPath containerPath = null;
            IJavaProject jproject = fRoot.getJavaProject();
            IClasspathEntry entry0 = JavaModelUtil.getClasspathEntry((IPackageFragmentRoot)fRoot);
            if (entry0.getEntryKind() == 5) {
                containerPath = entry0.getPath();
                ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
                if (initializer == null || container == null) {
                    Logger.debug((String)"error(initializer == null || container == null)", null);
                    return false;
                }
                IStatus status = initializer.getSourceAttachmentStatus(containerPath, jproject);
                if (status.getCode() == 1) {
                    Logger.debug((String)"error(ATTRIBUTE_NOT_SUPPORTED)", null);
                    return false;
                }
                if (status.getCode() == 2) {
                    Logger.debug((String)"error(ATTRIBUTE_READ_ONLY)", null);
                    return false;
                }
                entry0 = JavaModelUtil.findEntryInContainer((IClasspathContainer)container, (IPath)fRoot.getPath());
            }
            fContainerPath = containerPath;
            fEntry = entry0;
            CPListElement elem = CPListElement.createFromExisting((IClasspathEntry)fEntry, null);
            IPath srcAttPath = Path.fromOSString((String)newSourcePath.getAbsolutePath()).makeAbsolute();
            if (fEntry.getEntryKind() == 4) {
                File sourceAttacherDir = newSourcePath.getParentFile();
                JavaCore.setClasspathVariable((String)"SOURCE_ATTACHER", (IPath)new Path(sourceAttacherDir.getAbsolutePath()), null);
                srcAttPath = new Path("SOURCE_ATTACHER/" + newSourcePath.getName());
            }
            elem.setAttribute("sourcepath", (Object)srcAttPath);
            IClasspathEntry entry2 = elem.getClasspathEntry();
            if (entry2.equals(fEntry)) {
                Logger.debug((String)"NO CHANGE", null);
                return true;
            }
            IClasspathEntry newEntry = entry2;
            boolean isReferencedEntry = fEntry.getReferencingEntry() != null;
            String[] changedAttributes = new String[]{"sourcepath"};
            int count = 0;
            while (true) {
                if (count >= 10) {
                    return true;
                }
                BuildPathSupport.modifyClasspathEntry(null, (IClasspathEntry)newEntry, (String[])changedAttributes, (IJavaProject)jproject, (IPath)fContainerPath, (boolean)isReferencedEntry, (IProgressMonitor)new NullProgressMonitor());
                if (fRoot.getSourceAttachmentPath() != null && fRoot.getSourceAttachmentPath().toFile().exists()) {
                    return true;
                }
                ++count;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (CoreException e) {
            Logger.debug((String)"error", (Throwable)e);
            return false;
        }
    }
}

