/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.sf.feeling.decompiler.source.attach.finder.EclipsePluginSourceByUrlPatternFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;

public class EclipsePluginSourceByFTPSearchv3Finder
extends EclipsePluginSourceByUrlPatternFinder {
    public EclipsePluginSourceByFTPSearchv3Finder() {
        super("http://www.search-ftp.com/lsftp.ashx?s={0}");
    }

    @Override
    protected String getHtmlFromUrl(URL baseUrl, String fileName) throws Exception {
        String html = this.getString(baseUrl);
        Pattern pattern = Pattern.compile("(?i)" + Pattern.compile("<a") + ".+" + Pattern.compile(fileName) + ".+" + Pattern.compile("</a>"));
        Matcher matcher = pattern.matcher(html);
        if (matcher.find()) {
            String content = matcher.group();
            content = "http://www.search-ftp.com" + content.substring(content.indexOf("\"") + 1, content.lastIndexOf("\""));
            html = this.getString(new URL(content));
        }
        return html;
    }

    @Override
    protected void addLink(URL baseUrl, String fileName, HTMLDocument doc, HTMLDocument.Iterator aElement, List<String> links) throws Exception {
        SimpleAttributeSet s = (SimpleAttributeSet)aElement.getAttributes();
        String href = (String)s.getAttribute(HTML.Attribute.HREF);
        if (href != null && href.contains("/lsftp.ashx?is=")) {
            String text = this.getText(doc, aElement);
            String absHref = new URL(new URL("ftp://" + text + "/"), fileName).toString();
            links.add(absHref);
        }
    }

    public static void main(String[] args) {
        EclipsePluginSourceByFTPSearchv3Finder finder = new EclipsePluginSourceByFTPSearchv3Finder();
        ArrayList<SourceFileResult> results = new ArrayList<SourceFileResult>();
        finder.find("C:\\develop\\eclipse\\plugins\\org.eclipse.jdt.core_3.10.0.v20140902-0626.jar", results);
        System.out.println(((SourceFileResult)results.get(0)).getSource());
    }
}

