/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.global;

import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement(name="GlobalVariableEntities")
public class ExecutionProfileEntity
extends FileEntity {
    public static final String DF_PROFILE_NAME = "default";
    private static final long serialVersionUID = 1L;
    private List<GlobalVariableEntity> globalVariableEntities;
    private boolean defaultProfile = false;

    @Override
    public String getName() {
        String name = super.getName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return DF_PROFILE_NAME;
        }
        return name;
    }

    @Override
    public String getFileExtension() {
        return ExecutionProfileEntity.getGlobalVariableFileExtension();
    }

    @XmlElement(name="GlobalVariableEntity")
    public List<GlobalVariableEntity> getGlobalVariableEntities() {
        if (this.globalVariableEntities == null) {
            this.globalVariableEntities = new ArrayList<GlobalVariableEntity>();
        } else {
            ArrayList<GlobalVariableEntity> lstGlobalVariables = new ArrayList<GlobalVariableEntity>();
            for (GlobalVariableEntity globalVariable : this.globalVariableEntities) {
                GlobalVariableEntity newGlobalVariable = new GlobalVariableEntity();
                newGlobalVariable.setName(globalVariable.getName());
                newGlobalVariable.setInitValue(globalVariable.getInitValue());
                newGlobalVariable.setDescription(globalVariable.getDescription());
                lstGlobalVariables.add(newGlobalVariable);
            }
            this.globalVariableEntities = lstGlobalVariables;
        }
        return this.globalVariableEntities;
    }

    public void setGlobalVariableEntities(List<GlobalVariableEntity> globalVariableEntities) {
        this.globalVariableEntities = globalVariableEntities;
    }

    public static String getGlobalVariableFileExtension() {
        return ".glbl";
    }

    public boolean isDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public boolean compareByVariables(ExecutionProfileEntity entity) {
        List<GlobalVariableEntity> entityVariables = entity.getGlobalVariableEntities();
        List<GlobalVariableEntity> variables = this.getGlobalVariableEntities();
        if (entityVariables.size() != variables.size()) {
            return false;
        }
        int i = 0;
        while (i < entityVariables.size()) {
            if (!entityVariables.get(i).equals(variables.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

