/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.repository;

import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;

public class WindowsElementEntity
extends FileEntity {
    private static final long serialVersionUID = -1579378597063358564L;
    public static final String FILE_EXTENSION = ".wrs";
    private List<WebElementPropertyEntity> properties = new ArrayList<WebElementPropertyEntity>();
    private String locator;
    private LocatorStrategy locatorStrategy = LocatorStrategy.XPATH;

    @Override
    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public List<WebElementPropertyEntity> getProperties() {
        return this.properties;
    }

    public void setProperties(List<WebElementPropertyEntity> properties) {
        this.properties = properties;
    }

    public LocatorStrategy getLocatorStrategy() {
        return this.locatorStrategy;
    }

    public void setLocatorStrategy(LocatorStrategy locatorStrategy) {
        this.locatorStrategy = locatorStrategy;
    }

    public String getLocator() {
        return this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    @XmlType(name="windowLocatorStrategy")
    public static enum LocatorStrategy {
        ACCESSIBILITY_ID("Accessibility ID"),
        CLASS_NAME("Class Name"),
        ID("ID"),
        NAME("Name"),
        TAG_NAME("Tag Name"),
        XPATH("XPATH");

        private final String locatorStrategy;

        private LocatorStrategy(String locatorStrategy) {
            this.locatorStrategy = locatorStrategy;
        }

        public String getLocatorStrategy() {
            return this.locatorStrategy;
        }

        public static String[] getStrategies() {
            ArrayList<String> strategies = new ArrayList<String>();
            LocatorStrategy[] locatorStrategyArray = LocatorStrategy.values();
            int n = locatorStrategyArray.length;
            int n2 = 0;
            while (n2 < n) {
                LocatorStrategy str = locatorStrategyArray[n2];
                strategies.add(str.getLocatorStrategy());
                ++n2;
            }
            return strategies.toArray(new String[0]);
        }

        public static LocatorStrategy valueOfStrategy(String strategy) {
            if (StringUtils.isEmpty((CharSequence)strategy)) {
                return null;
            }
            LocatorStrategy[] locatorStrategyArray = LocatorStrategy.values();
            int n = locatorStrategyArray.length;
            int n2 = 0;
            while (n2 < n) {
                LocatorStrategy str = locatorStrategyArray[n2];
                if (str.getLocatorStrategy().equals(strategy)) {
                    return str;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Strategy: " + strategy + " not found");
        }
    }
}

