/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.improvement.parser;

import com.kms.katalon.custom.improvement.model.ParameterType;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;

public class ClassNodeToParamTypeConverter {
    private static final String IMMUTABLE_CLASS_NAME = "org.codehaus.groovy.ast.ImmutableClassNode";
    private static final String DOT = ".";

    private ClassNodeToParamTypeConverter() {
    }

    public static ParameterType convert(ClassNode classNode, boolean resolveGeneric) {
        ParameterType paramType = new ParameterType();
        try {
            if (classNode.isArray()) {
                paramType.setArray(true);
                ParameterType componentType = ClassNodeToParamTypeConverter.convert(classNode.getComponentType(), resolveGeneric);
                paramType.setComponentType(componentType);
                return paramType;
            }
            String fullClassName = ClassNodeToParamTypeConverter.getFullClassName(classNode);
            paramType.setFullClassName(fullClassName);
            paramType.setUnresolvedClassName(classNode.getUnresolvedName());
            if (IMMUTABLE_CLASS_NAME.equals(classNode.getClass().getName())) {
                paramType.setHasImmutableClassName(true);
                return paramType;
            }
            if (classNode.isGenericsPlaceHolder()) {
                paramType.setGnericsPlaceHolder(true);
                return paramType;
            }
            GenericsType[] genericsTypes = classNode.getGenericsTypes();
            if (resolveGeneric && !classNode.isGenericsPlaceHolder() && genericsTypes != null && genericsTypes.length > 0) {
                int i = 0;
                while (i < genericsTypes.length) {
                    GenericsType genericType = genericsTypes[i];
                    ParameterType convertedGenericsType = ClassNodeToParamTypeConverter.convert(genericType.getType(), resolveGeneric);
                    paramType.addGenericsType(convertedGenericsType);
                    ++i;
                }
            }
            return paramType;
        }
        catch (Exception exception) {
            paramType.setHasErrorOnParsing(true);
            paramType.setUnresolvedClassName(classNode.getUnresolvedName());
            return paramType;
        }
    }

    private static String getFullClassName(ClassNode classNode) {
        if (classNode.isArray()) {
            return ClassNodeToParamTypeConverter.getFullClassName(classNode.getComponentType());
        }
        return String.valueOf(ClassNodeToParamTypeConverter.getPackageNamePlusDot(classNode)) + classNode.getNameWithoutPackage().replace('$', '.');
    }

    private static String getPackageNamePlusDot(ClassNode classNode) {
        String packageName = classNode.getPackageName();
        return StringUtils.isNotEmpty((String)packageName) ? String.valueOf(packageName) + DOT : "";
    }
}

