/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.BaseChildSettings;
import com.googlecode.javacv.CanvasFrame;
import com.googlecode.javacv.cpp.opencv_calib3d;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_flann;
import com.googlecode.javacv.cpp.opencv_highgui;
import com.googlecode.javacv.cpp.opencv_imgproc;
import com.googlecode.javacv.cpp.opencv_legacy;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ObjectFinder {
    private Settings settings;
    private static final Logger logger = Logger.getLogger(ObjectFinder.class.getName());
    private opencv_core.CvMemStorage storage = opencv_core.CvMemStorage.create();
    private opencv_core.CvMemStorage tempStorage = opencv_core.CvMemStorage.create();
    private opencv_legacy.CvSURFPoint[] objectKeypoints = null;
    private opencv_legacy.CvSURFPoint[] imageKeypoints = null;
    private FloatBuffer[] objectDescriptors = null;
    private FloatBuffer[] imageDescriptors = null;
    private opencv_core.CvMat objectMat;
    private opencv_core.CvMat imageMat;
    private opencv_core.CvMat indicesMat;
    private opencv_core.CvMat distsMat;
    private opencv_flann.Index flannIndex = null;
    private opencv_flann.IndexParams indexParams = null;
    private opencv_flann.SearchParams searchParams = null;
    private opencv_core.CvMat pt1 = null;
    private opencv_core.CvMat pt2 = null;
    private opencv_core.CvMat mask = null;
    private opencv_core.CvMat H = null;
    private ArrayList<Integer> ptpairs = null;

    public ObjectFinder(opencv_core.IplImage objectImage) {
        this.settings = new Settings();
        this.settings.objectImage = objectImage;
        this.setSettings(this.settings);
    }

    public ObjectFinder(Settings settings) {
        this.setSettings(settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        opencv_core.CvSeq keypoints = new opencv_core.CvSeq(null);
        opencv_core.CvSeq descriptors = new opencv_core.CvSeq(null);
        opencv_core.cvClearMemStorage(this.storage);
        opencv_legacy.cvExtractSURF(settings.objectImage, null, keypoints, descriptors, this.storage, settings.parameters, 0);
        int total = descriptors.total();
        int size = descriptors.elem_size();
        this.objectKeypoints = new opencv_legacy.CvSURFPoint[total];
        this.objectDescriptors = new FloatBuffer[total];
        for (int i2 = 0; i2 < total; ++i2) {
            this.objectKeypoints[i2] = new opencv_legacy.CvSURFPoint(opencv_core.cvGetSeqElem(keypoints, i2));
            this.objectDescriptors[i2] = opencv_core.cvGetSeqElem(descriptors, i2).capacity(size).asByteBuffer().asFloatBuffer();
        }
        if (settings.useFLANN) {
            int length = this.objectDescriptors[0].capacity();
            this.objectMat = opencv_core.CvMat.create(total, length, 5, 1);
            this.imageMat = opencv_core.CvMat.create(total, length, 5, 1);
            this.indicesMat = opencv_core.CvMat.create(total, 2, 4, 1);
            this.distsMat = opencv_core.CvMat.create(total, 2, 5, 1);
            this.flannIndex = new opencv_flann.Index();
            this.indexParams = new opencv_flann.KDTreeIndexParams(4);
            this.searchParams = new opencv_flann.SearchParams(64, 0.0f, true);
        }
        this.pt1 = opencv_core.CvMat.create(1, total, 5, 2);
        this.pt2 = opencv_core.CvMat.create(1, total, 5, 2);
        this.mask = opencv_core.CvMat.create(1, total, 0, 1);
        this.H = opencv_core.CvMat.create(3, 3);
        this.ptpairs = new ArrayList(2 * this.objectDescriptors.length);
        logger.info(total + " object descriptors");
    }

    public double[] find(opencv_core.IplImage image) {
        opencv_core.CvSeq keypoints = new opencv_core.CvSeq(null);
        opencv_core.CvSeq descriptors = new opencv_core.CvSeq(null);
        opencv_core.cvClearMemStorage(this.tempStorage);
        opencv_legacy.cvExtractSURF(image, null, keypoints, descriptors, this.tempStorage, this.settings.parameters, 0);
        int total = descriptors.total();
        int size = descriptors.elem_size();
        this.imageKeypoints = new opencv_legacy.CvSURFPoint[total];
        this.imageDescriptors = new FloatBuffer[total];
        for (int i2 = 0; i2 < total; ++i2) {
            this.imageKeypoints[i2] = new opencv_legacy.CvSURFPoint(opencv_core.cvGetSeqElem(keypoints, i2));
            this.imageDescriptors[i2] = opencv_core.cvGetSeqElem(descriptors, i2).capacity(size).asByteBuffer().asFloatBuffer();
        }
        logger.info(total + " image descriptors");
        int w = this.settings.objectImage.width();
        int h2 = this.settings.objectImage.height();
        double[] srcCorners = new double[]{0.0, 0.0, w, 0.0, w, h2, 0.0, h2};
        double[] dstCorners = this.locatePlanarObject(this.objectKeypoints, this.objectDescriptors, this.imageKeypoints, this.imageDescriptors, srcCorners);
        return dstCorners;
    }

    private double compareSURFDescriptors(FloatBuffer d1, FloatBuffer d2, double best) {
        double t3;
        double t2;
        double t1;
        double t0;
        double totalCost = 0.0;
        assert (d1.capacity() == d2.capacity() && d1.capacity() % 4 == 0);
        for (int i2 = 0; i2 < d1.capacity() && !((totalCost += (t0 = (double)(d1.get(i2) - d2.get(i2))) * t0 + (t1 = (double)(d1.get(i2 + 1) - d2.get(i2 + 1))) * t1 + (t2 = (double)(d1.get(i2 + 2) - d2.get(i2 + 2))) * t2 + (t3 = (double)(d1.get(i2 + 3) - d2.get(i2 + 3))) * t3) > best); i2 += 4) {
        }
        return totalCost;
    }

    private int naiveNearestNeighbor(FloatBuffer vec, int laplacian, opencv_legacy.CvSURFPoint[] modelKeypoints, FloatBuffer[] modelDescriptors) {
        int neighbor = -1;
        double dist1 = 1000000.0;
        double dist2 = 1000000.0;
        for (int i2 = 0; i2 < modelDescriptors.length; ++i2) {
            opencv_legacy.CvSURFPoint kp = modelKeypoints[i2];
            FloatBuffer mvec = modelDescriptors[i2];
            if (laplacian != kp.laplacian()) continue;
            double d2 = this.compareSURFDescriptors(vec, mvec, dist2);
            if (d2 < dist1) {
                dist2 = dist1;
                dist1 = d2;
                neighbor = i2;
                continue;
            }
            if (!(d2 < dist2)) continue;
            dist2 = d2;
        }
        if (dist1 < this.settings.distanceThreshold * dist2) {
            return neighbor;
        }
        return -1;
    }

    private void findPairs(opencv_legacy.CvSURFPoint[] objectKeypoints, FloatBuffer[] objectDescriptors, opencv_legacy.CvSURFPoint[] imageKeypoints, FloatBuffer[] imageDescriptors) {
        for (int i2 = 0; i2 < objectDescriptors.length; ++i2) {
            FloatBuffer descriptor = objectDescriptors[i2];
            opencv_legacy.CvSURFPoint kp = objectKeypoints[i2];
            int nearestNeighbor = this.naiveNearestNeighbor(descriptor, kp.laplacian(), imageKeypoints, imageDescriptors);
            if (nearestNeighbor < 0) continue;
            this.ptpairs.add(i2);
            this.ptpairs.add(nearestNeighbor);
        }
    }

    private void flannFindPairs(FloatBuffer[] objectDescriptors, FloatBuffer[] imageDescriptors) {
        int length = objectDescriptors[0].capacity();
        if (this.imageMat.rows() < imageDescriptors.length) {
            this.imageMat = opencv_core.CvMat.create(imageDescriptors.length, length, 5, 1);
        }
        int imageRows = this.imageMat.rows();
        this.imageMat.rows(imageDescriptors.length);
        FloatBuffer objectBuf = this.objectMat.getFloatBuffer();
        for (int i2 = 0; i2 < objectDescriptors.length; ++i2) {
            objectBuf.put(objectDescriptors[i2]);
        }
        FloatBuffer imageBuf = this.imageMat.getFloatBuffer();
        for (int i3 = 0; i3 < imageDescriptors.length; ++i3) {
            imageBuf.put(imageDescriptors[i3]);
        }
        this.flannIndex.build(this.imageMat, this.indexParams, 1);
        this.flannIndex.knnSearch(this.objectMat, this.indicesMat, this.distsMat, 2, this.searchParams);
        IntBuffer indicesBuf = this.indicesMat.getIntBuffer();
        FloatBuffer distsBuf = this.distsMat.getFloatBuffer();
        for (int i4 = 0; i4 < objectDescriptors.length; ++i4) {
            if (!((double)distsBuf.get(2 * i4) < this.settings.distanceThreshold * (double)distsBuf.get(2 * i4 + 1))) continue;
            this.ptpairs.add(i4);
            this.ptpairs.add(indicesBuf.get(2 * i4));
        }
        this.imageMat.rows(imageRows);
    }

    private double[] locatePlanarObject(opencv_legacy.CvSURFPoint[] objectKeypoints, FloatBuffer[] objectDescriptors, opencv_legacy.CvSURFPoint[] imageKeypoints, FloatBuffer[] imageDescriptors, double[] srcCorners) {
        this.ptpairs.clear();
        if (this.settings.useFLANN) {
            this.flannFindPairs(objectDescriptors, imageDescriptors);
        } else {
            this.findPairs(objectKeypoints, objectDescriptors, imageKeypoints, imageDescriptors);
        }
        int n2 = this.ptpairs.size() / 2;
        logger.info(n2 + " matching pairs found");
        if (n2 < this.settings.matchesMin) {
            return null;
        }
        this.pt1.cols(n2);
        this.pt2.cols(n2);
        this.mask.cols(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            opencv_core.CvPoint2D32f p1 = objectKeypoints[this.ptpairs.get(2 * i2)].pt();
            this.pt1.put(2 * i2, (double)p1.x());
            this.pt1.put(2 * i2 + 1, (double)p1.y());
            opencv_core.CvPoint2D32f p2 = imageKeypoints[this.ptpairs.get(2 * i2 + 1)].pt();
            this.pt2.put(2 * i2, (double)p2.x());
            this.pt2.put(2 * i2 + 1, (double)p2.y());
        }
        if (opencv_calib3d.cvFindHomography(this.pt1, this.pt2, this.H, 8, this.settings.ransacReprojThreshold, this.mask) == 0) {
            return null;
        }
        if (opencv_core.cvCountNonZero(this.mask) < this.settings.matchesMin) {
            return null;
        }
        double[] h2 = this.H.get();
        double[] dstCorners = new double[srcCorners.length];
        for (int i3 = 0; i3 < srcCorners.length / 2; ++i3) {
            double x = srcCorners[2 * i3];
            double y = srcCorners[2 * i3 + 1];
            double Z = 1.0 / (h2[6] * x + h2[7] * y + h2[8]);
            double X = (h2[0] * x + h2[1] * y + h2[2]) * Z;
            double Y = (h2[3] * x + h2[4] * y + h2[5]) * Z;
            dstCorners[2 * i3] = X;
            dstCorners[2 * i3 + 1] = Y;
        }
        this.pt1.cols(objectDescriptors.length);
        this.pt2.cols(objectDescriptors.length);
        this.mask.cols(objectDescriptors.length);
        return dstCorners;
    }

    public static void main(String[] args) throws Exception {
        int i2;
        String objectFilename = args.length == 2 ? args[0] : "/usr/share/opencv/samples/c/box.png";
        String sceneFilename = args.length == 2 ? args[1] : "/usr/share/opencv/samples/c/box_in_scene.png";
        opencv_core.IplImage object = opencv_highgui.cvLoadImage(objectFilename, 0);
        opencv_core.IplImage image = opencv_highgui.cvLoadImage(sceneFilename, 0);
        if (object == null || image == null) {
            System.err.println("Can not load " + objectFilename + " and/or " + sceneFilename);
            System.exit(-1);
        }
        opencv_core.IplImage objectColor = opencv_core.IplImage.create(object.width(), object.height(), 8, 3);
        opencv_imgproc.cvCvtColor(object, objectColor, 8);
        opencv_core.IplImage correspond = opencv_core.IplImage.create(image.width(), object.height() + image.height(), 8, 1);
        opencv_core.cvSetImageROI(correspond, opencv_core.cvRect(0, 0, object.width(), object.height()));
        opencv_core.cvCopy(object, correspond);
        opencv_core.cvSetImageROI(correspond, opencv_core.cvRect(0, object.height(), correspond.width(), correspond.height()));
        opencv_core.cvCopy(image, correspond);
        opencv_core.cvResetImageROI(correspond);
        Settings settings = new Settings();
        settings.objectImage = object;
        settings.useFLANN = true;
        settings.ransacReprojThreshold = 5.0;
        ObjectFinder finder = new ObjectFinder(settings);
        long start = System.currentTimeMillis();
        double[] dst_corners = finder.find(image);
        System.out.println("Finding time = " + (System.currentTimeMillis() - start) + " ms");
        if (dst_corners != null) {
            for (i2 = 0; i2 < 4; ++i2) {
                int j2 = (i2 + 1) % 4;
                int x1 = (int)Math.round(dst_corners[2 * i2]);
                int y1 = (int)Math.round(dst_corners[2 * i2 + 1]);
                int x2 = (int)Math.round(dst_corners[2 * j2]);
                int y2 = (int)Math.round(dst_corners[2 * j2 + 1]);
                opencv_core.cvLine(correspond, opencv_core.cvPoint(x1, y1 + object.height()), opencv_core.cvPoint(x2, y2 + object.height()), opencv_core.CvScalar.WHITE, 1, 8, 0);
            }
        }
        for (i2 = 0; i2 < finder.ptpairs.size(); i2 += 2) {
            opencv_core.CvPoint2D32f pt1 = finder.objectKeypoints[finder.ptpairs.get(i2)].pt();
            opencv_core.CvPoint2D32f pt2 = finder.imageKeypoints[finder.ptpairs.get(i2 + 1)].pt();
            opencv_core.cvLine(correspond, opencv_core.cvPointFrom32f(pt1), opencv_core.cvPoint(Math.round(pt2.x()), Math.round(pt2.y() + (float)object.height())), opencv_core.CvScalar.WHITE, 1, 8, 0);
        }
        CanvasFrame objectFrame = new CanvasFrame("Object");
        CanvasFrame correspondFrame = new CanvasFrame("Object Correspond");
        correspondFrame.showImage(correspond);
        for (int i3 = 0; i3 < finder.objectKeypoints.length; ++i3) {
            opencv_legacy.CvSURFPoint r = finder.objectKeypoints[i3];
            opencv_core.CvPoint center = opencv_core.cvPointFrom32f(r.pt());
            int radius = Math.round((float)r.size() * 1.2f / 9.0f * 2.0f);
            opencv_core.cvCircle(objectColor, center, radius, opencv_core.CvScalar.RED, 1, 8, 0);
        }
        objectFrame.showImage(objectColor);
        objectFrame.waitKey();
        objectFrame.dispose();
        correspondFrame.dispose();
    }

    public static class Settings
    extends BaseChildSettings {
        opencv_core.IplImage objectImage = null;
        opencv_legacy.CvSURFParams parameters = opencv_legacy.cvSURFParams(500.0, 1);
        double distanceThreshold = 0.6;
        int matchesMin = 4;
        double ransacReprojThreshold = 1.0;
        boolean useFLANN = false;

        public opencv_core.IplImage getObjectImage() {
            return this.objectImage;
        }

        public void setObjectImage(opencv_core.IplImage objectImage) {
            this.objectImage = objectImage;
        }

        public boolean isExtended() {
            return this.parameters.extended() != 0;
        }

        public void setExtended(boolean extended) {
            this.parameters.extended(extended ? 1 : 0);
        }

        public boolean isUpright() {
            return this.parameters.upright() != 0;
        }

        public void setUpright(boolean upright) {
            this.parameters.upright(upright ? 1 : 0);
        }

        public double getHessianThreshold() {
            return this.parameters.hessianThreshold();
        }

        public void setHessianThreshold(double hessianThreshold) {
            this.parameters.hessianThreshold(hessianThreshold);
        }

        public int getnOctaves() {
            return this.parameters.nOctaves();
        }

        public void setnOctaves(int nOctaves) {
            this.parameters.nOctaves(nOctaves);
        }

        public int getnOctaveLayers() {
            return this.parameters.nOctaveLayers();
        }

        public void setnOctaveLayers(int nOctaveLayers) {
            this.parameters.nOctaveLayers(nOctaveLayers);
        }

        public double getDistanceThreshold() {
            return this.distanceThreshold;
        }

        public void setDistanceThreshold(double distanceThreshold) {
            this.distanceThreshold = distanceThreshold;
        }

        public int getMatchesMin() {
            return this.matchesMin;
        }

        public void setMatchesMin(int matchesMin) {
            this.matchesMin = matchesMin;
        }

        public double getRansacReprojThreshold() {
            return this.ransacReprojThreshold;
        }

        public void setRansacReprojThreshold(double ransacReprojThreshold) {
            this.ransacReprojThreshold = ransacReprojThreshold;
        }

        public boolean isUseFLANN() {
            return this.useFLANN;
        }

        public void setUseFLANN(boolean useFLANN) {
            this.useFLANN = useFLANN;
        }
    }
}

