/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import cl.eye.CLCamera;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class PS3EyeFrameGrabber
extends FrameGrabber {
    private static FrameGrabber.Exception loadingException = null;
    CLCamera camera;
    int cameraIndex;
    int[] ps3_frame;
    byte[] ipl_frame;
    opencv_core.IplImage image_4ch;
    opencv_core.IplImage image_1ch;
    String stat;
    String uuid;
    protected Triggered triggered;

    public static String[] getDeviceDescriptions() throws FrameGrabber.Exception {
        PS3EyeFrameGrabber.tryLoad();
        String[] descriptions = new String[CLCamera.cameraCount()];
        for (int i2 = 0; i2 < descriptions.length; ++i2) {
            descriptions[i2] = CLCamera.cameraUUID((int)i2);
        }
        return descriptions;
    }

    public static void tryLoad() throws FrameGrabber.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            CLCamera.IsLibraryLoaded();
        }
        catch (Throwable t) {
            loadingException = new FrameGrabber.Exception("Failed to load " + PS3EyeFrameGrabber.class, t);
            throw loadingException;
        }
    }

    public PS3EyeFrameGrabber() throws FrameGrabber.Exception {
        this(0);
    }

    public PS3EyeFrameGrabber(int cameraIndex) throws FrameGrabber.Exception {
        this(cameraIndex, 640, 480, 60);
    }

    public PS3EyeFrameGrabber(int cameraIndex, int imageWidth, int imageHeight, int framerate) throws FrameGrabber.Exception {
        this(cameraIndex, 640, 480, 60, null);
    }

    public PS3EyeFrameGrabber(int cameraIndex, int imageWidth, int imageHeight, int framerate, Object applet) throws FrameGrabber.Exception {
        block7: {
            this.cameraIndex = 0;
            this.ps3_frame = null;
            this.ipl_frame = null;
            this.image_4ch = null;
            this.image_1ch = null;
            this.triggered = Triggered.NO_TRIGGER;
            this.camera = null;
            if (!CLCamera.IsLibraryLoaded()) {
                throw new FrameGrabber.Exception("CLEye multicam dll not loaded");
            }
            try {
                try {
                    this.camera = (CLCamera)CLCamera.class.newInstance();
                }
                catch (Throwable t) {
                    if (applet == null) {
                        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                        unsafeField.setAccessible(true);
                        Unsafe unsafe = (Unsafe)unsafeField.get(null);
                        this.camera = (CLCamera)unsafe.allocateInstance(CLCamera.class);
                        break block7;
                    }
                    this.camera = (CLCamera)CLCamera.class.getConstructors()[0].newInstance(applet);
                }
            }
            catch (Throwable t) {
                throw new FrameGrabber.Exception("Failed to construct " + PS3EyeFrameGrabber.class, t);
            }
        }
        this.cameraIndex = cameraIndex;
        this.stat = "created";
        this.uuid = CLCamera.cameraUUID((int)cameraIndex);
        if (!(imageWidth == 640 && imageHeight == 480 || imageWidth == 320 && imageHeight == 240)) {
            throw new FrameGrabber.Exception("Only 640x480 or 320x240 images supported");
        }
        this.setImageWidth(imageWidth);
        this.setImageHeight(imageHeight);
        this.setImageMode(FrameGrabber.ImageMode.COLOR);
        this.setFrameRate(framerate);
        this.setTimeout(1 + 1000 / framerate);
        this.setBitsPerPixel(8);
        this.setTriggerMode(false);
        this.setNumBuffers(4);
    }

    public static int getCameraCount() {
        return CLCamera.cameraCount();
    }

    public static String[] listPS3Cameras() {
        int no = PS3EyeFrameGrabber.getCameraCount();
        if (no > 0) {
            String[] uuids = new String[no];
            --no;
            while (no >= 0) {
                uuids[no] = CLCamera.cameraUUID((int)no);
                --no;
            }
            return uuids;
        }
        return null;
    }

    public opencv_core.IplImage makeImage(int[] frame) {
        this.image_4ch.getIntBuffer().put(this.ps3_frame);
        return this.image_4ch;
    }

    public int[] grab_raw() {
        if (this.camera.getCameraFrame(this.ps3_frame, this.timeout)) {
            return this.ps3_frame;
        }
        return null;
    }

    public void trigger() throws FrameGrabber.Exception {
        for (int i2 = 0; i2 < this.numBuffers + 1; ++i2) {
            this.grab_raw();
        }
        this.ps3_frame = this.grab_raw();
        if (this.ps3_frame != null) {
            this.triggered = Triggered.HAS_FRAME;
            this.timestamp = System.nanoTime() / 1000L;
        } else {
            this.triggered = Triggered.NO_FRAME;
        }
    }

    public opencv_core.IplImage grab_RGB4() {
        if (this.camera.getCameraFrame(this.ps3_frame, this.timeout)) {
            this.timestamp = System.nanoTime() / 1000L;
            this.image_4ch.getIntBuffer().put(this.ps3_frame);
            return this.image_4ch;
        }
        return null;
    }

    public opencv_core.IplImage grab() throws FrameGrabber.Exception {
        opencv_core.IplImage img = null;
        switch (this.triggered) {
            case NO_TRIGGER: {
                img = this.grab_RGB4();
                break;
            }
            case HAS_FRAME: {
                this.triggered = Triggered.NO_TRIGGER;
                img = this.makeImage(this.ps3_frame);
                break;
            }
            case NO_FRAME: {
                this.triggered = Triggered.NO_TRIGGER;
                return null;
            }
            default: {
                throw new FrameGrabber.Exception("Int. error - unknown triggering state");
            }
        }
        if (img != null && this.imageMode == FrameGrabber.ImageMode.GRAY) {
            opencv_imgproc.cvCvtColor(img, this.image_1ch, 7);
            img = this.image_1ch;
        }
        return img;
    }

    public void start() throws FrameGrabber.Exception {
        boolean b2;
        if (this.ps3_frame == null) {
            this.ps3_frame = new int[this.imageWidth * this.imageHeight];
            this.image_4ch = opencv_core.IplImage.create(this.imageWidth, this.imageHeight, 8, 4);
            this.image_1ch = opencv_core.IplImage.create(this.imageWidth, this.imageHeight, 8, 1);
        }
        if (!(b2 = this.camera.createCamera(this.cameraIndex, this.imageMode == FrameGrabber.ImageMode.GRAY ? CLCamera.CLEYE_MONO_PROCESSED : CLCamera.CLEYE_COLOR_PROCESSED, this.imageWidth == 320 && this.imageHeight == 240 ? CLCamera.CLEYE_QVGA : CLCamera.CLEYE_VGA, (int)this.frameRate))) {
            throw new FrameGrabber.Exception("Low level createCamera() failed");
        }
        b2 = this.camera.startCamera();
        if (!b2) {
            throw new FrameGrabber.Exception("Camera start() failed");
        }
        this.stat = "started";
    }

    public void stop() throws FrameGrabber.Exception {
        boolean b2 = this.camera.stopCamera();
        if (!b2) {
            throw new FrameGrabber.Exception("Camera stop() failed");
        }
        this.stat = "stopped";
    }

    public void release() {
        if (this.camera != null) {
            this.camera.dispose();
            this.camera = null;
        }
        if (this.image_4ch != null) {
            this.image_4ch.release();
            this.image_4ch = null;
        }
        if (this.image_1ch != null) {
            this.image_1ch.release();
            this.image_1ch = null;
        }
        if (this.ipl_frame != null) {
            this.ipl_frame = null;
        }
        if (this.ps3_frame != null) {
            this.ps3_frame = null;
        }
        this.stat = "released";
    }

    public void dispose() {
        this.release();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public CLCamera getCamera() {
        return this.camera;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String toString() {
        return "UUID=" + this.uuid + "; status=" + this.stat + "; timeout=" + this.timeout + "; " + (this.camera != null ? this.camera.toString() : "<no camera>");
    }

    public static void main(String[] argv) {
        String[] uuids = PS3EyeFrameGrabber.listPS3Cameras();
        for (int i2 = 0; i2 < uuids.length; ++i2) {
            System.out.println(i2 + ": " + uuids[i2]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Triggered {
        NO_TRIGGER,
        HAS_FRAME,
        NO_FRAME;

    }
}

