/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.pswing;

import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Container;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class PSwingRepaintManager
extends RepaintManager {
    private final Vector paintingComponents = new Vector();

    public void lockRepaint(JComponent c2) {
        this.paintingComponents.addElement(c2);
    }

    public void unlockRepaint(JComponent c2) {
        this.paintingComponents.remove(c2);
    }

    public boolean isPainting(JComponent c2) {
        return this.paintingComponents.contains(c2);
    }

    public synchronized void addDirtyRegion(JComponent component, int x, int y, int width, int height) {
        boolean captureRepaint = false;
        JComponent childComponent = null;
        int captureX = x;
        int captureY = y;
        for (Container comp = component; comp != null && comp.isLightweight(); comp = comp.getParent()) {
            if (comp.getParent() instanceof PSwingCanvas.ChildWrapper) {
                captureRepaint = true;
                childComponent = comp;
                break;
            }
            captureX = (int)((double)captureX + comp.getLocation().getX());
            captureY = (int)((double)captureY + comp.getLocation().getY());
        }
        if (captureRepaint) {
            if (!this.isPainting(childComponent)) {
                double repaintW = Math.min(childComponent.getWidth() - captureX, width);
                double repaintH = Math.min(childComponent.getHeight() - captureY, height);
                this.getPSwing(childComponent).repaint(new PBounds(captureX, captureY, repaintW, repaintH));
            }
        } else {
            super.addDirtyRegion(component, x, y, width, height);
        }
    }

    public synchronized void addInvalidComponent(JComponent invalidComponent) {
        if (invalidComponent.getParent() == null || !(invalidComponent.getParent() instanceof PSwingCanvas.ChildWrapper)) {
            super.addInvalidComponent(invalidComponent);
        } else {
            invalidComponent.validate();
            this.getPSwing(invalidComponent).updateBounds();
        }
    }

    private PSwing getPSwing(JComponent component) {
        return (PSwing)component.getClientProperty("PSwing");
    }
}

