/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import java.awt.image.BufferedImage;
import org.sikuli.core.cv.BaseTemplateFinder;
import org.sikuli.core.cv.FindResult;
import org.sikuli.core.cv.MatchFetcher;

class ExactColorFinder
extends BaseTemplateFinder {
    ExactColorFinder() {
    }

    FindResult findTopMatch(BufferedImage inputImage, BufferedImage targetImage) {
        opencv_core.IplImage inputColor = opencv_core.IplImage.createFrom(inputImage);
        opencv_core.IplImage targetColor = opencv_core.IplImage.createFrom(targetImage);
        System.out.println("channels = " + inputColor.nChannels());
        System.out.println("channels = " + targetColor.nChannels());
        opencv_core.IplImage inputGray = opencv_core.IplImage.create(opencv_core.cvGetSize(inputColor), 8, 3);
        opencv_core.IplImage targetGray = opencv_core.IplImage.create(opencv_core.cvGetSize(targetColor), 8, 3);
        opencv_core.cvCopy(inputColor, inputGray);
        opencv_core.cvCopy(targetColor, targetGray);
        opencv_core.cvSetImageCOI(inputColor, 0);
        opencv_core.cvSetImageCOI(inputGray, 0);
        FindResult r = this.findTopMatch(inputGray, targetGray);
        return r;
    }

    FindResult findTopMatch(opencv_core.IplImage input, opencv_core.IplImage target) {
        opencv_core.IplImage matchResultMatrix = ExactColorFinder.computeTemplateMatchResultMatrix(input, target);
        MatchFetcher fetcher = new MatchFetcher(matchResultMatrix, target);
        return fetcher.fetchNextMatch();
    }
}

