/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.gui;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.antlr.runtime.tree.CommonTree;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.debug.AddAttributeEvent;

public class JTreeScopeStackModel
implements TreeModel {
    CommonTree root = new StringTree("Scope stack:");

    public JTreeScopeStackModel(InstanceScope scope) {
        List<InstanceScope> stack = Interpreter.getScopeStack(scope, true);
        Iterator<InstanceScope> i$ = stack.iterator();
        while (i$.hasNext()) {
            InstanceScope s2 = i$.next();
            StringTree templateNode = new StringTree(s2.st.getName());
            this.root.addChild(templateNode);
            this.addAttributeDescriptions(s2.st, templateNode);
        }
    }

    public void addAttributeDescriptions(ST st, StringTree node) {
        Map<String, Object> attrs = st.getAttributes();
        if (attrs == null) {
            return;
        }
        Iterator<String> i$ = attrs.keySet().iterator();
        while (i$.hasNext()) {
            String a2 = i$.next();
            String descr = null;
            if (st.debugState != null && st.debugState.addAttrEvents != null) {
                List events = (List)st.debugState.addAttrEvents.get(a2);
                StringBuilder locations = new StringBuilder();
                int i2 = 0;
                if (events != null) {
                    Iterator i$2 = events.iterator();
                    while (i$2.hasNext()) {
                        AddAttributeEvent ae = (AddAttributeEvent)i$2.next();
                        if (i2 > 0) {
                            locations.append(", ");
                        }
                        locations.append(ae.getFileName() + ":" + ae.getLine());
                        ++i2;
                    }
                }
                descr = locations.length() > 0 ? a2 + " = " + attrs.get(a2) + " @ " + locations.toString() : a2 + " = " + attrs.get(a2);
            } else {
                descr = a2 + " = " + attrs.get(a2);
            }
            node.addChild(new StringTree(descr));
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int i2) {
        StringTree t = (StringTree)parent;
        return t.getChild(i2);
    }

    public int getChildCount(Object parent) {
        StringTree t = (StringTree)parent;
        return t.getChildCount();
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        StringTree c2 = (StringTree)child;
        return c2.getChildIndex();
    }

    public void valueForPathChanged(TreePath treePath, Object o2) {
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public static class StringTree
    extends CommonTree {
        String text;

        public StringTree(String text) {
            this.text = text;
        }

        public boolean isNil() {
            return this.text == null;
        }

        public String toString() {
            if (!this.isNil()) {
                return this.text.toString();
            }
            return "nil";
        }
    }
}

