/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestListenerTreeEntity;
import com.kms.katalon.composer.components.impl.tree.UserFileTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.controller.TestListenerController;
import com.kms.katalon.controller.UserFileController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.file.TestListenerEntity;
import com.kms.katalon.entity.file.UserFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LinkEditorHandler
implements EventHandler {
    @Inject
    private EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    private ScopedPreferenceStore store;
    @Inject
    private MApplication application;
    private MWindow window;
    private MPartStack stack;

    @PostConstruct
    public void initListener() {
        this.store = PreferenceStoreManager.getPreferenceStore(LinkEditorHandler.class);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/bringToTop", (EventHandler)this);
    }

    private void setActive(boolean isActive) {
        try {
            this.store.setValue("explorer.linkPart", isActive);
            this.store.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private boolean getActive() {
        return this.store.getBoolean("explorer.linkPart");
    }

    @CanExecute
    public boolean canExecute(MHandledToolItem item) {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(MHandledToolItem item) {
        if (item.isSelected()) {
            this.setActive(true);
            this.window = (MWindow)this.application.getChildren().get(0);
            IEclipseContext appContext = this.application.getContext();
            IEclipseContext context = this.window.getContext();
            if (context == null) {
                context = appContext;
            }
            this.modelService = (EModelService)context.get(EModelService.class);
            this.stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            if (this.stack != null) {
                this.performLinkWithPart((MPart)this.stack.getSelectedElement());
            }
        } else {
            this.setActive(false);
        }
    }

    public void handleEvent(Event event) {
        Object object = event.getProperty("ChangedElement");
        if (this.getActive() && "org/eclipse/e4/ui/LifeCycle/bringToTop".equals(event.getTopic()) && object != null && object instanceof MPart) {
            MPart mpart = (MPart)object;
            this.performLinkWithPart(mpart);
        }
    }

    private void performLinkWithPart(MPart mpart) {
        try {
            TestCaseTreeEntity treeEntity;
            block40: {
                block39: {
                    if (mpart == null) {
                        return;
                    }
                    IEntity entity = EntityPartUtil.getEntityByPartId((String)mpart.getElementId());
                    treeEntity = null;
                    if (entity == null) break block39;
                    ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
                    if (entity instanceof TestCaseEntity) {
                        treeEntity = TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)((TestCaseEntity)entity), (ProjectEntity)projectEntity);
                    } else if (entity instanceof WebElementEntity) {
                        treeEntity = TreeEntityUtil.getWebElementTreeEntity((WebElementEntity)((WebElementEntity)entity), (ProjectEntity)projectEntity);
                    } else if (entity instanceof WindowsElementEntity) {
                        treeEntity = TreeEntityUtil.getWindowsElementTreeEntity((WindowsElementEntity)((WindowsElementEntity)entity), (FolderEntity)entity.getParentFolder());
                    } else if (entity instanceof TestSuiteEntity) {
                        treeEntity = TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)((TestSuiteEntity)entity), (ProjectEntity)projectEntity);
                    } else if (entity instanceof DataFileEntity) {
                        treeEntity = TreeEntityUtil.getTestDataTreeEntity((DataFileEntity)((DataFileEntity)entity), (ProjectEntity)projectEntity);
                    } else if (entity instanceof ReportCollectionEntity) {
                        treeEntity = TreeEntityUtil.getReportCollectionTreeEntity((ReportCollectionEntity)((ReportCollectionEntity)entity), (ProjectEntity)projectEntity);
                    } else if (entity instanceof ReportEntity) {
                        treeEntity = TreeEntityUtil.getReportTreeEntity((ReportEntity)((ReportEntity)entity), (ProjectEntity)projectEntity);
                    } else if (entity instanceof TestSuiteCollectionEntity) {
                        treeEntity = TreeEntityUtil.getTestSuiteCollectionTreeEntity((TestSuiteCollectionEntity)((TestSuiteCollectionEntity)entity), (ProjectEntity)projectEntity);
                    } else if (entity instanceof CheckpointEntity) {
                        treeEntity = TreeEntityUtil.getCheckpointTreeEntity((CheckpointEntity)((CheckpointEntity)entity), (ProjectEntity)projectEntity);
                    } else if (entity instanceof ExecutionProfileEntity) {
                        FolderEntity folderEntity = FolderController.getInstance().getProfileRoot(projectEntity);
                        FolderTreeEntity profileRootFolder = new FolderTreeEntity(folderEntity, null);
                        treeEntity = TreeEntityUtil.getProfileTreeEntity((ExecutionProfileEntity)((ExecutionProfileEntity)entity), (FolderEntity)((FolderEntity)profileRootFolder.getObject()));
                    }
                    break block40;
                }
                IEditorPart editorPart = GroovyEditorUtil.getEditor((MPart)mpart);
                if (editorPart == null) {
                    return;
                }
                IEditorInput editorInput = editorPart.getEditorInput();
                switch (this.getRootFolderName(editorInput)) {
                    case "Test Listeners": {
                        treeEntity = this.getListenerTreeEntity(editorInput);
                        break;
                    }
                    case "Keywords": {
                        treeEntity = this.getKeywordTreeEntity(editorPart);
                        break;
                    }
                    case "Include": {
                        String[] pathSegments = this.getRelativePath(editorInput).split("/");
                        if (pathSegments.length > 2) {
                            String firstChildrentFolderName = pathSegments[1];
                            if (firstChildrentFolderName.equals("scripts")) {
                                treeEntity = this.getKeywordTreeEntity(editorPart);
                                break;
                            }
                            treeEntity = this.getSystemFileRootEntity(editorInput);
                            break;
                        }
                        treeEntity = this.getSystemFileRootEntity(editorInput);
                        break;
                    }
                    default: {
                        treeEntity = this.getUserFileTreeRootEntity(editorInput);
                    }
                }
            }
            if (treeEntity == null) {
                return;
            }
            this.eventBroker.post("EXPLORER/SHOW_ITEM", (Object)treeEntity);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private KeywordTreeEntity getKeywordTreeEntity(IEditorPart editorPart) throws Exception {
        IJavaElement elem;
        if (editorPart != null && (elem = JavaUI.getEditorInputJavaElement((IEditorInput)editorPart.getEditorInput())) instanceof GroovyCompilationUnit && elem.getParent() instanceof IPackageFragment) {
            FolderTreeEntity keywordRootFolder = new FolderTreeEntity(FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()), null);
            PackageTreeEntity newPackageTreeEntity = new PackageTreeEntity((IPackageFragment)elem.getParent(), (ITreeEntity)keywordRootFolder);
            return new KeywordTreeEntity((ICompilationUnit)elem, (ITreeEntity)newPackageTreeEntity);
        }
        return null;
    }

    private TestListenerTreeEntity getListenerTreeEntity(IEditorInput editorInput) throws Exception {
        FolderEntity folderEntity = FolderController.getInstance().getTestListenerRoot(ProjectController.getInstance().getCurrentProject());
        FolderTreeEntity testListenerRootFolder = new FolderTreeEntity(folderEntity, null);
        String[] fileName = editorInput.getName().split("\\.");
        TestListenerEntity testListenerEntity = TestListenerController.getInstance().getTestListener(fileName[0], folderEntity);
        return TreeEntityUtil.getTestListenerTreeEntity((TestListenerEntity)testListenerEntity, (FolderEntity)((FolderEntity)testListenerRootFolder.getObject()));
    }

    private SystemFileTreeEntity getSystemFileRootEntity(IEditorInput editorInput) throws Exception {
        String filePath = this.getFilePath(editorInput);
        SystemFileEntity systemFileEntity = SystemFileController.getInstance().getSystemFile(filePath, ProjectController.getInstance().getCurrentProject());
        return TreeEntityUtil.getSystemFileTreeEntity((SystemFileEntity)systemFileEntity, (FolderEntity)systemFileEntity.getParentFolder());
    }

    private UserFileTreeEntity getUserFileTreeRootEntity(IEditorInput editorInput) throws Exception {
        String filePath = this.getFilePath(editorInput);
        UserFileEntity userFileEntity = UserFileController.getInstance().getUserFileEntity(filePath, ProjectController.getInstance().getCurrentProject());
        return new UserFileTreeEntity(userFileEntity, null);
    }

    private String getFilePath(IEditorInput editorInput) {
        String filePath = "";
        if (editorInput instanceof FileStoreEditorInput var3_4) {
            IPath path = Path.fromOSString((String)fileStore.getURI().getPath().toString());
            filePath = path.toOSString();
        } else {
            if (editorInput instanceof FileEditorInput path) {
                filePath = fileEditor.getPath().toOSString();
            } else {
                if (editorInput instanceof InternalClassFileEditorInput var7_9) {
                    filePath = internalClass.getPath().toOSString();
                }
            }
        }
        return filePath;
    }

    private String getRelativePath(IEditorInput editorInput) {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        String relativePath = this.getFilePath(editorInput).substring(projectEntity.getFolderLocation().length() + 1).replace("\\", "/");
        return relativePath;
    }

    private String getRootFolderName(IEditorInput editorInput) {
        String relativePath = this.getRelativePath(editorInput);
        String[] pathSegments = relativePath.split("/");
        if (pathSegments.length == 1) {
            return "";
        }
        return pathSegments[0];
    }
}

