/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.entity.file.UserFileEntity;
import java.net.URI;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenUserFileHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    Object object = event.getProperty("org.eclipse.e4.data");
                    if (object instanceof UserFileEntity) {
                        UserFileEntity fileEntity = (UserFileEntity)object;
                        OpenUserFileHandler.openEditor(fileEntity);
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
    }

    public static IEditorPart openEditor(UserFileEntity object) {
        try {
            IFileStore fileStore;
            IWorkbenchPage activePage;
            IEditorPart editor;
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(object.toFile().getName());
            if (desc == null || desc.getId().equals("org.codehaus.groovy.eclipse.editor.GroovyEditor")) {
                desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.DefaultTextEditor");
            }
            if ((editor = (activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findEditor((IEditorInput)new FileStoreEditorInput(fileStore = EFS.getStore((URI)object.toFile().toURI())))) != null) {
                activePage.activate((IWorkbenchPart)editor);
            } else {
                editor = activePage.openEditor((IEditorInput)new FileStoreEditorInput(fileStore), desc.getId());
            }
            return editor;
        }
        catch (CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }
}

