/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers.deletion;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.explorer.constants.StringConstants;
import com.kms.katalon.entity.file.FileEntity;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class AbstractDeleteReferredEntityDialog
extends AbstractDialog {
    private String entityId = StringConstants.EMPTY;
    private List<? extends FileEntity> affectedEntities = new ArrayList<FileEntity>();
    protected TableViewer tableViewer;
    protected Label lblStatus;
    private boolean showYesNoToAllButtons = false;

    public AbstractDeleteReferredEntityDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogContainer(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        Control composite = this.createDialogComposite(mainComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        return mainComposite;
    }

    protected Control createDialogComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout glComposite = new GridLayout(1, false);
        glComposite.marginWidth = 0;
        glComposite.marginHeight = 0;
        glComposite.verticalSpacing = 10;
        composite.setLayout((Layout)glComposite);
        Composite compositeHeader = new Composite(composite, 0);
        compositeHeader.setLayout((Layout)new GridLayout(2, false));
        compositeHeader.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblStatusImg = new Label(compositeHeader, 0);
        lblStatusImg.setImage(Display.getCurrent().getSystemImage(8));
        this.lblStatus = new Label(compositeHeader, 64);
        this.lblStatus.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblStatus.setText(MessageFormat.format(StringConstants.DIA_MSG_HEADER_ENTITY_REFERENCES, this.getEntityId()));
        this.createDialogBody(composite);
        return composite;
    }

    protected Control createDialogBody(Composite parent) {
        this.tableViewer = new TableViewer(parent, 67584);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        TableViewerColumn tbvclmOrder = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnOrder = tbvclmOrder.getColumn();
        tblclmnOrder.setWidth(40);
        tblclmnOrder.setText(StringConstants.NO_);
        tbvclmOrder.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == null || !(element instanceof FileEntity)) {
                    return StringConstants.EMPTY;
                }
                return Integer.toString(AbstractDeleteReferredEntityDialog.this.getAffectedEntities().indexOf(element) + 1);
            }
        });
        TableViewerColumn tbvclmSourceID = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnSourceID = tbvclmSourceID.getColumn();
        tblclmnSourceID.setWidth(350);
        tblclmnSourceID.setText(StringConstants.DIA_FIELD_SOURCE_ID);
        tbvclmSourceID.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == null || !(element instanceof FileEntity)) {
                    return StringConstants.EMPTY;
                }
                try {
                    return ((FileEntity)element).getIdForDisplay();
                }
                catch (Exception exception) {
                    return StringConstants.EMPTY;
                }
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    protected final void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
        if (this.isShowYesNoToAllButtons()) {
            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
        }
        this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
        if (this.isShowYesNoToAllButtons()) {
            this.createButton(parent, 21, IDialogConstants.NO_TO_ALL_LABEL, false);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected void handleShellCloseEvent() {
        this.buttonPressed(1);
    }

    protected Point getInitialSize() {
        return new Point(super.getInitialSize().x, 500);
    }

    protected void registerControlModifyListeners() {
        this.mainComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                AbstractDeleteReferredEntityDialog.this.lblStatus.pack(true);
            }
        });
    }

    protected void setInput() {
        try {
            this.tableViewer.setInput(this.getAffectedEntities());
            this.mainComposite.layout(true, true);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public List<? extends FileEntity> getAffectedEntities() {
        return this.affectedEntities;
    }

    public void setAffectedEntities(List<? extends FileEntity> affectedEntities) {
        this.affectedEntities = affectedEntities;
    }

    public boolean isShowYesNoToAllButtons() {
        return this.showYesNoToAllButtons;
    }

    public void setShowYesNoToAllButtons(boolean showYesNoToAllButtons) {
        this.showYesNoToAllButtons = showYesNoToAllButtons;
    }
}

