/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.providers;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityProcessingUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.services.SelectionServiceSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.constants.StringConstants;
import com.kms.katalon.composer.util.groovy.GroovyGuiUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveStarter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class TreeEntityDropListener
extends TreeDropTargetEffect {
    @Inject
    private IEventBroker eventBroker;
    private ITreeEntity lastMovedTreeEntity;
    TreeViewer treeViewer = null;

    public TreeEntityDropListener(TreeViewer treeViewer, IEventBroker eventBroker) {
        super(treeViewer.getTree());
        this.eventBroker = eventBroker;
        this.treeViewer = treeViewer;
    }

    public void drop(DropTargetEvent event) {
        try {
            if (event.data instanceof ITreeEntity[]) {
                ITreeEntity[] treeEntities = (ITreeEntity[])event.data;
                FolderTreeEntity targetTreeEntity = this.getDropDestinationFolder(event);
                FolderEntity target = targetTreeEntity.getObject();
                this.move(treeEntities, target, targetTreeEntity);
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)targetTreeEntity);
                this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)this.lastMovedTreeEntity);
            } else {
                TreeItem[] selection = this.treeViewer.getTree().getSelection();
                ArrayList<ITreeEntity> treeEntity = new ArrayList<ITreeEntity>();
                TreeItem[] treeItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    treeEntity.add((ITreeEntity)item.getData());
                    ++n2;
                }
                event.data = treeEntity.toArray(new ITreeEntity[treeEntity.size()]);
                ITreeEntity[] treeEntities = (ITreeEntity[])event.data;
                PackageTreeEntity targetTreeEntity = this.getDragDestinationPackage(event);
                PackageFragment packageFragment = (PackageFragment)targetTreeEntity.getObject();
                IFile file = null;
                int i = 0;
                while (i < treeEntities.length) {
                    ICompilationUnit unit = (ICompilationUnit)treeEntities[i].getObject();
                    file = (IFile)unit.getResource();
                    ++i;
                }
                TreeEntityDropListener.moveKeyword(file, (IPackageFragment)packageFragment, null);
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)targetTreeEntity.getParent());
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)targetTreeEntity);
                KeywordController.getInstance().parseCustomKeywordFile(file, ProjectController.getInstance().getCurrentProject());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)MessageFormat.format(StringConstants.LIS_ERROR_MSG_CANNOT_MOVE_THE_SELECTION, e.getMessage()));
        }
    }

    public static IFile moveKeyword(IFile keywordFile, IPackageFragment targetPackageFragment, String newName) throws Exception {
        if (keywordFile == null || targetPackageFragment == null) {
            return null;
        }
        String cutKeywordFilePath = TreeEntityDropListener.getPastedFilePath(keywordFile, targetPackageFragment, newName);
        IResource[] resources = new IResource[]{keywordFile};
        IJavaElement[] elements = new IJavaElement[]{JavaCore.create((IFile)keywordFile)};
        IReorgDestination destination = ReorgDestinationFactory.createDestination((Object)targetPackageFragment);
        ReorgMoveStarter moveStarter = ReorgMoveStarter.create((IJavaElement[])elements, (IResource[])resources, (IReorgDestination)destination);
        moveStarter.run(Display.getCurrent().getActiveShell());
        TreeEntityDropListener.refactorReferencingTestSuites(ProjectController.getInstance().getCurrentProject(), keywordFile, keywordFile.getLocation().toString(), cutKeywordFilePath);
        return keywordFile;
    }

    private static void refactorReferencingTestSuites(ProjectEntity project, IFile keyword, String oldKeywordLocation, String newKeywordLocation) throws Exception {
        List lstTestCases = FolderFileServiceManager.getDescendantTestCasesOfFolder((FolderEntity)FolderFileServiceManager.getTestCaseRoot((ProjectEntity)project));
        String constant = "keywords";
        String packageName = String.valueOf(project.getFolderLocation()) + File.separator + constant + File.separator;
        File projectFile = new File(packageName);
        String oldRelativeKwLocation = oldKeywordLocation.substring(projectFile.getAbsolutePath().length() + 1);
        String oldRelativeTcId = FilenameUtils.removeExtension((String)oldRelativeKwLocation).replace("/", ".");
        String newRelativeKwLocation = newKeywordLocation.substring(constant.length() + 1);
        String newRelativeTcId = FilenameUtils.removeExtension((String)newRelativeKwLocation).replace("/", ".");
        for (TestCaseEntity testCase : lstTestCases) {
            ICompilationUnit script = GroovyUtil.getOrCreateGroovyScriptForTestCaseFromPlugin((TestCaseEntity)testCase);
            String str = "";
            File file = new File(script.getResource().getLocation().toString());
            str = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            if (!str.contains("CustomKeywords")) continue;
            String newString = str.replace(oldRelativeTcId, newRelativeTcId);
            GroovyGuiUtil.addContentToTestCase((TestCaseEntity)testCase, (String)newString);
            TestCaseTreeEntity testcaseTreeEntity = TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)testCase, (ProjectEntity)project);
            EventBrokerSingleton.getInstance().getEventBroker().send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testcaseTreeEntity.getParent());
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)testcaseTreeEntity);
        }
    }

    private static String getPastedFilePath(IFile keywordFile, IPackageFragment targetPackageFragment, String newName) {
        String keywordRootPath = String.valueOf(targetPackageFragment.getParent().getElementName()) + '/';
        String packageName = targetPackageFragment.getElementName();
        String packagePath = String.valueOf(keywordRootPath) + (packageName.isEmpty() ? packageName : String.valueOf(packageName.replaceAll("[.]", String.valueOf('/'))) + '/');
        String kwFileName = newName != null ? String.valueOf(newName) + ".groovy" : keywordFile.getName();
        String copiedKeywordFilePath = String.valueOf(packagePath) + kwFileName;
        return copiedKeywordFilePath;
    }

    private PackageTreeEntity getDragDestinationPackage(DropTargetEvent event) throws Exception {
        Object dest = event.item.getData();
        if (dest instanceof PackageTreeEntity) {
            return (PackageTreeEntity)dest;
        }
        return (PackageTreeEntity)((ITreeEntity)dest).getParent();
    }

    private FolderTreeEntity getDropDestinationFolder(DropTargetEvent event) throws Exception {
        Object dest = event.item.getData();
        if (dest instanceof FolderTreeEntity) {
            return (FolderTreeEntity)dest;
        }
        return (FolderTreeEntity)((ITreeEntity)dest).getParent();
    }

    private void move(ITreeEntity[] treeEntities, FolderEntity targetFolder, FolderTreeEntity targetTreeEntity) throws Exception {
        EPartService partService = (EPartService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(EPartService.class);
        FolderEntity rootTargetFolder = null;
        if (SelectionServiceSingleton.getInstance().getSelectionService() != null && partService != null && !partService.getDirtyParts().isEmpty()) {
            if (!MessageDialog.openConfirm(null, (String)StringConstants.HAND_CONFIRM_TITLE, (String)StringConstants.HAND_CONFIRM_MSG_REQUIRE_SAVE_ALL_B4_CONTINUE_MOVING)) {
                return;
            }
            if (!partService.saveAll(true)) {
                return;
            }
        }
        if (targetFolder.getFolderType().equals((Object)FolderEntity.FolderType.TESTCASE)) {
            rootTargetFolder = FolderController.getInstance().getTestCaseRoot(targetFolder.getProject());
        } else if (targetFolder.getFolderType().equals((Object)FolderEntity.FolderType.TESTSUITE)) {
            rootTargetFolder = FolderController.getInstance().getTestSuiteRoot(targetFolder.getProject());
        } else if (targetFolder.getFolderType().equals((Object)FolderEntity.FolderType.WEBELEMENT)) {
            rootTargetFolder = FolderController.getInstance().getObjectRepositoryRoot(targetFolder.getProject());
        } else if (targetFolder.getFolderType().equals((Object)FolderEntity.FolderType.DATAFILE)) {
            rootTargetFolder = FolderController.getInstance().getTestDataRoot(targetFolder.getProject());
        } else if (targetFolder.getFolderType().equals((Object)FolderEntity.FolderType.CHECKPOINT)) {
            rootTargetFolder = FolderController.getInstance().getCheckpointRoot(targetFolder.getProject());
        }
        ITreeEntity[] iTreeEntityArray = treeEntities;
        int n = treeEntities.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeEntity treeEntity = iTreeEntityArray[n2];
            if (treeEntity.isRemoveable()) {
                this.validateMovingAcrossArea(treeEntity, targetFolder);
                if (treeEntity instanceof FolderTreeEntity) {
                    this.validateMovingToSubFolder((FolderEntity)treeEntity.getObject(), targetFolder);
                }
                if (!targetFolder.equals(treeEntity.getObject())) {
                    if (treeEntity.getParent() == null || targetFolder.equals(treeEntity.getParent().getObject())) {
                        this.lastMovedTreeEntity = treeEntity;
                    } else {
                        if (treeEntity instanceof TestCaseTreeEntity) {
                            TestCaseEntity movedTc = EntityProcessingUtil.moveTestCase((TestCaseEntity)((TestCaseTreeEntity)treeEntity).getObject(), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)movedTc, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof FolderTreeEntity) {
                            FolderEntity movedFolder = EntityProcessingUtil.moveFolder((FolderEntity)((FolderTreeEntity)treeEntity).getObject(), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)movedFolder, (FolderEntity)rootTargetFolder);
                        } else if (treeEntity instanceof TestSuiteTreeEntity) {
                            TestSuiteEntity movedTs = EntityProcessingUtil.moveTestSuite((TestSuiteEntity)((TestSuiteTreeEntity)treeEntity).getObject(), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)movedTs, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof TestDataTreeEntity) {
                            DataFileEntity movedTd = EntityProcessingUtil.moveTestData((DataFileEntity)((TestDataTreeEntity)treeEntity).getObject(), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getTestDataTreeEntity((DataFileEntity)movedTd, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof WebElementTreeEntity) {
                            movedTo = EntityProcessingUtil.moveTestObject((WebElementEntity)((WebElementEntity)((WebElementTreeEntity)treeEntity).getObject()), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getWebElementTreeEntity((WebElementEntity)movedTo, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof TestSuiteCollectionTreeEntity) {
                            movedTo = EntityProcessingUtil.moveTestSuiteCollection((TestSuiteCollectionEntity)((TestSuiteCollectionEntity)((TestSuiteCollectionTreeEntity)treeEntity).getObject()), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getTestSuiteCollectionTreeEntity((TestSuiteCollectionEntity)movedTo, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof CheckpointTreeEntity) {
                            CheckpointEntity movedCheckpoint = EntityProcessingUtil.moveCheckpoint((CheckpointEntity)((CheckpointTreeEntity)treeEntity).getObject(), (FolderEntity)targetFolder);
                            this.lastMovedTreeEntity = TreeEntityUtil.getCheckpointTreeEntity((CheckpointEntity)movedCheckpoint, (ProjectEntity)targetFolder.getProject());
                        } else if (treeEntity instanceof SystemFileTreeEntity) {
                            SystemFileTreeEntity systemFileTreeEntity = (SystemFileTreeEntity)treeEntity;
                            SystemFileEntity newSystemFile = SystemFileController.getInstance().moveSystemFile(systemFileTreeEntity.getObject(), targetFolder);
                            if (newSystemFile != null) {
                                this.lastMovedTreeEntity = new SystemFileTreeEntity(newSystemFile, (ITreeEntity)targetTreeEntity);
                            }
                        } else if (treeEntity instanceof WindowsElementTreeEntity) {
                            this.moveWindowsObject((WindowsElementEntity)treeEntity.getObject(), targetTreeEntity);
                        }
                        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)treeEntity.getParent());
                    }
                }
            }
            ++n2;
        }
    }

    private void moveWindowsObject(WindowsElementEntity windowsElement, FolderTreeEntity targetFolder) throws Exception {
        String oldId = windowsElement.getIdForDisplay();
        WindowsElementEntity newsWindowsElement = WindowsElementController.getInstance().moveWindowsElementEntity(windowsElement, targetFolder.getObject());
        if (newsWindowsElement != null) {
            this.lastMovedTreeEntity = new WindowsElementTreeEntity(newsWindowsElement, targetFolder);
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/CUT_PASTED_SELECTED_ITEM", (Object)new Object[]{oldId, newsWindowsElement.getIdForDisplay()});
        }
    }

    private void validateMovingAcrossArea(ITreeEntity treeEntity, FolderEntity targetFolder) throws Exception {
        FolderTreeEntity temp;
        FolderTreeEntity folderTreeEntity = temp = treeEntity instanceof FolderTreeEntity ? (FolderTreeEntity)treeEntity : (FolderTreeEntity)treeEntity.getParent();
        if (!StringUtils.equals((String)temp.getCopyTag(), (String)targetFolder.getFolderType().toString())) {
            throw new Exception(MessageFormat.format(StringConstants.LIS_ERROR_MSG_CANNOT_MOVE_INTO_DIFF_REGION, treeEntity.getCopyTag(), targetFolder.getFolderType().toString()));
        }
    }

    private void validateMovingToSubFolder(FolderEntity folderEntity, FolderEntity targetFolder) throws Exception {
        FolderEntity parent = targetFolder.getParentFolder();
        while (parent != null) {
            if (parent.equals((Object)folderEntity)) {
                throw new Exception(MessageFormat.format(StringConstants.LIS_ERROR_MSG_CANNOT_MOVE_TO_SUBFOLDER, folderEntity.getName(), targetFolder.getName()));
            }
            parent = parent.getParentFolder();
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 17;
        super.dragOver(event);
    }
}

