/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.part;

import com.kms.katalon.composer.components.impl.control.FocusableComposite;
import com.kms.katalon.composer.components.impl.control.GifCLabel;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.execution.constants.ImageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.launcher.IDEObservableLauncher;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class JobViewerPart
implements EventHandler {
    private static final Image IMG_DONE = ImageConstants.IMG_16_DONE;
    private static final Image IMG_WATCH = ImageConstants.IMG_16_WATCH;
    private static final Image IMG_STOP = ImageConstants.IMG_16_STOP;
    private static final Image IMG_WAIT = ImageConstants.IMG_16_WAIT;
    private static final Image IMG_TERMINATE = ImageConstants.IMG_16_TERMINATE;
    private static final Image IMG_PAUSE = ImageConstants.IMG_16_PAUSE;
    private static final Image IMG_PLAY = ImageConstants.IMG_16_PLAY;
    private static final Image IMG_ERROR = ImageConstants.IMG_16_JOBVIEW_ERROR;
    private static final Image IMG_FAIL = ImageConstants.IMG_16_JOBVIEW_FAILED;
    private static final Image IMG_SKIP = ImageConstants.IMG_16_JOBVIEW_SKIPPED;
    private Composite listCompositeLauncher;
    private Composite parentComposite;
    private ScrolledComposite scrolledComposite;
    private MPart mpart;
    private static final String CONTROL_ID = "launcherId";
    private static final String LAUNCHER_PROGRESS_BAR = "launcherProgressBar";
    private static final String LAUNCHER_PROGRESS_LABEL = "launcherProgressLabel";
    @Inject
    private IEventBroker eventBroker;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        this.parentComposite = parent;
        this.mpart = mpart;
        this.registerListeners();
        this.updateToolItemStatus();
        this.parentComposite.setLayout((Layout)new FillLayout());
        this.scrolledComposite = new ScrolledComposite(this.parentComposite, 512);
        this.scrolledComposite.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.scrolledComposite.setBackgroundMode(2);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.listCompositeLauncher = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.listCompositeLauncher);
        GridLayout gl_composite_listLauncher = new GridLayout(1, false);
        gl_composite_listLauncher.marginHeight = 0;
        gl_composite_listLauncher.marginWidth = 0;
        this.listCompositeLauncher.setLayout((Layout)gl_composite_listLauncher);
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = JobViewerPart.this.scrolledComposite.getClientArea();
                JobViewerPart.this.scrolledComposite.setMinSize(JobViewerPart.this.listCompositeLauncher.computeSize(r.width, -1));
            }
        });
    }

    private void updateToolItemStatus() {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            for (MToolBarElement toolbarElement : this.mpart.getToolbar().getChildren()) {
                MDirectToolItem toolItem = (MDirectToolItem)toolbarElement;
                switch (toolItem.getElementId()) {
                    case "com.kms.katalon.composer.execution.directtoolitem.removeAllTerminated": {
                        toolItem.setEnabled(project != null && LauncherManager.getInstance().isAnyLauncherTerminated());
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void registerListeners() {
        this.eventBroker.subscribe("JOB/REFRESH", (EventHandler)this);
        this.eventBroker.subscribe("JOB/UPDATE_PROGRESS", (EventHandler)this);
    }

    private void createLauncherIdComposite(Composite parent, IDEObservableLauncher launcher) {
        FocusableComposite launcherIdComposite = new FocusableComposite(parent, 0);
        launcherIdComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        boolean isDebugMode = launcher.getMode() == LaunchMode.DEBUG;
        GridLayout glLauncherId = new GridLayout(isDebugMode ? 2 : 1, false);
        glLauncherId.marginWidth = 0;
        glLauncherId.marginHeight = 0;
        launcherIdComposite.setLayout((Layout)glLauncherId);
        if (isDebugMode) {
            Label lblDebugImage = new Label((Composite)launcherIdComposite, 0);
            lblDebugImage.setImage(ImageConstants.IMG_16_DEBUG);
            lblDebugImage.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        }
        Label lblId = new Label((Composite)launcherIdComposite, 64);
        lblId.setText(launcher.getName());
        lblId.setFont(JFaceResources.getFontRegistry().getBold(""));
        lblId.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
    }

    private void createJobComposite(Composite composite, final IDEObservableLauncher launcher) throws Exception {
        FocusableComposite compositeLauncher = new FocusableComposite(composite, 2048);
        compositeLauncher.setData(CONTROL_ID, (Object)launcher.getId());
        compositeLauncher.setBackground(ColorUtil.getCompositeBackgroundColor());
        compositeLauncher.setBackgroundMode(2);
        compositeLauncher.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glCompositeLauncher = new GridLayout(3, false);
        glCompositeLauncher.marginHeight = 0;
        compositeLauncher.setLayout((Layout)glCompositeLauncher);
        Label lblWatched = new Label((Composite)compositeLauncher, 0);
        GridData gd_lblWatched = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblWatched.widthHint = 30;
        lblWatched.setLayoutData((Object)gd_lblWatched);
        lblWatched.setImage(IMG_WATCH);
        if (!launcher.isObserved()) {
            lblWatched.setVisible(false);
        }
        this.createLauncherIdComposite((Composite)compositeLauncher, launcher);
        Label lblProgressStatus = new Label((Composite)compositeLauncher, 64);
        lblProgressStatus.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblProgressStatus.setText(String.valueOf(launcher.getResult().getExecutedTestCases()) + "/" + launcher.getResult().getTotalTestCases());
        lblProgressStatus.setData(CONTROL_ID, (Object)LAUNCHER_PROGRESS_LABEL);
        if (launcher.getStatus() == LauncherStatus.RUNNING || launcher.getStatus() == LauncherStatus.SENDING_REPORT || launcher.getStatus() == LauncherStatus.PREPARE_REPORT || launcher.getStatus() == LauncherStatus.UPLOAD_REPORT || launcher.getStatus() == LauncherStatus.PREPARE_INTEGRATION_REPORT) {
            lblLauncherStatus = new GifCLabel((Composite)compositeLauncher, 0);
            lblLauncherStatus.setGifImage(ImageConstants.URL_16_LOADING.openStream());
            gd_lblLauncherStatus = new GridData(16384, 0x1000000, false, false, 1, 1);
            gd_lblLauncherStatus.widthHint = 30;
            lblLauncherStatus.setLayoutData((Object)gd_lblLauncherStatus);
        } else {
            lblLauncherStatus = new Label((Composite)compositeLauncher, 0);
            gd_lblLauncherStatus = new GridData(16384, 0x1000000, false, false, 1, 1);
            gd_lblLauncherStatus.widthHint = 30;
            lblLauncherStatus.setLayoutData((Object)gd_lblLauncherStatus);
            block0 : switch (launcher.getStatus()) {
                case DONE: {
                    switch (this.getExecutionStatus(launcher)) {
                        case ERROR: {
                            lblLauncherStatus.setImage(IMG_ERROR);
                            break block0;
                        }
                        case FAILED: {
                            lblLauncherStatus.setImage(IMG_FAIL);
                            break block0;
                        }
                        case PASSED: {
                            lblLauncherStatus.setImage(IMG_DONE);
                            break block0;
                        }
                        case SKIPPED: {
                            lblLauncherStatus.setImage(IMG_SKIP);
                            break block0;
                        }
                    }
                }
                case SUSPENDED: {
                    break;
                }
                case TERMINATED: {
                    lblLauncherStatus.setImage(IMG_TERMINATE);
                    break;
                }
                case WAITING: {
                    lblLauncherStatus.setImage(IMG_WAIT);
                    break;
                }
            }
        }
        Label lblStatus = new Label((Composite)compositeLauncher, 0);
        GridData gdLblStatus = new GridData(4, 0x1000000, true, false, 1, 1);
        gdLblStatus.heightHint = 9;
        String displayMessage = launcher.getDisplayMessage();
        String doneMessage = LauncherStatus.DONE.toString();
        if (displayMessage.indexOf(doneMessage) == 1) {
            switch (this.getExecutionStatus(launcher)) {
                case ERROR: {
                    displayMessage = displayMessage.replaceFirst(doneMessage, "Error");
                    break;
                }
                case FAILED: {
                    displayMessage = displayMessage.replaceFirst(doneMessage, "Failed");
                    break;
                }
                case PASSED: {
                    displayMessage = displayMessage.replaceFirst(doneMessage, "Passed");
                    break;
                }
                case SKIPPED: {
                    displayMessage = displayMessage.replaceFirst(doneMessage, "Skipped");
                    break;
                }
            }
        }
        lblStatus.setText(displayMessage);
        new Label((Composite)compositeLauncher, 0);
        if (launcher.getStatus() == LauncherStatus.RUNNING || launcher.getStatus() == LauncherStatus.WAITING || launcher.getStatus() == LauncherStatus.SUSPENDED) {
            new Label((Composite)compositeLauncher, 0);
            ProgressBar progressBar = new ProgressBar((Composite)compositeLauncher, 67584);
            GridData gd_progressBar = new GridData(4, 0x1000000, true, false, 1, 1);
            gd_progressBar.heightHint = 12;
            progressBar.setLayoutData((Object)gd_progressBar);
            progressBar.setMinimum(0);
            progressBar.setMaximum(launcher.getResult().getTotalTestCases());
            progressBar.setSelection(launcher.getResult().getExecutedTestCases());
            progressBar.setData(CONTROL_ID, (Object)LAUNCHER_PROGRESS_BAR);
            if (launcher.getStatus() == LauncherStatus.SUSPENDED) {
                progressBar.setState(4);
            }
            Composite compositeLauncherToolbar = new Composite((Composite)compositeLauncher, 0);
            GridLayout glCompositeLauncherToolbar = new GridLayout(1, false);
            glCompositeLauncherToolbar.marginWidth = 0;
            glCompositeLauncherToolbar.marginHeight = 0;
            compositeLauncherToolbar.setLayout((Layout)glCompositeLauncherToolbar);
            compositeLauncherToolbar.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            ToolBar toolBar = new ToolBar(compositeLauncherToolbar, 0x820000);
            toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
            toolBar.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            ToolItem tltmStop = new ToolItem(toolBar, 0);
            tltmStop.setImage(IMG_STOP);
            if (launcher.getStatus() == LauncherStatus.TERMINATED || launcher.getStatus() == LauncherStatus.DONE) {
                tltmStop.setEnabled(false);
            }
            tltmStop.addSelectionListener((SelectionListener)new SelectionAdapter((Composite)compositeLauncher){
                private final /* synthetic */ Composite val$compositeLauncher;
                {
                    this.val$compositeLauncher = composite;
                }

                public void widgetSelected(SelectionEvent e) {
                    launcher.stop();
                    this.val$compositeLauncher.setFocus();
                }
            });
            ToolItem tltmPause = new ToolItem(toolBar, 0);
            if (launcher.getStatus() == LauncherStatus.SUSPENDED) {
                tltmPause.setImage(IMG_PLAY);
                tltmPause.setToolTipText(StringConstants.PA_LOG_RESUME);
            } else if (launcher.getStatus() == LauncherStatus.RUNNING) {
                tltmPause.setImage(IMG_PAUSE);
                tltmPause.setToolTipText(StringConstants.PA_LOG_PAUSE);
            }
            if (launcher.getMode() == LaunchMode.RUN) {
                tltmPause.setEnabled(false);
            }
            tltmPause.addSelectionListener((SelectionListener)new SelectionAdapter((Composite)compositeLauncher){
                private final /* synthetic */ Composite val$compositeLauncher;
                {
                    this.val$compositeLauncher = composite;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (launcher.getStatus() == LauncherStatus.RUNNING) {
                        launcher.suspend();
                    } else {
                        launcher.resume();
                    }
                    this.val$compositeLauncher.setFocus();
                }
            });
        } else {
            glCompositeLauncher.marginBottom = 5;
        }
        compositeLauncher.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        compositeLauncher.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                try {
                    if (!launcher.isObserved()) {
                        JobViewerPart.this.eventBroker.send("CONSOLE_LOG/RESET", (Object)launcher.getId());
                        JobViewerPart.this.eventBroker.send("JOB/REFRESH", null);
                    }
                }
                catch (Exception ex) {
                    LoggerSingleton.getInstance().getLogger().error((Throwable)ex);
                }
            }
        });
        ControlUtils.recursivelyAddMouseListener((Control)compositeLauncher, (MouseAdapter)new MouseAdapter((Composite)compositeLauncher){
            private final /* synthetic */ Composite val$compositeLauncher;
            {
                this.val$compositeLauncher = composite;
            }

            public void mouseDown(MouseEvent event) {
                if (this.val$compositeLauncher != null && !this.val$compositeLauncher.isDisposed()) {
                    this.val$compositeLauncher.setFocus();
                }
            }
        });
    }

    private TestStatus.TestStatusValue getExecutionStatus(IDEObservableLauncher launcher) {
        TestStatus.TestStatusValue status = TestStatus.TestStatusValue.INCOMPLETE;
        ILauncherResult result = launcher.getResult();
        if (result.getNumErrors() > 0) {
            status = TestStatus.TestStatusValue.ERROR;
        } else if (result.getNumFailures() > 0) {
            status = TestStatus.TestStatusValue.FAILED;
        } else if (result.getNumPasses() > 0) {
            status = TestStatus.TestStatusValue.PASSED;
        } else if (result.getNumSkips() > 0) {
            status = TestStatus.TestStatusValue.SKIPPED;
        }
        return status;
    }

    private void draw() {
        try {
            for (ILauncher launcher : LauncherManager.getInstance().getAllLaunchers()) {
                if (!(launcher instanceof IDEObservableLauncher)) continue;
                this.createJobComposite(this.listCompositeLauncher, (IDEObservableLauncher)launcher);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.listCompositeLauncher.setSize(this.listCompositeLauncher.computeSize(-1, -1));
        Rectangle r = this.scrolledComposite.getClientArea();
        this.scrolledComposite.setMinSize(this.listCompositeLauncher.computeSize(r.width, -1));
    }

    public void handleEvent(Event event) {
        try {
            if (event.getTopic().equals("JOB/REFRESH")) {
                while (this.listCompositeLauncher.getChildren().length > 0) {
                    this.listCompositeLauncher.getChildren()[0].dispose();
                }
                this.draw();
                this.updateToolItemStatus();
            } else if (event.getTopic().equals("JOB/UPDATE_PROGRESS")) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object == null || !(object instanceof String)) {
                    return;
                }
                Control[] controlArray = this.listCompositeLauncher.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILauncher launcher;
                    String launcherCompositeId;
                    Control control = controlArray[n2];
                    if (control.getData(CONTROL_ID) != null && (launcherCompositeId = (String)control.getData(CONTROL_ID)).equals(object) && (launcher = LauncherManager.getInstance().getLauncherInRunningList(launcherCompositeId)) != null) {
                        Composite laucherComposite = (Composite)control;
                        Control[] controlArray2 = laucherComposite.getChildren();
                        int n3 = controlArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Control launcherControl = controlArray2[n4];
                            if (launcherControl.getData(CONTROL_ID) != null) {
                                String dataId = (String)launcherControl.getData(CONTROL_ID);
                                ILauncherResult result = launcher.getResult();
                                if (dataId.equals(LAUNCHER_PROGRESS_LABEL)) {
                                    Label progressLabel = (Label)launcherControl;
                                    progressLabel.setText(String.valueOf(result.getExecutedTestCases()) + "/" + result.getTotalTestCases());
                                    progressLabel.pack();
                                } else if (dataId.equals(LAUNCHER_PROGRESS_BAR)) {
                                    ProgressBar progressBar = (ProgressBar)launcherControl;
                                    progressBar.setSelection(result.getTotalTestCases());
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

