/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.provider;

import com.kms.katalon.composer.execution.constants.ImageConstants;
import com.kms.katalon.composer.execution.tree.ILogParentTreeNode;
import com.kms.katalon.composer.execution.tree.ILogTreeNode;
import com.kms.katalon.core.logging.LogLevel;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class LogRecordTreeViewerLabelProvider
extends StyledCellLabelProvider {
    public Image getImage(Object element) {
        ISharedImages images = JavaUI.getSharedImages();
        if (element instanceof ILogParentTreeNode) {
            ILogParentTreeNode logParentNode = (ILogParentTreeNode)element;
            String imageKey = null;
            if (logParentNode.getElapsedTime().isEmpty()) {
                imageKey = "org.eclipse.jdt.ui.methdef_obj.gif";
            } else if (logParentNode.getResult() != null) {
                LogLevel resultLevel = LogLevel.valueOf((Level)logParentNode.getResult().getLevel());
                if (resultLevel == LogLevel.PASSED) {
                    return ImageConstants.IMG_16_LOGVIEW_PASSED;
                }
                if (resultLevel == LogLevel.FAILED) {
                    return ImageConstants.IMG_16_LOGVIEW_FAILED;
                }
                if (resultLevel == LogLevel.ERROR) {
                    return ImageConstants.IMG_16_LOGVIEW_ERROR;
                }
                if (resultLevel == LogLevel.WARNING) {
                    return ImageConstants.IMG_16_LOGVIEW_WARNING;
                }
                if (resultLevel == LogLevel.NOT_RUN) {
                    return ImageConstants.IMG_16_LOGVIEW_NOT_RUN;
                }
            } else if (logParentNode.getParent() == null) {
                return null;
            }
            return images.getImage(imageKey);
        }
        return null;
    }

    public void update(ViewerCell cell) {
        ILogParentTreeNode logParentNode;
        String indexString;
        StyledString styledString = new StyledString();
        if (cell.getElement() == null) {
            return;
        }
        if (cell.getElement() instanceof ILogParentTreeNode && StringUtils.isNotBlank((String)(indexString = (logParentNode = (ILogParentTreeNode)cell.getElement()).getIndexString()))) {
            styledString.append(String.valueOf(indexString) + " - ");
        }
        if (cell.getElement() instanceof ILogTreeNode) {
            ILogTreeNode logTreeNode = (ILogTreeNode)cell.getElement();
            styledString.append(logTreeNode.getMessage());
        }
        if (cell.getElement() instanceof ILogParentTreeNode && (logParentNode = (ILogParentTreeNode)cell.getElement()).getElapsedTime() != null && !logParentNode.getElapsedTime().isEmpty()) {
            styledString.append(" (" + logParentNode.getElapsedTime() + ")", StyledString.COUNTER_STYLER);
        }
        cell.setText(styledString.toString());
        cell.setStyleRanges(styledString.getStyleRanges());
        cell.setImage(this.getImage(cell.getElement()));
        super.update(cell);
    }

    public String getToolTipText(Object element) {
        ILogParentTreeNode logParentNode;
        String indexString;
        if (!(element instanceof ILogTreeNode)) {
            return "";
        }
        StringBuilder cellTextBuilder = new StringBuilder();
        ILogTreeNode logTreeNode = (ILogTreeNode)element;
        if (element instanceof ILogParentTreeNode && StringUtils.isNotBlank((String)(indexString = (logParentNode = (ILogParentTreeNode)element).getIndexString()))) {
            cellTextBuilder.append(String.valueOf(indexString) + " - ");
        }
        cellTextBuilder.append(logTreeNode.getMessage());
        if (element instanceof ILogParentTreeNode && (logParentNode = (ILogParentTreeNode)element).getElapsedTime() != null && !logParentNode.getElapsedTime().isEmpty()) {
            cellTextBuilder.append(" (" + logParentNode.getElapsedTime() + ")");
        }
        return cellTextBuilder.toString();
    }
}

