/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.components.DriverPreferenceComposite;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.dialog.ImportDesiredCapabilitiesDialog;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;

public abstract class DriverPreferencePage
extends PreferencePageWithHelp {
    protected DriverPreferenceComposite driverPreferenceComposite;
    protected IDriverConnector driverConnector;
    private Button btnImport;
    private Button btnExport;

    public DriverPreferencePage() {
        this.initilize();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.driverPreferenceComposite = new DriverPreferenceComposite(container, 0, this.driverConnector);
        this.updateInputToUI();
        return container;
    }

    protected void updateInputToUI() {
        this.driverPreferenceComposite.setInput(this.driverConnector.getUserConfigProperties());
    }

    protected void initilize() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        this.driverConnector = this.getDriverConnector(String.valueOf(projectEntity.getFolderLocation()) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME);
    }

    protected abstract IDriverConnector getDriverConnector(String var1);

    public boolean performOk() {
        block3: {
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            try {
                if (projectEntity != null && this.driverPreferenceComposite != null && this.driverPreferenceComposite.getResult() != null && this.driverConnector != null) break block3;
                return true;
            }
            catch (Exception exception) {
                MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.SETT_ERROR_MSG_UNABLE_TO_SAVE_PROJ_SETTS);
                return false;
            }
        }
        this.driverConnector = this.driverPreferenceComposite.getResult();
        this.driverConnector.saveUserConfigProperties();
        return true;
    }

    protected void performDefaults() {
        this.initilize();
        this.updateInputToUI();
        super.performDefaults();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_EXECUTION;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite buttonBar = this.getApplyButton().getParent();
        GridLayout buttonBarLayout = (GridLayout)buttonBar.getLayout();
        buttonBarLayout.numColumns += 2;
        this.btnImport = new Button(buttonBar, 0x1000000);
        this.btnImport.setText(ComposerExecutionMessageConstants.BTN_IMPORT);
        this.setButtonLayoutData(this.btnImport);
        this.btnImport.moveAbove((Control)this.getDefaultsButton());
        this.btnExport = new Button(buttonBar, 0x1000000);
        this.btnExport.setText(ComposerExecutionMessageConstants.BTN_EXPORT);
        this.setButtonLayoutData(this.btnExport);
        this.btnExport.moveAbove((Control)this.getDefaultsButton());
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DriverPreferencePage.this.canUseImportExportDesiredCapabilities()) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
                    return;
                }
                ImportDesiredCapabilitiesDialog importDialog = new ImportDesiredCapabilitiesDialog(DriverPreferencePage.this.getShell());
                if (importDialog.open() == 0) {
                    DriverPreferencePage.this.importPropertiesFromFile(importDialog.getFilePath(), importDialog.isOverridingExistingProperties());
                }
            }
        });
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DriverPreferencePage.this.canUseImportExportDesiredCapabilities()) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
                    return;
                }
                FileDialog exportFileDialog = new FileDialog(DriverPreferencePage.this.getShell(), 8192);
                exportFileDialog.setFilterNames(StringConstants.IMPORT_EXPORT_DESIRED_CAPABILITIES_FILTER_NAMES);
                exportFileDialog.setFilterExtensions(StringConstants.IMPORT_EXPORT_DESIRED_CAPABILITIES_FILTER_EXTS);
                exportFileDialog.setOverwrite(true);
                exportFileDialog.setFileName(DriverPreferencePage.this.generateDefaultExportFileName());
                String filePath = exportFileDialog.open();
                if (filePath != null) {
                    DriverPreferencePage.this.exportPropertiesToFile(filePath);
                }
            }
        });
    }

    protected void exportPropertiesToFile(String exportFilePath) {
        try {
            this.driverConnector.exportConfigProperties(exportFilePath);
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MessageFormat.format(ComposerExecutionMessageConstants.WARN_CANNOT_EXPORT_DESIRED_CAPABILITIES, exportFilePath), (String)exception.getMessage());
        }
    }

    protected void importPropertiesFromFile(String importFilePath, boolean isOverridingExistingProperties) {
        try {
            this.driverConnector.importConfigProperties(importFilePath, isOverridingExistingProperties);
            this.updateInputToUI();
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MessageFormat.format(ComposerExecutionMessageConstants.WARN_CANNOT_IMPORT_DESIRED_CAPABILITIES, importFilePath), (String)exception.getMessage());
        }
    }

    protected String generateDefaultExportFileName() {
        String driverTypeName = this.driverConnector.getDriverType().getName().toLowerCase();
        driverTypeName = driverTypeName.substring(0, driverTypeName.indexOf("_driver"));
        return String.valueOf(driverTypeName) + "_caps.json";
    }

    private boolean canUseImportExportDesiredCapabilities() {
        IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
        return featureService.canUse(KSEFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
    }
}

