/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.ImageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.dialog.AddExcludedBuiltinLibrariesDialog;
import com.kms.katalon.composer.execution.exceptions.FileBeingUsedException;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.classpath.ProjectBuildPath;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class LibraryManagementSettingPage
extends PreferencePageWithHelp {
    private static final String COMPOSER_EXECUTION_BUNDLE_ID = "com.kms.katalon.composer.execution.settings";
    private static final String COMMA_DELIMTER = ",";
    private static final String EXCLUDED_JAR_FILES = "excludedJarFiles";
    private static final int DELETING_EXTERNAL_JAR_TIMEOUT = 30000;
    private static final int TICK = 1;
    private static final String JAR_FILE_EXTENSION = "*.jar";
    private TableViewer tableViewerForAddExternalJars;
    private TableViewer tableViewerForExcludeJars;
    private ProjectBuildPath projectBuildPath;
    private ToolItem tltmRemoveJarsForAddExternalJars;
    private ToolItem tltmRemoveJarsForExcludeJars;
    private ToolItem tltmAddJarsForAddExternalJars;
    private ToolItem tltmAddJarsForExcludeJars;
    private Collection<File> externalJars;
    private Collection<String> excludedJars;
    private boolean modified;
    private BundleSettingStore store;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
    private TableViewerColumn tableViewerColumnForExcludedJars;
    private Composite excludeJarComposite;
    private Composite externalJarComposite;
    private Composite compExcludeJarInfo;
    private Color grayColor;
    private MouseListener kseFeatureMouseListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
            LibraryManagementSettingPage.this.handleUnauthorizedAccessToExcludeBuiltinLibraries();
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };

    private void handleUnauthorizedAccessToExcludeBuiltinLibraries() {
        KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.EXCLUDE_BUILTIN_LIBRARIES);
    }

    public LibraryManagementSettingPage() {
        this.noDefaultButton();
        this.store = new BundleSettingStore(this.getCurrentProject().getFolderLocation(), COMPOSER_EXECUTION_BUNDLE_ID, true);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(1, false);
        GridData gdContainer = new GridData(4, 4, true, false);
        gdContainer.minimumWidth = 500;
        container.setLayoutData((Object)gdContainer);
        container.setLayout((Layout)glContainer);
        this.buildAddExternalJarsPart(container);
        this.buildExcludeJarsPart(container);
        this.updateInput();
        this.registerControlModifyListeners();
        this.initializeControlStates();
        return container;
    }

    private void initializeControlStates() {
        boolean canExcludeJarFileNames = this.featureService.canUse(KSEFeature.EXCLUDE_BUILTIN_LIBRARIES);
        this.tltmAddJarsForExcludeJars.setEnabled(canExcludeJarFileNames);
        this.tltmRemoveJarsForExcludeJars.setEnabled(canExcludeJarFileNames);
        this.tableViewerForExcludeJars.getTable().setEnabled(canExcludeJarFileNames);
        if (!canExcludeJarFileNames) {
            Color color;
            this.grayColor = color = new Color((Device)Display.getCurrent(), 245, 245, 245);
            this.excludeJarComposite.setBackground(color);
            this.tableViewerForExcludeJars.getTable().setBackground(color);
            this.tableViewerForExcludeJars.getTable().addMouseListener(this.kseFeatureMouseListener);
            this.excludeJarComposite.addMouseListener(this.kseFeatureMouseListener);
        }
    }

    private void buildExcludeJarsPart(Composite container) {
        boolean canExcludeJarFileNames = this.featureService.canUse(KSEFeature.EXCLUDE_BUILTIN_LIBRARIES);
        this.excludeJarComposite = new Composite(container, 0);
        GridLayout glContainer = new GridLayout(1, false);
        GridData gdContainer = new GridData(4, 4, true, true);
        this.excludeJarComposite.setLayoutData((Object)gdContainer);
        this.excludeJarComposite.setLayout((Layout)glContainer);
        this.compExcludeJarInfo = new Composite(this.excludeJarComposite, 0);
        GridLayout glExcludeJarInfo = new GridLayout(2, false);
        glExcludeJarInfo.marginHeight = 0;
        glExcludeJarInfo.horizontalSpacing = 2;
        this.compExcludeJarInfo.setLayout((Layout)glExcludeJarInfo);
        Label lblExcludeJarsInfo = new Label(this.compExcludeJarInfo, 64);
        lblExcludeJarsInfo.setText(ComposerExecutionMessageConstants.EXCLUDE_BUILT_IN_LIBRARIES_INFO);
        new HelpComposite(this.compExcludeJarInfo, ComposerExecutionMessageConstants.DIA_LINK_EXCLUDE_BUILT_IN_LIBRARIES);
        ToolBar toolBar = new ToolBar(this.excludeJarComposite, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.tltmAddJarsForExcludeJars = new ToolItem(toolBar, 0);
        this.tltmAddJarsForExcludeJars.setText(StringConstants.ADD);
        this.tltmAddJarsForExcludeJars.setImage(ImageConstants.IMG_24_ADD);
        this.tltmRemoveJarsForExcludeJars = new ToolItem(toolBar, 0);
        this.tltmRemoveJarsForExcludeJars.setText(StringConstants.REMOVE);
        this.tltmRemoveJarsForExcludeJars.setImage(ImageConstants.IMG_24_REMOVE);
        Composite composite = new Composite(this.excludeJarComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableLayout);
        if (!canExcludeJarFileNames) {
            composite.addMouseListener(this.kseFeatureMouseListener);
        }
        this.tableViewerForExcludeJars = new CTableViewer(composite, 67586);
        this.tableViewerColumnForExcludedJars = new TableViewerColumn(this.tableViewerForExcludeJars, 0);
        TableColumn tblclmnNewColumn = this.tableViewerColumnForExcludedJars.getColumn();
        this.tableViewerColumnForExcludedJars.setLabelProvider((CellLabelProvider)new FileNameLabelCellProvider());
        tableLayout.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(98, 0));
        this.tableViewerForExcludeJars.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    private void buildAddExternalJarsPart(Composite container) {
        this.externalJarComposite = new Composite(container, 0);
        GridLayout glContainer = new GridLayout(1, false);
        GridData gdContainer = new GridData(4, 4, true, true);
        this.externalJarComposite.setLayoutData((Object)gdContainer);
        this.externalJarComposite.setLayout((Layout)glContainer);
        Label lblExternalJarsInfo = new Label(this.externalJarComposite, 64);
        lblExternalJarsInfo.setText(" " + ComposerExecutionMessageConstants.EXTERNAL_LIBRARIES_INFO);
        ToolBar toolBar = new ToolBar(this.externalJarComposite, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.tltmAddJarsForAddExternalJars = new ToolItem(toolBar, 0);
        this.tltmAddJarsForAddExternalJars.setText(StringConstants.ADD);
        this.tltmAddJarsForAddExternalJars.setImage(ImageConstants.IMG_24_ADD);
        this.tltmRemoveJarsForAddExternalJars = new ToolItem(toolBar, 0);
        this.tltmRemoveJarsForAddExternalJars.setText(StringConstants.REMOVE);
        this.tltmRemoveJarsForAddExternalJars.setImage(ImageConstants.IMG_24_REMOVE);
        Composite composite = new Composite(this.externalJarComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableLayout);
        this.tableViewerForAddExternalJars = new CTableViewer(composite, 67586);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewerForAddExternalJars, 0);
        TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
        tableViewerColumn.setLabelProvider((CellLabelProvider)new FileLabelCellProvider());
        tableLayout.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(98, 0));
        this.tableViewerForAddExternalJars.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    private void registerControlModifyListeners() {
        this.registerControlModifyListenersForAddExternaljars();
        this.registerControlModifyListenersForExcludejars();
    }

    private void registerControlModifyListenersForExcludejars() {
        this.tltmAddJarsForExcludeJars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddExcludedBuiltinLibrariesDialog dialog = new AddExcludedBuiltinLibrariesDialog(LibraryManagementSettingPage.this.getShell());
                if (dialog.open() == 0) {
                    String excludedJarFileName = dialog.getSpecifiedLibrary();
                    if (!LibraryManagementSettingPage.this.excludedJars.contains(excludedJarFileName)) {
                        LibraryManagementSettingPage.this.excludedJars.add(excludedJarFileName);
                    }
                    LibraryManagementSettingPage.this.tableViewerForExcludeJars.refresh();
                    LibraryManagementSettingPage.this.tableViewerForExcludeJars.setSelection((ISelection)new StructuredSelection((Object)excludedJarFileName));
                    LibraryManagementSettingPage.this.modified = true;
                }
            }
        });
        this.tltmRemoveJarsForExcludeJars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryManagementSettingPage.this.removeSelectedExcludedJars();
            }
        });
        this.tableViewerForExcludeJars.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    LibraryManagementSettingPage.this.removeSelectedExcludedJars();
                }
            }
        });
    }

    private void registerControlModifyListenersForAddExternaljars() {
        this.tltmAddJarsForAddExternalJars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell(), 2);
                fileDialog.setFilterExtensions(new String[]{LibraryManagementSettingPage.JAR_FILE_EXTENSION});
                if (StringUtils.isEmpty((String)fileDialog.open())) {
                    return;
                }
                Object[] selectedFileNames = fileDialog.getFileNames();
                if (ArrayUtils.isEmpty((Object[])selectedFileNames)) {
                    return;
                }
                ArrayList<File> newFiles = new ArrayList<File>();
                Object[] objectArray = selectedFileNames;
                int n = selectedFileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    Object fileName = objectArray[n2];
                    File newExternalFile = new File(LibraryManagementSettingPage.this.getExternalDir(), (String)fileName);
                    newFiles.add(newExternalFile);
                    try {
                        FileUtils.copyFile((File)new File(fileDialog.getFilterPath(), (String)fileName), (File)newExternalFile, (boolean)true);
                        if (!LibraryManagementSettingPage.this.externalJars.contains(newExternalFile)) {
                            LibraryManagementSettingPage.this.externalJars.add(newExternalFile);
                        }
                    }
                    catch (IOException veryImportantException) {
                        LoggerSingleton.logError((Throwable)veryImportantException);
                    }
                    ++n2;
                }
                LibraryManagementSettingPage.this.tableViewerForAddExternalJars.refresh();
                LibraryManagementSettingPage.this.tableViewerForAddExternalJars.setSelection((ISelection)new StructuredSelection(newFiles));
                LibraryManagementSettingPage.this.modified = true;
            }
        });
        this.tltmRemoveJarsForAddExternalJars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryManagementSettingPage.this.removeSelectedExternalJars();
            }
        });
        this.tableViewerForAddExternalJars.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    LibraryManagementSettingPage.this.removeSelectedExternalJars();
                }
            }
        });
    }

    private void removeSelectedExternalJars() {
        StructuredSelection selection = (StructuredSelection)this.tableViewerForAddExternalJars.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object objectFile = objectArray[n2];
            File file = (File)objectFile;
            this.externalJars.remove(file);
            ++n2;
        }
        this.tableViewerForAddExternalJars.refresh();
        this.modified = true;
    }

    private void removeSelectedExcludedJars() {
        StructuredSelection selection = (StructuredSelection)this.tableViewerForExcludeJars.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object objectFileName = objectArray[n2];
            String fileName = (String)objectFileName;
            this.excludedJars.remove(fileName);
            ++n2;
        }
        this.tableViewerForExcludeJars.refresh();
        this.modified = true;
    }

    private ProjectEntity getCurrentProject() {
        return ProjectController.getInstance().getCurrentProject();
    }

    private void updateInput() {
        ProjectEntity currentProject = this.getCurrentProject();
        this.projectBuildPath = new ProjectBuildPath(currentProject);
        this.externalJars = this.getExternalJars();
        this.excludedJars = this.getExcludedJarNames();
        this.tableViewerForAddExternalJars.setInput(this.externalJars);
        this.tableViewerForExcludeJars.setInput(this.excludedJars);
        this.modified = false;
    }

    private Collection<String> getExcludedJarNames() {
        ArrayList<String> listExcluded = new ArrayList<String>();
        try {
            ArrayList<String> excluded = new ArrayList<String>(Arrays.asList(this.store.getString(EXCLUDED_JAR_FILES, "").split(COMMA_DELIMTER)));
            excluded.removeIf(value -> "".equals(value.trim()));
            listExcluded.addAll(excluded);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return listExcluded;
    }

    private Collection<File> getExternalJars() {
        final File externalDir = this.getExternalDir();
        Collection<File> listJarFiles = new ArrayList<File>();
        if (externalDir.exists()) {
            listJarFiles = FileUtils.listFiles((File)externalDir, (IOFileFilter)new WildcardFileFilter(JAR_FILE_EXTENSION), (IOFileFilter)new AbstractFileFilter(){

                public boolean accept(File file) {
                    return file == externalDir;
                }
            });
        }
        return listJarFiles;
    }

    private File getExternalDir() {
        return this.projectBuildPath.getExternalLibrariesDir();
    }

    public boolean performOk() {
        if (!this.modified || this.tableViewerForAddExternalJars == null || this.tableViewerForAddExternalJars.getTable().isDisposed()) {
            return true;
        }
        try {
            this.store.setProperty(EXCLUDED_JAR_FILES, this.excludedJars.stream().collect(Collectors.joining(COMMA_DELIMTER)));
            new ProgressMonitorDialog(this.getShell()).run(true, false, new IRunnableWithProgress(){

                private void removeUnusedFiles(IProgressMonitor monitor) throws FileBeingUsedException {
                    Collection<File> needRemovedJars = LibraryManagementSettingPage.this.getExternalJars();
                    needRemovedJars.removeAll(LibraryManagementSettingPage.this.externalJars);
                    if (needRemovedJars.isEmpty()) {
                        return;
                    }
                    monitor.beginTask(ComposerExecutionMessageConstants.MSG_DELETING_LIBRARY_FILES, needRemovedJars.size());
                    for (File file : needRemovedJars) {
                        monitor.subTask(MessageFormat.format(ComposerExecutionMessageConstants.MSG_DELETING_FILE_X, file.getName()));
                        this.safelyDeleleFile(file, 30000L);
                        monitor.worked(1);
                    }
                }

                private void safelyDeleleFile(File file, long timeoutInMillis) throws FileBeingUsedException {
                    long startTime = System.currentTimeMillis();
                    while (file.exists() && System.currentTimeMillis() - startTime <= timeoutInMillis) {
                        FileUtils.deleteQuietly((File)file);
                    }
                    if (file.exists()) {
                        throw new FileBeingUsedException(file, LibraryManagementSettingPage.this.getCurrentProject());
                    }
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(StringConstants.PAGE_EXTERNAL_LIB_JOB_TASK_REBUILD_PROJECT, 5);
                            ProjectController projectController = ProjectController.getInstance();
                            ProjectEntity currentProject = LibraryManagementSettingPage.this.getCurrentProject();
                            projectController.cleanProjectUISettings(currentProject);
                            monitor.worked(1);
                            LibraryManagementSettingPage.this.saveAllProject();
                            monitor.worked(1);
                            GroovyUtil.getGroovyProject((ProjectEntity)currentProject).close((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            try {
                                this.removeUnusedFiles(monitor);
                                monitor.worked(1);
                            }
                            finally {
                                boolean allowSourceAttachment = LibraryManagementSettingPage.this.featureService.canUse(KSEFeature.SOURCE_CODE_FOR_DEBUGGING);
                                projectController.openProjectForUI(currentProject.getId(), allowSourceAttachment, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (!(targetException instanceof FileBeingUsedException)) {
                LoggerSingleton.logError((Throwable)targetException);
            } else {
                this.updateInput();
            }
            MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)StringConstants.PAGE_EXTERNAL_LIB_MSG_UNABLE_UPDATE_PROJECT, (String)targetException.getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException e1) {
            LoggerSingleton.logError((Throwable)e1);
        }
        return super.performOk();
    }

    private void saveAllProject() {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (this.getService(EPartService.class).getDirtyParts().isEmpty()) {
                    return;
                }
                try {
                    this.getService(IHandlerService.class).executeCommand("com.kms.katalon.command.saveAll", null);
                }
                catch (CommandException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            private <T> T getService(Class<? extends T> clazz) {
                return (T)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(clazz);
            }
        });
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_EXTERNAL_LIBRARIES;
    }

    public void dispose() {
        if (this.grayColor != null) {
            this.grayColor.dispose();
        }
        super.dispose();
    }

    private class FileLabelCellProvider
    extends TypeCheckedStyleCellLabelProvider<File> {
        public FileLabelCellProvider() {
            super(0);
        }

        protected Class<File> getElementType() {
            return File.class;
        }

        protected Image getImage(File element) {
            return ImageConstants.IMG_16_EXTERNAL_LIBRARY;
        }

        protected String getText(File file) {
            return FilenameUtils.getName((String)file.getName());
        }
    }

    private class FileNameLabelCellProvider
    extends TypeCheckedStyleCellLabelProvider<String> {
        public FileNameLabelCellProvider() {
            super(0);
        }

        protected Class<String> getElementType() {
            return String.class;
        }

        protected Image getImage(String element) {
            return ImageConstants.IMG_16_EXTERNAL_LIBRARY;
        }

        protected String getText(String element) {
            return element;
        }
    }
}

