/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.setting.EmailSettingStore;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.feature.KSEFeature;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MailSettingsPage
extends PreferencePageWithHelp {
    public static final String MAIL_CONFIG_USERNAME_HINT = "E.g: testemailkms@gmail.com";
    public static final String MAIL_CONFIG_PORT_HINT = "E.g: 465";
    public static final String MAIL_CONFIG_HOST_HINT = "E.g: smtp.gmail.com";
    private static final char PASSWORD_CHAR_MASK = '\u2022';
    private EmailSettingStore store;
    private Text txtHost;
    private Text txtPort;
    private Text txtUsername;
    private Text txtPassword;
    private Combo comboProtocol;
    private Button btnChkAttachment;
    private Text txtSender;
    private Text txtRecipients;
    private Text txtSubject;
    private Text txtCc;
    private Text txtBcc;
    private Link lnkEditTemplateForTestSuite;
    private Link lnkEditTemplateForTestSuiteCollection;
    private Button btnSendTestEmail;
    private EmailConfigValidator validator;
    private Group grpReportFormatOptions;
    private Composite attachmentOptionsComposite;
    private Map<ReportFormatType, Button> formatOptionCheckboxes;
    private Button chckEncrypt;
    private Button cbSendTestSuiteReport;
    private Button rbSendReportFailedTestSuites;
    private Button rbSendReportAllTestSuites;
    private Button cbSendTestSuiteCollectionReport;
    private Button cbSkipIndividualTestSuiteReport;
    private Button chckUseUsernameAsSender;
    private Group testSuiteReportGroup;
    private Group testSuiteCollectionReportGroup;

    public MailSettingsPage() {
        this.noDefaultButton();
        this.store = new EmailSettingStore(ProjectController.getInstance().getCurrentProject());
        this.validator = new EmailConfigValidator();
        this.formatOptionCheckboxes = new HashMap<ReportFormatType, Button>();
    }

    public EmailSettingStore getSettingStore() {
        return this.store;
    }

    protected Control createContents(Composite parent) {
        Composite container = this.createComposite(parent, 1, 1);
        this.createServerGroup(container);
        this.createPostExecuteGroup(container);
        this.createReportFormatGroup(container);
        this.addTestSuiteReportGroup(container);
        this.addTestSuiteCollectionReportGroup(container);
        this.createSendTestEmailButton(container);
        this.registerControlListers();
        this.updateInput();
        return container;
    }

    private void updateInput() {
        try {
            EmailSettingStore settingStore = this.getSettingStore();
            boolean encrytionEnabled = settingStore.isEncryptionEnabled();
            this.chckEncrypt.setSelection(encrytionEnabled);
            this.txtHost.setText(settingStore.getHost(encrytionEnabled));
            this.txtPort.setText(settingStore.getPort(encrytionEnabled));
            this.txtUsername.setText(settingStore.getUsername(encrytionEnabled));
            this.txtPassword.setText(settingStore.getPassword(encrytionEnabled));
            this.comboProtocol.setText(settingStore.getProtocol(encrytionEnabled));
            this.btnChkAttachment.setSelection(settingStore.isAddAttachment());
            this.updateReportFormatOptionsStatus();
            this.chckUseUsernameAsSender.setSelection(settingStore.useUsernameAsSender());
            String sender = settingStore.getSender();
            if (settingStore.useUsernameAsSender()) {
                sender = this.txtUsername.getText();
            }
            this.txtSender.setText(sender);
            if (this.chckUseUsernameAsSender.getSelection()) {
                this.txtSender.setEnabled(false);
            } else {
                this.txtSender.setEnabled(true);
            }
            this.txtRecipients.setText(settingStore.getRecipients(encrytionEnabled));
            this.txtCc.setText(settingStore.getEmailCc());
            this.txtBcc.setText(settingStore.getEmailBcc());
            this.txtSubject.setText(settingStore.getEmailSubject());
            settingStore.getReportFormatOptions().forEach(format -> this.formatOptionCheckboxes.get(format).setSelection(true));
            this.cbSendTestSuiteReport.setSelection(settingStore.isSendTestSuiteReportEnabled());
            this.rbSendReportFailedTestSuites.setSelection(settingStore.isSendEmailTestFailedOnly());
            this.rbSendReportAllTestSuites.setSelection(!settingStore.isSendEmailTestFailedOnly());
            this.setTestSuiteReportGroupEnabled(settingStore.isSendTestSuiteReportEnabled());
            boolean isSendCollectionReportEnabled = LicenseUtil.isNotFreeLicense() ? settingStore.isSendTestSuiteCollectionReportEnabled() : false;
            this.cbSendTestSuiteCollectionReport.setSelection(isSendCollectionReportEnabled);
            this.cbSkipIndividualTestSuiteReport.setSelection(settingStore.isSkipInvidualTestSuiteReport());
            this.setTestSuiteCollectionReportGroupEnabled(isSendCollectionReportEnabled);
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void registerControlListers() {
        this.lnkEditTemplateForTestSuite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventBrokerSingleton.getInstance().getEventBroker().post("SETTINGS/PAGE_CHANGE", (Object)"com.kms.katalon.composer.execution.page.testSuiteEmailTemplate");
            }
        });
        this.lnkEditTemplateForTestSuiteCollection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventBrokerSingleton.getInstance().getEventBroker().post("SETTINGS/PAGE_CHANGE", (Object)"com.kms.katalon.composer.execution.page.testSuiteCollectionEmailTemplate");
            }
        });
        this.btnSendTestEmail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MailSettingsPage.this.removeSpacesInText();
                EmailConfig emailConfig = new EmailConfig();
                emailConfig.setFrom(MailSettingsPage.this.txtSender.getText());
                emailConfig.setUsername(MailSettingsPage.this.txtUsername.getText());
                emailConfig.setHost(MailSettingsPage.this.txtHost.getText());
                emailConfig.setPassword(MailSettingsPage.this.txtPassword.getText());
                emailConfig.setPort(MailSettingsPage.this.txtPort.getText());
                emailConfig.setSecurityProtocol(MailUtil.MailSecurityProtocolType.valueOf((String)MailSettingsPage.this.comboProtocol.getText()));
                emailConfig.addRecipients(MailSettingsPage.this.txtRecipients.getText());
                emailConfig.setCc(MailSettingsPage.this.txtCc.getText());
                emailConfig.setBcc(MailSettingsPage.this.txtBcc.getText());
                emailConfig.setSubject(MailSettingsPage.this.txtSubject.getText());
                emailConfig.setAttachmentOptions(MailSettingsPage.this.getSelectedAttachmentOptions());
                try {
                    ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                    Map variables = EmailVariableBinding.getTestEmailVariables();
                    MailUtil.overrideEmailSettings((EmailConfig)emailConfig, (ExecutionProfileEntity)GlobalVariableController.getInstance().getDefaultExecutionProfile(project), (Map)variables);
                    emailConfig.setHtmTemplateForTestSuite(MailSettingsPage.this.getSettingStore().getEmailHTMLTemplateForTestSuite());
                }
                catch (ControllerException | IOException | URISyntaxException ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
                MailSettingsPage.this.sendTestEmail(emailConfig);
            }
        });
        this.txtPort.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = StringUtils.isNumeric((String)e.text);
                if (e.doit) {
                    MailSettingsPage.this.setValidationAndEnableSendEmail("port", StringUtils.isNotEmpty((String)e.text));
                }
            }
        });
        this.txtHost.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailSettingsPage.this.setValidationAndEnableSendEmail("host", StringUtils.isNotEmpty((String)MailSettingsPage.this.txtHost.getText()));
            }
        });
        this.txtUsername.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MailSettingsPage.this.chckUseUsernameAsSender.getSelection()) {
                    MailSettingsPage.this.txtSender.setText(MailSettingsPage.this.txtUsername.getText());
                }
            }
        });
        this.chckUseUsernameAsSender.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MailSettingsPage.this.chckUseUsernameAsSender.getSelection()) {
                    MailSettingsPage.this.txtSender.setEnabled(false);
                    MailSettingsPage.this.txtSender.setText(MailSettingsPage.this.txtUsername.getText());
                } else {
                    MailSettingsPage.this.txtSender.setEnabled(true);
                }
            }
        });
        this.btnChkAttachment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MailSettingsPage.this.updateReportFormatOptionsStatus();
            }
        });
        this.cbSendTestSuiteReport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MailSettingsPage.this.setTestSuiteReportGroupEnabled(MailSettingsPage.this.cbSendTestSuiteReport.getSelection());
            }
        });
        this.cbSendTestSuiteCollectionReport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LicenseUtil.isNotFreeLicense()) {
                    MailSettingsPage.this.setTestSuiteCollectionReportGroupEnabled(MailSettingsPage.this.cbSendTestSuiteCollectionReport.getSelection());
                } else {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.TEST_SUITE_COLLECTION_EXECUTION_EMAIL);
                    MailSettingsPage.this.cbSendTestSuiteCollectionReport.setSelection(false);
                }
            }
        });
    }

    private void removeSpacesInText() {
        this.txtPort.setText(this.txtPort.getText().replace(" ", ""));
        this.txtHost.setText(this.txtHost.getText().replace(" ", ""));
    }

    private List<ReportFormatType> getSelectedAttachmentOptions() {
        return this.formatOptionCheckboxes.entrySet().stream().filter(e -> ((Button)e.getValue()).getSelection()).map(e -> (ReportFormatType)e.getKey()).collect(Collectors.toList());
    }

    private void updateReportFormatOptionsStatus() {
        ControlUtils.recursiveSetEnabled((Control)this.attachmentOptionsComposite, (boolean)this.btnChkAttachment.getSelection());
    }

    private void setValidationAndEnableSendEmail(String property, boolean validated) {
        this.validator.setValidation(property, validated);
        this.btnSendTestEmail.setEnabled(this.validator.isValidated());
    }

    protected void performApply() {
        super.performApply();
    }

    public boolean performOk() {
        if (!this.isControlCreated()) {
            return super.performOk();
        }
        try {
            boolean encrytionEnabled = this.chckEncrypt.getSelection();
            this.removeSpacesInText();
            EmailSettingStore settingStore = this.getSettingStore();
            settingStore.enableAuthenticationEncryption(encrytionEnabled);
            settingStore.setHost(this.txtHost.getText(), encrytionEnabled);
            settingStore.setPort(this.txtPort.getText(), encrytionEnabled);
            settingStore.setUsername(this.txtUsername.getText(), encrytionEnabled);
            settingStore.setPassword(this.txtPassword.getText(), encrytionEnabled);
            settingStore.setProtocol(this.comboProtocol.getText(), encrytionEnabled);
            settingStore.setIsAddAttachment(this.btnChkAttachment.getSelection());
            settingStore.setEmailSubject(this.txtSubject.getText());
            settingStore.setEmailCc(this.txtCc.getText());
            settingStore.setEmailBcc(this.txtBcc.getText());
            settingStore.setUseUsernameAsSender(this.chckUseUsernameAsSender.getSelection());
            settingStore.setSender(this.txtSender.getText());
            settingStore.setRecipients(this.txtRecipients.getText(), encrytionEnabled);
            settingStore.setReportFormatOptions(this.getSelectedAttachmentOptions());
            settingStore.setSendTestSuiteReportEnabled(this.cbSendTestSuiteReport.getSelection());
            settingStore.setSendEmailTestFailedOnly(this.rbSendReportFailedTestSuites.getSelection());
            settingStore.setSendTestSuiteCollectionReportEnabled(this.cbSendTestSuiteCollectionReport.getSelection());
            settingStore.setSkipIndividualTestSuiteReport(this.cbSkipIndividualTestSuiteReport.getSelection());
            return super.performOk();
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    private void createPostExecuteGroup(Composite container) {
        Group postExecuteGroup = MailSettingsPage.createGroup(container, ComposerExecutionMessageConstants.PREF_GROUP_LBL_EXECUTION_MAIL, 2, 1, 768);
        this.chckUseUsernameAsSender = new Button((Composite)postExecuteGroup, 32);
        this.chckUseUsernameAsSender.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.chckUseUsernameAsSender.setText(ComposerExecutionMessageConstants.PREF_CHECK_USE_USERNAME_AS_SENDER);
        this.txtSender = this.createTextFieldWithLabel((Composite)postExecuteGroup, ComposerExecutionMessageConstants.PREF_LBL_REPORT_SENDER, "", 1);
        this.txtRecipients = this.createTextFieldWithLabel((Composite)postExecuteGroup, ComposerExecutionMessageConstants.PREF_LBL_REPORT_RECIPIENTS, ComposerExecutionMessageConstants.PREF_TXT_PH_RECIPIENTS, 1);
        this.txtCc = this.createTextFieldWithLabel((Composite)postExecuteGroup, ComposerExecutionMessageConstants.PREF_LBL_CC, "", 1);
        this.txtBcc = this.createTextFieldWithLabel((Composite)postExecuteGroup, ComposerExecutionMessageConstants.PREF_LBL_BCC, "", 1);
        this.txtSubject = this.createTextFieldWithLabel((Composite)postExecuteGroup, ComposerExecutionMessageConstants.PREF_LBL_SUBJECT, "", 1);
        Label lblBody = new Label((Composite)postExecuteGroup, 0);
        lblBody.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblBody.setText(ComposerExecutionMessageConstants.PREF_LBL_BODY);
        Composite linkComposite = new Composite((Composite)postExecuteGroup, 0);
        GridLayout glLinkComposite = new GridLayout();
        glLinkComposite.marginWidth = 0;
        glLinkComposite.marginHeight = 0;
        linkComposite.setLayout((Layout)glLinkComposite);
        linkComposite.setLayoutData((Object)new GridData(768));
        this.lnkEditTemplateForTestSuite = new Link(linkComposite, 0);
        this.lnkEditTemplateForTestSuite.setText(String.format("<a>%s</a>", ComposerExecutionMessageConstants.PREF_LNK_EDIT_TEMPLATE_TEST_SUITE));
        this.lnkEditTemplateForTestSuiteCollection = new Link(linkComposite, 0);
        this.lnkEditTemplateForTestSuiteCollection.setText(String.format("<a>%s</a>", ComposerExecutionMessageConstants.PREF_LNK_EDIT_TEMPLATE_TEST_SUITE_COLLECTION));
    }

    private void createReportFormatGroup(Composite container) {
        this.grpReportFormatOptions = new Group(container, 0);
        this.grpReportFormatOptions.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.grpReportFormatOptions.setText(ComposerExecutionMessageConstants.PREF_LBL_REPORT_FORMAT);
        GridLayout reportFormatLayout = new GridLayout(1, true);
        reportFormatLayout.marginLeft = 0;
        reportFormatLayout.marginRight = 0;
        reportFormatLayout.marginHeight = 5;
        this.grpReportFormatOptions.setLayout((Layout)reportFormatLayout);
        this.btnChkAttachment = new Button((Composite)this.grpReportFormatOptions, 32);
        this.btnChkAttachment.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnChkAttachment.setText(ComposerExecutionMessageConstants.PREF_LBL_INCLUDE_ATTACHMENT);
        this.attachmentOptionsComposite = new Composite((Composite)this.grpReportFormatOptions, 0);
        this.attachmentOptionsComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout attachmentsLayout = new GridLayout(1, true);
        attachmentsLayout.marginLeft = 15;
        attachmentsLayout.marginRight = 0;
        attachmentsLayout.marginHeight = 0;
        this.attachmentOptionsComposite.setLayout((Layout)attachmentsLayout);
        ReportFormatType[] reportFormatTypeArray = ReportFormatType.values();
        int n = reportFormatTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReportFormatType formatType = reportFormatTypeArray[n2];
            Button btnFormmatingType = new Button(this.attachmentOptionsComposite, 32);
            btnFormmatingType.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            btnFormmatingType.setText(formatType.toString());
            btnFormmatingType.setData((Object)formatType);
            this.formatOptionCheckboxes.put(formatType, btnFormmatingType);
            ++n2;
        }
    }

    private void addTestSuiteReportGroup(Composite container) {
        this.testSuiteReportGroup = new Group(container, 0);
        this.testSuiteReportGroup.setLayout((Layout)new GridLayout());
        this.testSuiteReportGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.cbSendTestSuiteReport = new Button((Composite)this.testSuiteReportGroup, 32);
        this.cbSendTestSuiteReport.setText(ComposerExecutionMessageConstants.MailSettingsPage_MSG_ENABLE_TEST_SUITE_REPORT);
        GridData gdRadio = new GridData(4, 2, true, false, 1, 1);
        gdRadio.horizontalIndent = 15;
        this.rbSendReportAllTestSuites = new Button((Composite)this.testSuiteReportGroup, 16);
        this.rbSendReportAllTestSuites.setLayoutData((Object)gdRadio);
        this.rbSendReportAllTestSuites.setText(StringConstants.DIA_MSG_SEND_EMAIL_REPORT_FOR_ALL_CASES);
        this.rbSendReportFailedTestSuites = new Button((Composite)this.testSuiteReportGroup, 16);
        this.rbSendReportFailedTestSuites.setLayoutData((Object)gdRadio);
        this.rbSendReportFailedTestSuites.setText(StringConstants.DIA_MSG_SEND_EMAIL_REPORT_FOR_FAILED_TEST_ONLY);
    }

    private void setTestSuiteReportGroupEnabled(boolean enabled) {
        this.rbSendReportAllTestSuites.setEnabled(enabled);
        this.rbSendReportFailedTestSuites.setEnabled(enabled);
    }

    private void addTestSuiteCollectionReportGroup(Composite container) {
        this.testSuiteCollectionReportGroup = new Group(container, 0);
        this.testSuiteCollectionReportGroup.setLayout((Layout)new GridLayout());
        this.testSuiteCollectionReportGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.cbSendTestSuiteCollectionReport = new Button((Composite)this.testSuiteCollectionReportGroup, 32);
        this.cbSendTestSuiteCollectionReport.setText(ComposerExecutionMessageConstants.MailSettingsPage_MSG_ENABLE_COLLECTION_REPORT);
        this.cbSkipIndividualTestSuiteReport = new Button((Composite)this.testSuiteCollectionReportGroup, 32);
        GridData gdRadio = new GridData(4, 2, true, false, 1, 1);
        gdRadio.horizontalIndent = 15;
        this.cbSkipIndividualTestSuiteReport.setLayoutData((Object)gdRadio);
        this.cbSkipIndividualTestSuiteReport.setText(ComposerExecutionMessageConstants.MailSettingsPage_MSG_SKIP_SENDING_INDIVIDUAL_REPORT);
    }

    private void setTestSuiteCollectionReportGroupEnabled(boolean enabled) {
        this.cbSkipIndividualTestSuiteReport.setEnabled(enabled);
    }

    private void createSendTestEmailButton(Composite parent) {
        this.btnSendTestEmail = new Button(parent, 8);
        this.btnSendTestEmail.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnSendTestEmail.setText(ComposerExecutionMessageConstants.PREF_LBL_SEND_TEST_EMAIL);
    }

    private void createServerGroup(Composite container) {
        Group serverGroup = MailSettingsPage.createGroup(container, StringConstants.PREF_GROUP_LBL_MAIL_SERVER, 4, 1, 768);
        this.txtHost = this.createTextFieldWithLabel((Composite)serverGroup, StringConstants.PREF_LBL_HOST, MAIL_CONFIG_HOST_HINT, 1);
        this.txtPort = this.createTextFieldWithLabel((Composite)serverGroup, StringConstants.PREF_LBL_PORT, MAIL_CONFIG_PORT_HINT, 1);
        this.txtUsername = this.createTextFieldWithLabel((Composite)serverGroup, StringConstants.PREF_LBL_USERNAME, MAIL_CONFIG_USERNAME_HINT, 1);
        this.txtPassword = this.createTextFieldWithLabel((Composite)serverGroup, StringConstants.PREF_LBL_PASSWORD, "", 1);
        this.txtPassword.setEchoChar('\u2022');
        this.createLabel((Composite)serverGroup, StringConstants.PREF_LBL_SECURITY_PROTOCOL);
        this.comboProtocol = new Combo((Composite)serverGroup, 8);
        this.comboProtocol.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.comboProtocol.setItems(MailUtil.MailSecurityProtocolType.getStringValues());
        this.chckEncrypt = new Button((Composite)serverGroup, 32);
        this.chckEncrypt.setLayoutData((Object)new GridData(4, 2, true, false, 4, 1));
        this.chckEncrypt.setText(ComposerExecutionMessageConstants.PREF_CHECK_ENABLE_AUTHENTICATION_ENCRYPTION);
    }

    private void sendTestEmail(final EmailConfig conf) {
        String message = ComposerExecutionMessageConstants.PREF_MSG_TEST_EMAIL_IS_SENT_SUCCESSFULLY;
        String messageTitle = StringConstants.INFO;
        int messageType = 2;
        Shell shell = this.getShell();
        try {
            try {
                new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(StringConstants.PREF_SEND_TEST_EMAIL_JOB_NAME, -1);
                        try {
                            try {
                                MailUtil.sendTestMail((EmailConfig)conf);
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException ex) {
                Throwable rootException = ex.getTargetException();
                LoggerSingleton.logError((Throwable)rootException);
                messageTitle = StringConstants.ERROR;
                messageType = 1;
                message = rootException.getMessage();
                if (StringUtils.startsWith((String)message, (String)ComposerExecutionMessageConstants.PREF_FAILED_APACHE_MAIL_PREFIX_ERROR_MSG)) {
                    message = StringUtils.removeStart((String)message, (String)ComposerExecutionMessageConstants.PREF_FAILED_APACHE_MAIL_PREFIX_ERROR_MSG);
                    message = MessageFormat.format(ComposerExecutionMessageConstants.PREF_REPLACEMENT_APACHE_MAIL_ERROR_MSG, message);
                }
                MessageDialogWithLink.open((int)messageType, (Shell)shell, (String)messageTitle, (String)message, (int)0);
            }
            catch (InterruptedException ex) {
                LoggerSingleton.logError((Throwable)ex);
                MessageDialogWithLink.open((int)messageType, (Shell)shell, (String)messageTitle, (String)message, (int)0);
            }
        }
        finally {
            MessageDialogWithLink.open((int)messageType, (Shell)shell, (String)messageTitle, (String)message, (int)0);
        }
    }

    private Text createTextFieldWithLabel(Composite parent, String labelText, String hintText, int hspan) {
        this.createLabel(parent, labelText);
        Text txtField = new Text(parent, 2052);
        GridData gridData = new GridData(4, 2, true, false, hspan, 1);
        txtField.setLayoutData((Object)gridData);
        if (!ControlUtils.isDarkTheme((Display)txtField.getDisplay())) {
            txtField.setMessage(hintText);
        }
        return txtField;
    }

    private void createLabel(Composite parent, String labelText) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 2, false, false, 1, 1));
        label.setText(labelText);
    }

    private Composite createComposite(Composite parent, int numColumns, int horizontalSpan) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true, horizontalSpan, 1));
        container.setLayout((Layout)new GridLayout(numColumns, false));
        return container;
    }

    private static Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_EMAIL;
    }

    private class EmailConfigValidator {
        private Map<String, Boolean> validation = new HashMap<String, Boolean>();
        private static final String EMAIL_TEXT_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";

        public EmailConfigValidator() {
            this.validation.put("host", false);
            this.validation.put("port", false);
            this.validation.put("username", true);
            this.validation.put("password", true);
            this.validation.put("sender", true);
            this.validation.put("recipients", true);
            this.validation.put("cc", true);
            this.validation.put("bcc", true);
        }

        private boolean isValidated() {
            return this.validation.entrySet().parallelStream().filter(field -> (Boolean)field.getValue() == false).count() <= 0L;
        }

        public void setValidation(String key, boolean value) {
            this.validation.put(key, value);
        }
    }
}

