/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.dialogs.wizard;

import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.checkpoint.dialogs.wizard.AbstractCheckpointWizardPage;
import com.kms.katalon.composer.components.impl.components.ConnectionPropertyTable;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.controller.DatabaseController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.db.DBConnectionProperties;
import com.kms.katalon.core.db.DatabaseConnection;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.checkpoint.DatabaseCheckpointSourceInfo;
import java.io.IOException;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewCheckpointDatabasePage
extends AbstractCheckpointWizardPage {
    private static final String WIZ_DATABASE_SOURCE_CONFIGURATION = com.kms.katalon.composer.checkpoint.constants.StringConstants.WIZ_DATABASE_SOURCE_CONFIGURATION;
    private static final String DATABASE = com.kms.katalon.composer.checkpoint.constants.StringConstants.WIZ_TITLE_DATABASE;
    private static final String JDBC_PROTOCOL = "jdbc:";
    protected Button chkGlobalDBSetting;
    protected Button chkSecureUserPassword;
    protected Text txtUser;
    protected Text txtPassword;
    protected Button btnTestConnection;
    protected Label lblStatus;
    protected Text txtConnectionURL;
    protected Text txtQuery;
    private GridData gdLblOptionsDB;
    private GridData gdTxtDriverClassName;
    private Label lblOptionsDB;
    protected Text txtDriverClassName;
    private Composite compDatabase;
    private ConnectionPropertyTable connectionPropertyTable = new ConnectionPropertyTable(this.getShell());

    public NewCheckpointDatabasePage() {
        super(NewCheckpointDatabasePage.class.getSimpleName(), DATABASE, WIZ_DATABASE_SOURCE_CONFIGURATION);
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 2560);
        Composite container = new Composite((Composite)sc, 0);
        GridLayout glContainer = new GridLayout();
        glContainer.marginHeight = 0;
        glContainer.marginWidth = 0;
        container.setLayout((Layout)glContainer);
        this.createDatabasePart(container);
        this.createQueryPart(container);
        this.setControlListeners();
        this.setControl((Control)container);
        this.setInput();
        this.setPageComplete(this.isComplete());
        sc.setContent((Control)container);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
    }

    private void setInput() {
        this.enableCustomDBConnection(!this.chkGlobalDBSetting.getSelection());
        this.connectionPropertyTable.setTableInput(new ArrayList());
        this.connectionPropertyTable.redrawTable();
    }

    protected void showDriverComposite() {
        if (!LicenseUtil.isNotFreeLicense()) {
            this.gdLblOptionsDB.heightHint = 0;
            this.gdTxtDriverClassName.heightHint = 0;
            this.txtDriverClassName.setVisible(false);
            this.lblOptionsDB.setVisible(false);
            this.compDatabase.layout(true);
        }
    }

    private void createDatabasePart(Composite parent) {
        this.compDatabase = new Composite(parent, 0);
        this.compDatabase.setLayout((Layout)new GridLayout());
        this.compDatabase.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpDatabase = new Group(this.compDatabase, 0);
        grpDatabase.setLayout((Layout)new GridLayout());
        grpDatabase.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpDatabase.setText(StringConstants.DIA_GRP_DATABASE_CONNECTION);
        Composite databaseComposite = new Composite((Composite)grpDatabase, 0);
        databaseComposite.setLayout((Layout)new GridLayout(2, false));
        databaseComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chkGlobalDBSetting = new Button(databaseComposite, 32);
        this.chkGlobalDBSetting.setText(StringConstants.DIA_CHK_USE_GLOBAL_DB_SETTINGS);
        this.chkGlobalDBSetting.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new Label(databaseComposite, 0);
        this.chkSecureUserPassword = new Button(databaseComposite, 32);
        this.chkSecureUserPassword.setText(StringConstants.DIA_CHK_SECURE_USER_PASSWORD);
        this.chkSecureUserPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblUser = new Label(databaseComposite, 0);
        lblUser.setText(StringConstants.DIA_LBL_USER);
        lblUser.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtUser = new Text(databaseComposite, 2048);
        this.txtUser.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label(databaseComposite, 0);
        lblPassword.setText(StringConstants.DIA_LBL_PASSWORD);
        lblPassword.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtPassword = new Text(databaseComposite, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblOptionsDB = new Label(databaseComposite, 0);
        this.lblOptionsDB.setText("JDBC driver");
        this.gdLblOptionsDB = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.lblOptionsDB.setLayoutData((Object)this.gdLblOptionsDB);
        this.txtDriverClassName = new Text(databaseComposite, 2048);
        this.gdTxtDriverClassName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtDriverClassName.setLayoutData((Object)this.gdTxtDriverClassName);
        Label lblConnectionURL = new Label(databaseComposite, 0);
        lblConnectionURL.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblConnectionURL.setText(StringConstants.DIA_LBL_CONNECTION_URL);
        this.txtConnectionURL = new Text(databaseComposite, 2626);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        layoutData.heightHint = 80;
        this.txtConnectionURL.setLayoutData((Object)layoutData);
        this.connectionPropertyTable.createContent((Composite)grpDatabase);
        this.createTestConnectionComposite(this.connectionPropertyTable.getTableComposite());
        this.createConnectionUrlSample((Composite)grpDatabase);
    }

    private void createTestConnectionComposite(Composite composite) {
        Composite compTestConn = new Composite(composite, 0);
        GridLayout glTestConn = new GridLayout(2, false);
        glTestConn.marginHeight = 0;
        glTestConn.marginWidth = 0;
        compTestConn.setLayout((Layout)glTestConn);
        compTestConn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTestConnection = new Button(compTestConn, 0);
        this.btnTestConnection.setText(StringConstants.DIA_BTN_TEST_CONNECTION);
        this.lblStatus = new Label(compTestConn, 0);
        this.lblStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void createConnectionUrlSample(Composite parent) {
        Composite compSample = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        compSample.setLayout((Layout)layout);
        compSample.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblSampleURL = new Label(compSample, 0);
        lblSampleURL.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblSampleURL.setText(StringConstants.DIA_LBL_CONNECTION_URL_SAMPLE);
        Label separator = new Label(compSample, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.addLink(parent, StringConstants.DIA_LNK_MYSQL, StringConstants.DIA_LINK_MYSQL_DOC);
        Text txtMySQLURL = new Text(parent, 8);
        txtMySQLURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtMySQLURL.setText(StringConstants.DIA_TXT_MYSQL_SAMPLE_LINK);
        this.addLink(parent, StringConstants.DIA_LNK_SQL_SERVER, StringConstants.DIA_LINK_DB_SETTINGS_DOC);
        Text txtSQLServerURL = new Text(parent, 8);
        txtSQLServerURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtSQLServerURL.setText(StringConstants.DIA_TXT_SQL_SERVER_SAMPLE_LINK);
        this.addLink(parent, StringConstants.DIA_LNK_ORACLE_SQL, StringConstants.DIA_LINK_DB_SETTINGS_DOC);
        Text txtOracleSQLURL1 = new Text(parent, 74);
        txtOracleSQLURL1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtOracleSQLURL1.setText(StringConstants.DIA_TXT_ORACLE_SQL_SAMPLE_THIN_LINK);
        new Label(parent, 0);
        Text txtOracleSQLURL2 = new Text(parent, 8);
        txtOracleSQLURL2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtOracleSQLURL2.setText(StringConstants.DIA_TXT_ORACLE_SQL_SAMPLE_OCI_LINK);
        this.addLink(parent, StringConstants.DIA_LNK_POSTGRESQL, StringConstants.DIA_LINK_DB_SETTINGS_DOC);
        Text txtPostgreSQLURL = new Text(parent, 8);
        txtPostgreSQLURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtPostgreSQLURL.setText(StringConstants.DIA_TXT_POSTGRESQL_SAMPLE_LINK);
    }

    private void createQueryPart(Composite parent) {
        Composite compQuery = new Composite(parent, 0);
        compQuery.setLayout((Layout)new GridLayout());
        compQuery.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group grpQuery = new Group(compQuery, 0);
        grpQuery.setLayout((Layout)new GridLayout());
        grpQuery.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpQuery.setText(StringConstants.DIA_LBL_SQL_QUERY);
        this.txtQuery = new Text((Composite)grpQuery, 2626);
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        layoutData.minimumHeight = 80;
        this.txtQuery.setLayoutData((Object)layoutData);
    }

    private void setControlListeners() {
        this.chkGlobalDBSetting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewCheckpointDatabasePage.this.enableCustomDBConnection(!NewCheckpointDatabasePage.this.chkGlobalDBSetting.getSelection());
                NewCheckpointDatabasePage.this.setPageComplete(NewCheckpointDatabasePage.this.isComplete());
            }
        });
        this.chkSecureUserPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewCheckpointDatabasePage.this.enableUserPassword(NewCheckpointDatabasePage.this.chkSecureUserPassword.getSelection());
            }
        });
        this.btnTestConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassLoader oldClassLoader = null;
                DatabaseConnection dbConn = NewCheckpointDatabasePage.this.getDatabaseConnection();
                try {
                    oldClassLoader = Thread.currentThread().getContextClassLoader();
                    URLClassLoader projectClassLoader = ProjectController.getInstance().getProjectClassLoader(ProjectController.getInstance().getCurrentProject());
                    Thread.currentThread().setContextClassLoader(projectClassLoader);
                    if (NewCheckpointDatabasePage.this.chkGlobalDBSetting.getSelection()) {
                        dbConn = DatabaseController.getInstance().getGlobalDatabaseConnection();
                    }
                    if (dbConn == null) {
                        NewCheckpointDatabasePage.this.setStatusLabel(MessageFormat.format(StringConstants.DIA_LBL_TEST_STATUS_FAIL, StringConstants.DIA_MSG_CONNECTION_EMPTY), ColorUtil.getTextErrorColor());
                        return;
                    }
                    dbConn.getConnection();
                    if (!dbConn.isAlive()) {
                        NewCheckpointDatabasePage.this.setStatusLabel(MessageFormat.format(StringConstants.DIA_LBL_TEST_STATUS_FAIL, StringConstants.DIA_LBL_CONNECTION_CLOSED), ColorUtil.getTextErrorColor());
                        return;
                    }
                    try {
                        NewCheckpointDatabasePage.this.setStatusLabel(StringConstants.DIA_LBL_TEST_STATUS_SUCCESS, ColorUtil.getTextSuccessfulColor());
                    }
                    catch (IOException | SQLException | CoreException ex) {
                        NewCheckpointDatabasePage.this.setStatusLabel(MessageFormat.format(StringConstants.DIA_LBL_TEST_STATUS_FAIL, ex.getMessage()), ColorUtil.getTextErrorColor());
                    }
                }
                finally {
                    if (dbConn != null) {
                        dbConn.close();
                    }
                    if (oldClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                }
            }
        });
        this.lblStatus.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (NewCheckpointDatabasePage.this.lblStatus.getText().isEmpty()) {
                    return;
                }
                MessageDialog.openInformation((Shell)NewCheckpointDatabasePage.this.getShell(), (String)StringConstants.DIA_TITLE_STATUS_DETAILS, (String)NewCheckpointDatabasePage.this.lblStatus.getToolTipText());
            }
        });
        this.txtUser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCheckpointDatabasePage.this.setPageComplete(NewCheckpointDatabasePage.this.isComplete());
            }
        });
        this.txtConnectionURL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCheckpointDatabasePage.this.setPageComplete(NewCheckpointDatabasePage.this.isComplete());
            }
        });
        this.txtQuery.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCheckpointDatabasePage.this.setPageComplete(NewCheckpointDatabasePage.this.isComplete());
            }
        });
    }

    private DatabaseConnection getDatabaseConnection() {
        String user = null;
        String password = null;
        if (this.chkSecureUserPassword.getSelection()) {
            user = this.txtUser.getText();
            password = this.txtPassword.getText();
        }
        if (!StringUtils.startsWithIgnoreCase((String)this.txtConnectionURL.getText(), (String)JDBC_PROTOCOL)) {
            return null;
        }
        DatabaseConnection connection = new DatabaseConnection(this.txtConnectionURL.getText(), user, password, this.txtDriverClassName.getText());
        connection.setConnectionProperties(this.connectionPropertyTable.getConnectionProperties());
        return connection;
    }

    protected void enableCustomDBConnection(boolean enabled) {
        this.chkSecureUserPassword.setEnabled(enabled);
        this.enableUserPassword(enabled && this.chkSecureUserPassword.getSelection());
        this.txtConnectionURL.setEnabled(enabled);
        this.txtDriverClassName.setEnabled(enabled);
        this.connectionPropertyTable.enableConnectionPropertiesArea(enabled);
    }

    private void enableUserPassword(boolean enabled) {
        this.txtUser.setEnabled(enabled);
        this.txtPassword.setEnabled(enabled);
    }

    private void setStatusLabel(String msg, Color msgColor) {
        this.lblStatus.setCursor(Display.getCurrent().getSystemCursor(21));
        this.lblStatus.setForeground(msgColor);
        this.lblStatus.setText(StringUtils.abbreviate((String)msg, (int)80));
        this.lblStatus.setToolTipText(msg);
    }

    private Link addLink(Composite parent, String label, final String hyperlink) {
        Link link = new Link(parent, 0);
        link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        link.setText(String.valueOf(label) + " (<a href=\"" + hyperlink + "\">Docs</a>)");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)hyperlink);
            }
        });
        return link;
    }

    @Override
    protected boolean isComplete() {
        boolean isQueryNotBlank = StringUtils.isNotBlank((String)this.txtQuery.getText());
        if (this.chkGlobalDBSetting.getSelection()) {
            return isQueryNotBlank;
        }
        if (this.chkSecureUserPassword.getSelection()) {
            isQueryNotBlank &= StringUtils.isNotBlank((String)this.txtUser.getText());
        }
        return isQueryNotBlank && StringUtils.startsWith((String)this.txtConnectionURL.getText(), (String)JDBC_PROTOCOL);
    }

    @Override
    public Point getPageSize() {
        return this.getShell().computeSize(-1, -1);
    }

    public CheckpointSourceInfo getSourceInfo() {
        DBConnectionProperties connectionProperties = new DBConnectionProperties(this.connectionPropertyTable.getListConnectionPropeties());
        if (((Object)((Object)this)).equals(this.getContainer().getCurrentPage())) {
            return new DatabaseCheckpointSourceInfo(this.txtConnectionURL.getText(), this.chkGlobalDBSetting.getSelection(), this.chkSecureUserPassword.getSelection(), this.txtUser.getText(), Base64.encode((String)this.txtPassword.getText()), this.txtQuery.getText(), this.txtDriverClassName.getText(), connectionProperties);
        }
        return new DatabaseCheckpointSourceInfo();
    }
}

