/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.dialogs.wizard;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.checkpoint.dialogs.wizard.AbstractCheckpointWizardPage;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.osgi.framework.FrameworkUtil;

public class NewCheckpointTestDataPage
extends AbstractCheckpointWizardPage {
    private String pluginId = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();
    private Text txtTestDataId;
    private Button btnBrowse;

    public NewCheckpointTestDataPage() {
        super(NewCheckpointTestDataPage.class.getSimpleName(), StringConstants.TEST_DATA, StringConstants.WIZ_TEST_DATA_SOURCE_CONFIGURATION);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblSourceUrl = new Label(container, 0);
        lblSourceUrl.setText(StringConstants.TEST_DATA);
        this.txtTestDataId = new Text(container, 2056);
        this.txtTestDataId.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnBrowse = new Button(container, 0x800008);
        this.btnBrowse.setText(StringConstants.BROWSE);
        this.btnBrowse.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.setControlListeners();
        this.setControl((Control)container);
        this.setPageComplete(this.isComplete());
    }

    private void setControlListeners() {
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
                    if (currentProject == null) {
                        return;
                    }
                    FolderEntity rootFolder = FolderController.getInstance().getTestDataRoot(currentProject);
                    EntityProvider entityProvider = new EntityProvider();
                    TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(NewCheckpointTestDataPage.this.getShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)entityProvider, (AbstractEntityViewerFilter)new EntityViewerFilter(entityProvider));
                    dialog.setAllowMultiple(false);
                    dialog.setTitle(StringConstants.PART_TITLE_TEST_DATA_BROWSER);
                    dialog.setInput((Object)TreeEntityUtil.getChildren(null, (FolderEntity)rootFolder));
                    String testDataId = NewCheckpointTestDataPage.this.txtTestDataId.getText();
                    if (StringUtils.isNotBlank((String)testDataId)) {
                        DataFileEntity testDataEntity = TestDataController.getInstance().getTestDataByDisplayId(testDataId);
                        TestDataTreeEntity testDataTreeEntity = TreeEntityUtil.getTestDataTreeEntity((DataFileEntity)testDataEntity, (ProjectEntity)currentProject);
                        dialog.setInitialSelection((Object)testDataTreeEntity);
                    }
                    dialog.setValidator(new ISelectionStatusValidator(){

                        public IStatus validate(Object[] selection) {
                            if (selection == null || selection.length == 0 || !(selection[0] instanceof TestDataTreeEntity)) {
                                return new Status(4, (this).NewCheckpointTestDataPage.this.pluginId, 4, StringConstants.PART_MSG_PLEASE_SELECT_A_TEST_DATA, null);
                            }
                            return new Status(0, (this).NewCheckpointTestDataPage.this.pluginId, 0, StringConstants.EMPTY, null);
                        }
                    });
                    if (dialog.open() != 0) {
                        return;
                    }
                    Object[] selectedItems = dialog.getResult();
                    if (selectedItems == null || selectedItems.length == 0 || !(selectedItems[0] instanceof TestDataTreeEntity)) {
                        return;
                    }
                    DataFileEntity testData = ((TestDataTreeEntity)selectedItems[0]).getObject();
                    NewCheckpointTestDataPage.this.txtTestDataId.setText(testData.getIdForDisplay());
                    NewCheckpointTestDataPage.this.setPageComplete(NewCheckpointTestDataPage.this.isComplete());
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.WARN, (String)StringConstants.PART_MSG_UNABLE_TO_SELECT_TEST_DATA);
                }
            }
        });
    }

    public CheckpointSourceInfo getSourceInfo() {
        String testDataId = StringConstants.EMPTY;
        if (((Object)((Object)this)).equals(this.getContainer().getCurrentPage())) {
            testDataId = this.txtTestDataId.getText();
        }
        return new CheckpointSourceInfo(testDataId);
    }

    @Override
    protected boolean isComplete() {
        return StringUtils.isNotBlank((String)this.txtTestDataId.getText());
    }

    @Override
    public Point getPageSize() {
        return this.getShell().computeSize(600, 300);
    }
}

